/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.plugin.WikiPlugin;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.util.RegExpUtil;
import org.apache.wiki.util.StringTransmutator;
import org.apache.wiki.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFilteredPlugin
implements WikiPlugin {
    private static Logger log = LoggerFactory.getLogger(AbstractFilteredPlugin.class);
    public static final int ALL_ITEMS = -1;
    public static final String PARAM_MAXWIDTH = "maxwidth";
    public static final String PARAM_SEPARATOR = "separator";
    public static final String PARAM_AFTER = "after";
    public static final String PARAM_BEFORE = "before";
    public static final String PARAM_EXCLUDE = "exclude";
    public static final String PARAM_INCLUDE = "include";
    public static final String PARAM_SHOW = "show";
    public static final String PARAM_SHOW_VALUE_PAGES = "pages";
    public static final String PARAM_SHOW_VALUE_COUNT = "count";
    public static final String PARAM_LASTMODIFIED = "showLastModified";
    public static final String PARAM_SHOW_ATTACHMENTS = "showAttachments";
    protected int m_maxwidth = Integer.MAX_VALUE;
    protected String m_before = "";
    protected String m_separator = "";
    protected String m_after = "\\\\";
    protected Pattern[] m_exclude = new Pattern[]{Pattern.compile("^$")};
    protected Pattern[] m_include = new Pattern[]{Pattern.compile(".*")};
    protected boolean m_showAttachments = true;
    protected String m_show = "pages";
    protected boolean m_lastModified = false;
    protected Date m_dateLastModified = new Date(0L);
    protected SimpleDateFormat m_dateFormat;
    protected WikiEngine m_engine;

    public void initialize(WikiContext context, Map<String, Object> params) throws PluginException {
        String pattern;
        int i;
        String[] ptrns;
        String s;
        String showAttachmentsString;
        Preferences prefs = Preferences.getPreferences(context.getHttpRequest());
        this.m_dateFormat = prefs.getDateFormat(Preferences.TimeFormat.DATETIME);
        this.m_engine = context.getEngine();
        this.m_maxwidth = TextUtil.parseIntParameter((String)params.get(PARAM_MAXWIDTH), Integer.MAX_VALUE);
        if (this.m_maxwidth < 0) {
            this.m_maxwidth = 0;
        }
        if ("false".equals(showAttachmentsString = (String)params.get(PARAM_SHOW_ATTACHMENTS))) {
            this.m_showAttachments = false;
        }
        if ((s = (String)params.get(PARAM_SEPARATOR)) != null) {
            this.m_separator = s;
            this.m_after = "";
        }
        if ((s = (String)params.get(PARAM_BEFORE)) != null) {
            this.m_before = s;
        }
        if ((s = (String)params.get(PARAM_AFTER)) != null) {
            this.m_after = s;
        }
        if ((s = (String)params.get(PARAM_EXCLUDE)) != null) {
            try {
                ptrns = StringUtils.split((String)s, (String)",");
                this.m_exclude = new Pattern[ptrns.length];
                i = 0;
                while (i < ptrns.length) {
                    pattern = ptrns[i];
                    this.m_exclude[i] = Pattern.compile(RegExpUtil.globToPerl5(pattern.toCharArray(), 0));
                    ++i;
                }
            }
            catch (PatternSyntaxException e) {
                throw new PluginException(String.valueOf(context.getBundle("plugin.PluginResources").getString("plugin.abstract.excludeparm.malformed")) + e.getMessage());
            }
        }
        if ((s = (String)params.get(PARAM_INCLUDE)) != null) {
            try {
                ptrns = StringUtils.split((String)s, (String)",");
                this.m_include = new Pattern[ptrns.length];
                i = 0;
                while (i < ptrns.length) {
                    pattern = ptrns[i];
                    this.m_include[i] = Pattern.compile(RegExpUtil.globToPerl5(pattern.toCharArray(), 0));
                    ++i;
                }
            }
            catch (PatternSyntaxException e) {
                throw new PluginException(String.valueOf(context.getBundle("plugin.PluginResources").getString("plugin.abstract.includeparm.malformed")) + e.getMessage());
            }
        }
        if ((s = (String)params.get(PARAM_SHOW)) != null && s.equalsIgnoreCase(PARAM_SHOW_VALUE_COUNT)) {
            this.m_show = PARAM_SHOW_VALUE_COUNT;
        }
        if ((s = (String)params.get(PARAM_LASTMODIFIED)) != null && s.equalsIgnoreCase("true")) {
            if (this.m_show.equals(PARAM_SHOW_VALUE_COUNT)) {
                this.m_lastModified = true;
            } else {
                throw new PluginException(context.getBundle("plugin.PluginResources").getString("plugin.abstract.showLastModified"));
            }
        }
    }

    protected <T> List<T> filterCollection(List<T> items) {
        ListIterator<T> iterator = items.listIterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            String pageName = this.getPageName(item);
            boolean include = this.filterItem(pageName);
            if (include) {
                boolean isAttachment = pageName.contains("/");
                if (isAttachment && !this.m_showAttachments) {
                    include = false;
                }
                this.updateHighWaterMark(pageName);
            }
            if (include) continue;
            iterator.remove();
        }
        return items;
    }

    private String getPageName(Object item) {
        if (item instanceof WikiPage) {
            return ((WikiPage)item).getName();
        }
        if (item instanceof WikiPath) {
            return ((WikiPath)item).getName();
        }
        if (item instanceof String) {
            return (String)item;
        }
        throw new IllegalArgumentException("Item must be WikiPage, WikiPath or String.");
    }

    private boolean filterItem(String pageName) {
        Matcher matcher;
        int j;
        boolean include;
        boolean bl = include = this.m_include == null;
        if (this.m_include != null && pageName != null) {
            j = 0;
            while (j < this.m_include.length) {
                matcher = this.m_include[j].matcher(pageName);
                if (matcher.matches()) {
                    include = true;
                    break;
                }
                ++j;
            }
        }
        if (this.m_exclude != null && pageName != null) {
            j = 0;
            while (j < this.m_exclude.length) {
                matcher = this.m_exclude[j].matcher(pageName);
                if (matcher.matches()) {
                    include = false;
                    break;
                }
                ++j;
            }
        }
        return include;
    }

    private void updateHighWaterMark(String pageName) {
        WikiPage page = null;
        if (this.m_lastModified) {
            try {
                page = this.m_engine.getPage(pageName);
                Date lastModPage = page.getLastModified();
                if (log.isDebugEnabled()) {
                    log.debug("lastModified Date of page " + pageName + " : " + this.m_dateLastModified, new Object[0]);
                }
                if (lastModPage.after(this.m_dateLastModified)) {
                    this.m_dateLastModified = lastModPage;
                }
            }
            catch (PageNotFoundException lastModPage) {
            }
            catch (ProviderException e) {
                log.debug("Error while getting page data", e, new Object[0]);
            }
        }
    }

    protected static String sanitizePattern(String pattern) {
        boolean hasSpace = false;
        boolean nameIsPrefix = false;
        int i = 0;
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (!(ch == ' ' || ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z')) {
                if (i > 0 && nameIsPrefix && ch == ':') {
                    if (pattern.charAt(i - 1) == '\\') {
                        hasSpace = true;
                        break;
                    }
                    pattern = String.valueOf(pattern.substring(0, i)) + pattern.substring(i, pattern.length());
                    hasSpace = true;
                    break;
                }
                if (!nameIsPrefix) break;
                hasSpace = false;
                break;
            }
            nameIsPrefix = true;
            ++i;
        }
        return nameIsPrefix && !hasSpace ? "Main:" + pattern : pattern;
    }

    protected String wikitizeCollection(Collection<WikiPath> links, String separator, int maxItems) {
        if (links == null || links.isEmpty()) {
            return "";
        }
        StringBuilder markup = new StringBuilder();
        Iterator<WikiPath> it = links.iterator();
        int count = 0;
        while (it.hasNext() && (count < maxItems || maxItems == -1)) {
            String link = it.next().getName();
            if (count > 0) {
                markup.append(this.m_after);
                markup.append(this.m_separator);
            }
            markup.append(this.m_before);
            markup.append("[" + this.m_engine.beautifyTitle(link) + "|" + link + "]");
            ++count;
        }
        if (count > 0) {
            markup.append(this.m_after);
        }
        return markup.toString();
    }

    protected String makeHTML(WikiContext context, String wikitext) {
        String result = "";
        RenderingManager mgr = this.m_engine.getRenderingManager();
        try {
            MarkupParser parser = mgr.getParser(context, wikitext);
            parser.addLinkTransmutator(new CutMutator(this.m_maxwidth));
            parser.enableImageInlining(false);
            WikiDocument doc = parser.parse();
            result = mgr.getHTML(context, doc);
        }
        catch (IOException e) {
            log.error("Failed to convert page data to HTML", e);
        }
        return result;
    }

    private static class CutMutator
    implements StringTransmutator {
        private int m_length;

        public CutMutator(int length) {
            this.m_length = length;
        }

        public String mutate(WikiContext context, String text) {
            if (text.length() > this.m_length) {
                return String.valueOf(text.substring(0, this.m_length)) + "...";
            }
            return text;
        }
    }
}

