/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.parser;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.parser.JSPWikiMarkupParser;
import org.apache.wiki.parser.WikiDocument;
import org.jdom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginContent
extends Text {
    private static final String BLANK = "";
    private static final String CMDLINE = "_cmdline";
    private static final String ELEMENT_BR = "<br/>";
    private static final String EMITTABLE_PLUGINS = "Image|FormOpen|FormClose|FormInput|FormTextarea|FormSelect";
    private static final String LINEBREAK = "\n";
    private static final String PLUGIN_START = "[{";
    private static final String PLUGIN_END = "}]";
    private static final String SPACE = " ";
    private static final long serialVersionUID = 1L;
    private String m_pluginName;
    private Map<String, Object> m_params;

    public PluginContent(String pluginName, Map<String, Object> parameters) {
        this.m_pluginName = pluginName;
        this.m_params = parameters;
    }

    public String getPluginName() {
        return this.m_pluginName;
    }

    public Object getParameter(String name) {
        return this.m_params.get(name);
    }

    public Map<String, Object> getParameters() {
        return this.m_params;
    }

    public String getValue() {
        return this.getText();
    }

    public String getText() {
        String result;
        block9: {
            boolean wysiwygEditorMode;
            WikiContext context;
            block10: {
                WikiDocument doc = (WikiDocument)this.getDocument();
                if (doc == null) {
                    return this.getPluginName();
                }
                context = doc.getContext();
                Boolean wysiwygVariable = (Boolean)context.getVariable("WYSIWYG_EDITOR_MODE");
                wysiwygEditorMode = false;
                if (wysiwygVariable != null) {
                    wysiwygEditorMode = wysiwygVariable;
                }
                if (wysiwygEditorMode && !this.m_pluginName.matches(EMITTABLE_PLUGINS)) {
                    result = PLUGIN_START + this.m_pluginName + SPACE;
                    String cmdLine = ((String)this.m_params.get(CMDLINE)).replaceAll(LINEBREAK, ELEMENT_BR);
                    result = String.valueOf(result) + cmdLine + PLUGIN_END;
                    break block9;
                }
                Boolean b = (Boolean)context.getVariable("_PluginContent.execute");
                if (b == null || b.booleanValue()) break block10;
                return BLANK;
            }
            try {
                WikiEngine engine = context.getEngine();
                HashMap<String, Object> parsedParams = new HashMap<String, Object>();
                for (Map.Entry<String, Object> e : this.m_params.entrySet()) {
                    Object val = e.getValue();
                    if (val instanceof String) {
                        val = engine.getVariableManager().expandVariables(context, (String)val);
                    }
                    parsedParams.put(e.getKey(), val);
                }
                result = engine.getPluginManager().execute(context, this.m_pluginName, parsedParams);
            }
            catch (Exception e) {
                if (wysiwygEditorMode) {
                    result = BLANK;
                    break block9;
                }
                ResourceBundle rb = context.getBundle("plugin.PluginResources");
                Object[] args = new Object[]{e.getMessage()};
                result = JSPWikiMarkupParser.makeError(MessageFormat.format(rb.getString("plugin.error.insertionfailed"), args)).getText();
            }
        }
        return result;
    }

    public void executeParse(WikiContext context) throws PluginException {
        context.getEngine().getPluginManager().executeParse(this, context);
    }
}

