/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.parser.HeadingListener;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.util.StringTransmutator;

public abstract class MarkupParser {
    protected static final int PUSHBACK_BUFFER_SIZE = 10240;
    protected PushbackReader m_in;
    private int m_pos = -1;
    protected WikiEngine m_engine;
    protected WikiContext m_context;
    protected ArrayList<StringTransmutator> m_localLinkMutatorChain = new ArrayList();
    protected ArrayList<StringTransmutator> m_externalLinkMutatorChain = new ArrayList();
    protected ArrayList<StringTransmutator> m_attachmentLinkMutatorChain = new ArrayList();
    protected ArrayList<HeadingListener> m_headingListenerChain = new ArrayList();
    protected ArrayList<StringTransmutator> m_linkMutators = new ArrayList();
    protected boolean m_inlineImages = true;
    protected boolean m_parseAccessRules = true;
    public static final String PROP_ALLOWHTML = "jspwiki.translatorReader.allowHTML";
    public static final String PROP_RUNPLUGINS = "jspwiki.translatorReader.runPlugins";
    protected static final String LEGACY_CHARS_ALLOWED = "._";
    public static final String PUNCTUATION_CHARS_ALLOWED = " ()&+,-=._$";

    protected MarkupParser(WikiContext context, Reader in) {
        this.m_engine = context.getEngine();
        this.m_context = context;
        this.setInputReader(in);
    }

    public Reader setInputReader(Reader in) {
        PushbackReader old = this.m_in;
        if (in != null) {
            this.m_in = new PushbackReader(new BufferedReader(in), 10240);
        }
        return old;
    }

    public void addLinkTransmutator(StringTransmutator mutator) {
        if (mutator != null) {
            this.m_linkMutators.add(mutator);
        }
    }

    public void addLocalLinkHook(StringTransmutator mutator) {
        if (mutator != null) {
            this.m_localLinkMutatorChain.add(mutator);
        }
    }

    public void addExternalLinkHook(StringTransmutator mutator) {
        if (mutator != null) {
            this.m_externalLinkMutatorChain.add(mutator);
        }
    }

    public void addAttachmentLinkHook(StringTransmutator mutator) {
        if (mutator != null) {
            this.m_attachmentLinkMutatorChain.add(mutator);
        }
    }

    public void addHeadingListener(HeadingListener listener) {
        if (listener != null) {
            this.m_headingListenerChain.add(listener);
        }
    }

    public void disableAccessRules() {
        this.m_parseAccessRules = false;
    }

    public void enableImageInlining(boolean toggle) {
        this.m_inlineImages = toggle;
    }

    public abstract WikiDocument parse() throws IOException;

    public int getPosition() {
        return this.m_pos;
    }

    protected final int nextToken() throws IOException, NullPointerException {
        ++this.m_pos;
        return this.m_in.read();
    }

    protected void pushBack(int c) throws IOException {
        if (c != -1 && this.m_in != null) {
            --this.m_pos;
            this.m_in.unread(c);
        }
    }

    public static String cleanLink(String link) {
        return MarkupParser.cleanLink(link, PUNCTUATION_CHARS_ALLOWED);
    }

    public static String cleanLink(String link, String allowedChars) {
        if (link == null) {
            return null;
        }
        link = link.trim();
        StringBuilder clean = new StringBuilder(link.length());
        boolean isWord = true;
        boolean wasSpace = false;
        int i = 0;
        while (i < link.length()) {
            block7: {
                char ch;
                block8: {
                    block6: {
                        ch = link.charAt(i);
                        if (!Character.isWhitespace(ch)) break block6;
                        if (wasSpace) break block7;
                        wasSpace = true;
                        if (LEGACY_CHARS_ALLOWED.equals(allowedChars)) {
                            isWord = true;
                        }
                        break block8;
                    }
                    wasSpace = false;
                }
                if (Character.isLetterOrDigit(ch) || allowedChars.indexOf(ch) != -1) {
                    if (isWord) {
                        ch = Character.toUpperCase(ch);
                    }
                    clean.append(ch);
                    isWord = false;
                } else {
                    isWord = true;
                }
            }
            ++i;
        }
        return clean.toString();
    }

    public static String wikifyLink(String link) {
        return MarkupParser.cleanLink(link, LEGACY_CHARS_ALLOWED);
    }
}

