/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.modules;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.wiki.Release;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.modules.WikiModuleInfo;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModuleManager {
    public static final String PROP_SEARCHPATH = "jspwiki.plugin.searchPath";
    public static final String MODULE_RESOURCE_LOCATION = "ini/jspwiki_module.xml";
    protected WikiEngine m_engine;
    private static Logger log = LoggerFactory.getLogger(ModuleManager.class);
    private boolean m_loadIncompatibleModules = false;

    public ModuleManager(WikiEngine engine) {
        this.m_engine = engine;
    }

    public boolean checkCompatibility(WikiModuleInfo info) {
        if (!this.m_loadIncompatibleModules) {
            String minVersion = info.getMinVersion();
            String maxVersion = info.getMaxVersion();
            return Release.isNewerOrEqual(minVersion) && Release.isOlderOrEqual(maxVersion);
        }
        return true;
    }

    public abstract Collection<? extends WikiModuleInfo> modules();

    protected List<String> buildPluginSearchPath(Properties props) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("org.apache.wiki");
        list.add("org.apache.jspwiki");
        String packageNames = props.getProperty(PROP_SEARCHPATH);
        if (packageNames != null) {
            StringTokenizer tok = new StringTokenizer(packageNames, ",");
            while (tok.hasMoreTokens()) {
                list.add(tok.nextToken().trim());
            }
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources(MODULE_RESOURCE_LOCATION);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                try {
                    Document doc = builder.build(resource);
                    List packages = XPath.selectNodes((Object)doc, (String)"/modules/@package");
                    for (Attribute a2 : packages) {
                        list.add(a2.getValue().trim());
                    }
                }
                catch (IOException e) {
                    log.error("Couldn't load ini/jspwiki_module.xml resources: " + resource, e);
                }
                catch (JDOMException e) {
                    log.error("Error parsing XML for plugin: ini/jspwiki_module.xml", new Object[0]);
                }
            }
        }
        catch (IOException e) {
            log.error("Couldn't load all ini/jspwiki_module.xml resources", e);
        }
        return list;
    }
}

