/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.log;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerImpl;
import org.apache.wiki.parser.MarkupParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoggerFactory {
    private static boolean c_isLog4jPresent = true;
    private static boolean c_isLoggerFactoryClosed;
    private static final String SLF4J_LOG4J_ADAPTER_CLASS = "org.slf4j.impl.Log4jLoggerAdapter";
    private static final String LOG4J_LOGGER_CLASS = "org.apache.log4j.Logger";
    private static HashMap<String, LoggerImpl> c_registeredLoggers;
    private static String c_wikiName;

    static {
        c_registeredLoggers = new HashMap(200);
        try {
            Class<?> bridge = Class.forName("org.slf4j.bridge.SLF4JBridgeHandler");
            Method m = bridge.getMethod("install", new Class[0]);
            m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            System.out.println("No SLF4J bridge handler classes located; continuing anyway. In practice this means that only JSPWiki logs entries will be available in the JSPWiki log files. If you want to have the logs also from any of the additional libraries, you should install the java.util.logging and commons logging bridge files.");
        }
    }

    private LoggerFactory() {
    }

    public static void initialize(String wikiName) {
        c_wikiName = MarkupParser.cleanLink(wikiName);
    }

    public static final Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static final synchronized Logger getLogger(String loggerName) {
        if (c_registeredLoggers.get(loggerName) == null) {
            LoggerImpl logger = new LoggerImpl(loggerName);
            c_registeredLoggers.put(loggerName, logger);
            if (c_isLog4jPresent && !c_isLoggerFactoryClosed) {
                LoggerFactory.registerLoggerMBean(loggerName);
            }
            return logger;
        }
        return c_registeredLoggers.get(loggerName);
    }

    private static void registerLoggerMBean(String loggerName) {
        block4: {
            try {
                Class<?> slf4jLog4jImpl = Class.forName(SLF4J_LOG4J_ADAPTER_CLASS);
                Object log4jLogger = Class.forName(LOG4J_LOGGER_CLASS);
                Class<?> loggerClass = Class.forName(LOG4J_LOGGER_CLASS);
                Class[] parms = new Class[]{new String().getClass()};
                Method getLoggerMethod = loggerClass.getMethod("getLogger", parms);
                log4jLogger = getLoggerMethod.invoke(log4jLogger, loggerName);
                Object[] arglist = new Object[]{log4jLogger};
                Class<?> mbeanClass = Class.forName("org.apache.log4j.jmx.LoggerDynamicMBean");
                Constructor<?> constr = mbeanClass.getConstructor(loggerClass);
                Object dynMBean = constr.newInstance(arglist);
                ObjectName mbeanName = new ObjectName(String.valueOf(LoggerFactory.getObjectNamePrefix()) + loggerName);
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                if (c_wikiName == null) break block4;
                if (!mbeanServer.isRegistered(mbeanName)) {
                    mbeanServer.registerMBean(dynMBean, mbeanName);
                    break block4;
                }
                throw new RuntimeException("JMX bean named " + LoggerFactory.getObjectNamePrefix() + loggerName + " is already registered. Hint: are you running 2 webapps with the same " + "jspwiki.applicationName" + "?");
            }
            catch (ClassNotFoundException cnfe) {
                c_isLog4jPresent = false;
                System.err.println("Could not find class org.slf4j.impl.Log4jLoggerAdapter, so no dynamic log configuration here :-(");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void unRegisterAllLoggerMBeans() {
        c_isLoggerFactoryClosed = true;
        Set<String> loggerNames = c_registeredLoggers.keySet();
        for (String loggerName : loggerNames) {
            try {
                ObjectName mbeanName = new ObjectName(String.valueOf(LoggerFactory.getObjectNamePrefix()) + loggerName);
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(mbeanName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String getObjectNamePrefix() {
        return "JSPWiki:wiki=" + c_wikiName + ",component=Loggers,name=";
    }
}

