/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.htmltowiki;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wiki.htmltowiki.ForgetNullValuesLinkedHashMap;
import org.apache.wiki.htmltowiki.PersistentMapDecorator;
import org.apache.wiki.htmltowiki.WhitespaceTrimWriter;
import org.apache.wiki.htmltowiki.XHtmlToWikiConfig;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XHtmlElementToWikiTranslator {
    private static final String UTF8 = "UTF-8";
    private XHtmlToWikiConfig m_config;
    private WhitespaceTrimWriter m_outTimmer;
    private PrintWriter m_out;
    private LiStack m_liStack = new LiStack();
    private PreStack m_preStack = new PreStack();

    public XHtmlElementToWikiTranslator(Element base) throws IOException, JDOMException {
        this(base, new XHtmlToWikiConfig());
    }

    public XHtmlElementToWikiTranslator(Element base, XHtmlToWikiConfig config) throws IOException, JDOMException {
        this.m_config = config;
        this.m_outTimmer = new WhitespaceTrimWriter();
        this.m_out = new PrintWriter(this.m_outTimmer);
        this.print(base);
    }

    public String getWikiString() {
        return this.m_outTimmer.toString();
    }

    private void print(String s) {
        s = StringEscapeUtils.unescapeHtml((String)s);
        this.m_out.print(s);
    }

    private void print(Object element) throws IOException, JDOMException {
        if (element instanceof Text) {
            Text t = (Text)element;
            String s = t.getText();
            if (this.m_preStack.isPreMode()) {
                this.m_out.print(s);
            } else {
                s = s.replaceAll("[\\r\\n\\f\\u0085\\u2028\\u2029]", "");
                this.m_out.print(s);
            }
        } else if (element instanceof Element) {
            Element base = (Element)element;
            String n = base.getName().toLowerCase();
            if ("imageplugin".equals(base.getAttributeValue("class"))) {
                this.printImage(base);
            } else if ("wikiform".equals(base.getAttributeValue("class"))) {
                this.printChildren(base);
            } else {
                boolean bold = false;
                boolean italic = false;
                boolean monospace = false;
                String cssSpecial = null;
                String cssClass = base.getAttributeValue("class");
                boolean ignoredCssClass = cssClass != null && cssClass.matches("wikipage|createpage|external|interwiki|attachment");
                Map<String, String> styleProps = null;
                if (!n.equals("a")) {
                    styleProps = this.getStylePropertiesLowerCase(base);
                }
                if (styleProps != null) {
                    String fontFamily = styleProps.get("font-family");
                    String whiteSpace = styleProps.get("white-space");
                    if (fontFamily != null && fontFamily.indexOf("monospace") >= 0 && whiteSpace != null && whiteSpace.indexOf("pre") >= 0) {
                        styleProps.remove("font-family");
                        styleProps.remove("white-space");
                        monospace = true;
                    }
                    String weight = styleProps.remove("font-weight");
                    String style = styleProps.remove("font-style");
                    if (n.equals("p")) {
                        n = "div";
                    }
                    italic = "oblique".equals(style) || "italic".equals(style);
                    boolean bl = bold = "bold".equals(weight) || "bolder".equals(weight);
                    if (!styleProps.isEmpty()) {
                        cssSpecial = this.propsToStyleString(styleProps);
                    }
                }
                if (cssClass != null && !ignoredCssClass) {
                    if (n.equals("div")) {
                        this.m_out.print("\n%%" + cssClass + " \n");
                    } else if (n.equals("span")) {
                        this.m_out.print("%%" + cssClass + " ");
                    }
                }
                if (bold) {
                    this.m_out.print("__");
                }
                if (italic) {
                    this.m_out.print("''");
                }
                if (monospace) {
                    this.m_out.print("{{{");
                    this.m_preStack.push();
                }
                if (cssSpecial != null) {
                    if (n.equals("div")) {
                        this.m_out.print("\n%%(" + cssSpecial + " )\n");
                    } else {
                        this.m_out.print("%%(" + cssSpecial + " )");
                    }
                }
                this.printChildren(base);
                if (cssSpecial != null) {
                    if (n.equals("div")) {
                        this.m_out.print("\n%%\n");
                    } else {
                        this.m_out.print("%%");
                    }
                }
                if (monospace) {
                    this.m_preStack.pop();
                    this.m_out.print("}}}");
                }
                if (italic) {
                    this.m_out.print("''");
                }
                if (bold) {
                    this.m_out.print("__");
                }
                if (cssClass != null && !ignoredCssClass) {
                    if (n.equals("div")) {
                        this.m_out.print("\n%%\n");
                    } else if (n.equals("span")) {
                        this.m_out.print("%%");
                    }
                }
            }
        }
    }

    private void printChildren(Element base) throws IOException, JDOMException {
        for (Object c : base.getContent()) {
            if (c instanceof Element) {
                Element e = (Element)c;
                String n = e.getName().toLowerCase();
                if (n.equals("h1")) {
                    this.m_out.print("\n!!! ");
                    this.print(e);
                    this.m_out.println();
                    continue;
                }
                if (n.equals("h2")) {
                    this.m_out.print("\n!!! ");
                    this.print(e);
                    this.m_out.println();
                    continue;
                }
                if (n.equals("h3")) {
                    this.m_out.print("\n!! ");
                    this.print(e);
                    this.m_out.println();
                    continue;
                }
                if (n.equals("h4")) {
                    this.m_out.print("\n! ");
                    this.print(e);
                    this.m_out.println();
                    continue;
                }
                if (n.equals("p")) {
                    if (e.getContentSize() == 0) continue;
                    this.m_out.println();
                    this.print(e);
                    this.m_out.println();
                    continue;
                }
                if (n.equals("br")) {
                    if (this.m_preStack.isPreMode()) {
                        this.m_out.println();
                    } else {
                        String parentElementName = base.getName().toLowerCase();
                        if (parentElementName.matches("p|div") && !base.getText().matches("(?s).*\\[\\{.*\\}\\].*")) {
                            this.m_out.print(" \\\\\n");
                        } else {
                            this.m_out.print(" \\\\");
                        }
                    }
                    this.print(e);
                    continue;
                }
                if (n.equals("hr")) {
                    this.m_out.println();
                    this.print("----");
                    this.print(e);
                    this.m_out.println();
                    continue;
                }
                if (n.equals("table")) {
                    if (!this.m_outTimmer.isCurrentlyOnLineBegin()) {
                        this.m_out.println();
                    }
                    this.print(e);
                    continue;
                }
                if (n.equals("tr")) {
                    this.print(e);
                    this.m_out.println();
                    continue;
                }
                if (n.equals("td")) {
                    this.m_out.print("| ");
                    this.print(e);
                    if (this.m_preStack.isPreMode()) continue;
                    this.print(" ");
                    continue;
                }
                if (n.equals("th")) {
                    this.m_out.print("|| ");
                    this.print(e);
                    if (this.m_preStack.isPreMode()) continue;
                    this.print(" ");
                    continue;
                }
                if (n.equals("a")) {
                    String augmentedWikiLink;
                    if (this.isIgnorableWikiMarkupLink(e)) continue;
                    if (e.getChild("IMG") != null) {
                        this.printImage(e);
                        continue;
                    }
                    String ref = e.getAttributeValue("href");
                    if (ref == null) {
                        if (this.isUndefinedPageLink(e)) {
                            this.m_out.print("[");
                            this.print(e);
                            this.m_out.print("]");
                            continue;
                        }
                        this.print(e);
                        continue;
                    }
                    if ((ref = this.trimLink(ref)) == null) continue;
                    if (ref.startsWith("#")) {
                        String textValue;
                        String href = ref.replaceFirst("#ref-.+-(\\d+)", "$1");
                        if (href.equals(textValue = e.getValue().substring(1, e.getValue().length() - 1))) {
                            this.print(e);
                            continue;
                        }
                        this.m_out.print("[" + textValue + "|" + href + "]");
                        continue;
                    }
                    Map<String, String> augmentedWikiLinkAttributes = this.getAugmentedWikiLinkAttributes(e);
                    this.m_out.print("[");
                    this.print(e);
                    if (!e.getTextTrim().equalsIgnoreCase(ref)) {
                        this.m_out.print("|");
                        this.print(ref);
                        if (!augmentedWikiLinkAttributes.isEmpty()) {
                            this.m_out.print("|");
                            augmentedWikiLink = this.augmentedWikiLinkMapToString(augmentedWikiLinkAttributes);
                            this.m_out.print(augmentedWikiLink);
                        }
                    } else if (!augmentedWikiLinkAttributes.isEmpty()) {
                        this.m_out.print("|" + ref + "|");
                        augmentedWikiLink = this.augmentedWikiLinkMapToString(augmentedWikiLinkAttributes);
                        this.m_out.print(augmentedWikiLink);
                    }
                    this.m_out.print("]");
                    continue;
                }
                if (n.equals("b") || n.equals("strong")) {
                    this.m_out.print("__");
                    this.print(e);
                    this.m_out.print("__");
                    continue;
                }
                if (n.equals("i") || n.equals("em") || n.equals("address")) {
                    this.m_out.print("''");
                    this.print(e);
                    this.m_out.print("''");
                    continue;
                }
                if (n.equals("u")) {
                    this.m_out.print("%%( text-decoration:underline; )");
                    this.print(e);
                    this.m_out.print("%%");
                    continue;
                }
                if (n.equals("strike")) {
                    this.m_out.print("%%strike ");
                    this.print(e);
                    this.m_out.print("%%");
                    continue;
                }
                if (n.equals("sup")) {
                    this.m_out.print("%%sup ");
                    this.print(e);
                    this.m_out.print("%%");
                    continue;
                }
                if (n.equals("sub")) {
                    this.m_out.print("%%sub ");
                    this.print(e);
                    this.m_out.print("%%");
                    continue;
                }
                if (n.equals("dl")) {
                    this.m_out.print("\n");
                    this.print(e);
                    this.m_out.print("\n");
                    continue;
                }
                if (n.equals("dt")) {
                    this.m_out.print(";");
                    this.print(e);
                    continue;
                }
                if (n.equals("dd")) {
                    this.m_out.print(":");
                    this.print(e);
                    continue;
                }
                if (n.equals("ul")) {
                    this.m_out.println();
                    this.m_liStack.push("*");
                    this.print(e);
                    this.m_liStack.pop();
                    continue;
                }
                if (n.equals("ol")) {
                    this.m_out.println();
                    this.m_liStack.push("#");
                    this.print(e);
                    this.m_liStack.pop();
                    continue;
                }
                if (n.equals("li")) {
                    boolean sublistItem;
                    this.m_out.print(this.m_liStack + " ");
                    this.print(e);
                    boolean lastListItem = base.indexOf((Content)e) == base.getContentSize() - 2;
                    boolean bl = sublistItem = this.m_liStack.toString().length() > 1;
                    if (sublistItem && lastListItem) continue;
                    this.m_out.println();
                    continue;
                }
                if (n.equals("pre")) {
                    this.m_out.print("\n{{{\n");
                    this.m_preStack.push();
                    this.print(e);
                    this.m_preStack.pop();
                    this.m_out.print("\n}}}\n");
                    continue;
                }
                if (n.equals("code") || n.equals("tt")) {
                    this.m_out.print("{{");
                    this.m_preStack.push();
                    this.print(e);
                    this.m_preStack.pop();
                    this.m_out.print("}}");
                    continue;
                }
                if (n.equals("img")) {
                    if (this.isIgnorableWikiMarkupLink(e)) continue;
                    this.m_out.print("[");
                    this.print(this.trimLink(e.getAttributeValue("src")));
                    this.m_out.print("]");
                    continue;
                }
                if (n.equals("form")) {
                    Element formName = (Element)XPath.selectSingleNode((Object)e, (String)"INPUT[@name='formname']");
                    if (formName != null) {
                        formName.detach();
                    }
                    String name = e.getAttributeValue("name");
                    this.m_out.print("\n[{FormOpen");
                    if (name != null) {
                        this.m_out.print(" form='" + name + "'");
                    }
                    this.m_out.print("}]\n");
                    this.print(e);
                    this.m_out.print("\n[{FormClose}]\n");
                    continue;
                }
                if (n.equals("input")) {
                    String type = e.getAttributeValue("type");
                    String name = e.getAttributeValue("name");
                    String value = e.getAttributeValue("value");
                    String checked = e.getAttributeValue("checked");
                    this.m_out.print("[{FormInput");
                    if (type != null) {
                        this.m_out.print(" type='" + type + "'");
                    }
                    if (name != null) {
                        if (name.startsWith("nbf_")) {
                            name = name.substring(4, name.length());
                        }
                        this.m_out.print(" name='" + name + "'");
                    }
                    if (value != null && !value.equals("")) {
                        this.m_out.print(" value='" + value + "'");
                    }
                    if (checked != null) {
                        this.m_out.print(" checked='" + checked + "'");
                    }
                    this.m_out.print("}]");
                    this.print(e);
                    continue;
                }
                if (n.equals("textarea")) {
                    String name = e.getAttributeValue("name");
                    String rows = e.getAttributeValue("rows");
                    String cols = e.getAttributeValue("cols");
                    this.m_out.print("[{FormTextarea");
                    if (name != null) {
                        if (name.startsWith("nbf_")) {
                            name = name.substring(4, name.length());
                        }
                        this.m_out.print(" name='" + name + "'");
                    }
                    if (rows != null) {
                        this.m_out.print(" rows='" + rows + "'");
                    }
                    if (cols != null) {
                        this.m_out.print(" cols='" + cols + "'");
                    }
                    this.m_out.print("}]");
                    this.print(e);
                    continue;
                }
                if (n.equals("select")) {
                    String name = e.getAttributeValue("name");
                    this.m_out.print("[{FormSelect");
                    if (name != null) {
                        if (name.startsWith("nbf_")) {
                            name = name.substring(4, name.length());
                        }
                        this.m_out.print(" name='" + name + "'");
                    }
                    this.m_out.print(" value='");
                    this.print(e);
                    this.m_out.print("'}]");
                    continue;
                }
                if (n.equals("option")) {
                    String value;
                    Attribute selected;
                    if (base.indexOf((Content)e) != 1) {
                        this.m_out.print(";");
                    }
                    if ((selected = e.getAttribute("selected")) != null) {
                        this.m_out.print("*");
                    }
                    if ((value = e.getAttributeValue("value")) != null) {
                        this.m_out.print(value);
                        continue;
                    }
                    this.print(e);
                    continue;
                }
                this.print(e);
                continue;
            }
            this.print(c);
        }
    }

    private void printImage(Element base) throws JDOMException {
        String href;
        Element img2;
        Element child = (Element)XPath.selectSingleNode((Object)base, (String)"TBODY/TR/TD/*");
        if (child == null) {
            child = base;
        }
        ForgetNullValuesLinkedHashMap<String, String> map = new ForgetNullValuesLinkedHashMap<String, String>();
        if (child.getName().equals("A")) {
            img2 = child.getChild("IMG");
            href = child.getAttributeValue("href");
        } else {
            img2 = child;
            href = null;
        }
        if (img2 == null) {
            return;
        }
        String src = this.trimLink(img2.getAttributeValue("src"));
        if (src == null) {
            return;
        }
        map.put("align", base.getAttributeValue("align"));
        map.put("height", img2.getAttributeValue("height"));
        map.put("width", img2.getAttributeValue("width"));
        map.put("alt", img2.getAttributeValue("alt"));
        map.put("caption", this.emptyToNull(XPath.newInstance((String)"CAPTION").valueOf((Object)base)));
        map.put("link", href);
        map.put("border", img2.getAttributeValue("border"));
        map.put("style", base.getAttributeValue("style"));
        if (map.size() > 0) {
            this.m_out.print("[{Image src='" + src + "'");
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue().equals("")) continue;
                this.m_out.print(" " + entry.getKey() + "='" + entry.getValue() + "'");
            }
            this.m_out.print("}]");
        } else {
            this.m_out.print("[" + src + "]");
        }
    }

    private String emptyToNull(String s) {
        return s == null ? null : (s.replaceAll("\\s", "").length() == 0 ? null : s);
    }

    private String propsToStyleString(Map<String, String> styleProps) {
        StringBuilder style = new StringBuilder();
        for (Map.Entry<String, String> entry : styleProps.entrySet()) {
            style.append(" ").append(entry.getKey()).append(": ").append(entry.getValue()).append(";");
        }
        return style.toString();
    }

    private boolean isIgnorableWikiMarkupLink(Element a2) {
        String ref = a2.getAttributeValue("href");
        String clazz = a2.getAttributeValue("class");
        return ref != null && ref.startsWith(this.m_config.getPageInfoJsp()) || clazz != null && clazz.trim().equalsIgnoreCase(this.m_config.getOutlink());
    }

    private boolean isUndefinedPageLink(Element a2) {
        String classVal = a2.getAttributeValue("class");
        return classVal != null && classVal.equals("createpage");
    }

    private Map<String, String> getAugmentedWikiLinkAttributes(Element a2) {
        String target;
        String tabindex;
        String accesskey;
        String rev;
        String rel;
        String hreflang;
        String type;
        String charset;
        String dir;
        String lang;
        String title;
        String style;
        String cssClass;
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        String id = a2.getAttributeValue("id");
        if (id != null && !id.equals("")) {
            attributesMap.put("id", id.replaceAll("'", "\""));
        }
        if ((cssClass = a2.getAttributeValue("class")) != null && !cssClass.equals("") && !cssClass.matches("wikipage|createpage|external|interwiki|attachment")) {
            attributesMap.put("class", cssClass.replaceAll("'", "\""));
        }
        if ((style = a2.getAttributeValue("style")) != null && !style.equals("")) {
            attributesMap.put("style", style.replaceAll("'", "\""));
        }
        if ((title = a2.getAttributeValue("title")) != null && !title.equals("")) {
            attributesMap.put("title", title.replaceAll("'", "\""));
        }
        if ((lang = a2.getAttributeValue("lang")) != null && !lang.equals("")) {
            attributesMap.put("lang", lang.replaceAll("'", "\""));
        }
        if ((dir = a2.getAttributeValue("dir")) != null && !dir.equals("")) {
            attributesMap.put("dir", dir.replaceAll("'", "\""));
        }
        if ((charset = a2.getAttributeValue("charset")) != null && !charset.equals("")) {
            attributesMap.put("charset", charset.replaceAll("'", "\""));
        }
        if ((type = a2.getAttributeValue("type")) != null && !type.equals("")) {
            attributesMap.put("type", type.replaceAll("'", "\""));
        }
        if ((hreflang = a2.getAttributeValue("hreflang")) != null && !hreflang.equals("")) {
            attributesMap.put("hreflang", hreflang.replaceAll("'", "\""));
        }
        if ((rel = a2.getAttributeValue("rel")) != null && !rel.equals("")) {
            attributesMap.put("rel", rel.replaceAll("'", "\""));
        }
        if ((rev = a2.getAttributeValue("rev")) != null && !rev.equals("")) {
            attributesMap.put("rev", rev.replaceAll("'", "\""));
        }
        if ((accesskey = a2.getAttributeValue("accesskey")) != null && !accesskey.equals("")) {
            attributesMap.put("accesskey", accesskey.replaceAll("'", "\""));
        }
        if ((tabindex = a2.getAttributeValue("tabindex")) != null && !tabindex.equals("")) {
            attributesMap.put("tabindex", tabindex.replaceAll("'", "\""));
        }
        if ((target = a2.getAttributeValue("target")) != null && !target.equals("")) {
            attributesMap.put("target", target.replaceAll("'", "\""));
        }
        return attributesMap;
    }

    private String augmentedWikiLinkMapToString(Map<String, String> attributesMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : attributesMap.entrySet()) {
            String attributeName = entry.getKey();
            String attributeValue = entry.getValue();
            sb.append(" " + attributeName + "='" + attributeValue + "'");
        }
        return sb.toString().trim();
    }

    private Map<String, String> getStylePropertiesLowerCase(Element base) throws IOException {
        String align;
        String n = base.getName().toLowerCase();
        String style = base.getAttributeValue("style");
        if (style == null) {
            style = "";
        }
        if ((n.equals("p") || n.equals("div")) && (align = base.getAttributeValue("align")) != null && style.indexOf("text-align") == -1) {
            style = String.valueOf(style) + ";text-align:" + align + ";";
        }
        if (n.equals("font")) {
            String color = base.getAttributeValue("color");
            String face = base.getAttributeValue("face");
            String size = base.getAttributeValue("size");
            if (color != null) {
                style = String.valueOf(style) + "color:" + color + ";";
            }
            if (face != null) {
                style = String.valueOf(style) + "font-family:" + face + ";";
            }
            if (size != null) {
                if (size.equals("1")) {
                    style = String.valueOf(style) + "font-size:xx-small;";
                } else if (size.equals("2")) {
                    style = String.valueOf(style) + "font-size:x-small;";
                } else if (size.equals("3")) {
                    style = String.valueOf(style) + "font-size:small;";
                } else if (size.equals("4")) {
                    style = String.valueOf(style) + "font-size:medium;";
                } else if (size.equals("5")) {
                    style = String.valueOf(style) + "font-size:large;";
                } else if (size.equals("6")) {
                    style = String.valueOf(style) + "font-size:x-large;";
                } else if (size.equals("7")) {
                    style = String.valueOf(style) + "font-size:xx-large;";
                }
            }
        }
        if (style.equals("")) {
            return null;
        }
        style = style.replace(';', '\n').toLowerCase();
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        new PersistentMapDecorator(m).load(new ByteArrayInputStream(style.getBytes()));
        return m;
    }

    private String trimLink(String ref) {
        if (ref == null) {
            return null;
        }
        try {
            ref = URLDecoder.decode(ref, UTF8);
            ref = ref.trim();
            if (ref.startsWith(this.m_config.getAttachPage())) {
                ref = ref.substring(this.m_config.getAttachPage().length());
            }
            if (ref.startsWith(this.m_config.getWikiJspPage())) {
                ref = ref.substring(this.m_config.getWikiJspPage().length());
                ref = ref.replaceFirst(".+#section-(.+)-(.+)", "$1#$2");
            }
            if (ref.startsWith(this.m_config.getEditJspPage())) {
                ref = ref.substring(this.m_config.getEditJspPage().length());
            }
            if (this.m_config.getPageName() != null && ref.startsWith(this.m_config.getPageName())) {
                ref = ref.substring(this.m_config.getPageName().length());
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ref;
    }

    private static class LiStack {
        private StringBuilder m_li = new StringBuilder();

        private LiStack() {
        }

        public void push(String c) {
            this.m_li.append(c);
        }

        public void pop() {
            this.m_li = this.m_li.deleteCharAt(this.m_li.length() - 1);
        }

        public String toString() {
            return this.m_li.toString();
        }
    }

    private class PreStack {
        private int m_pre = 0;

        private PreStack() {
        }

        public boolean isPreMode() {
            return this.m_pre > 0;
        }

        public void push() {
            ++this.m_pre;
            XHtmlElementToWikiTranslator.this.m_outTimmer.setWhitespaceTrimMode(!this.isPreMode());
        }

        public void pop() {
            --this.m_pre;
            XHtmlElementToWikiTranslator.this.m_outTimmer.setWhitespaceTrimMode(!this.isPreMode());
        }
    }
}

