/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.htmltowiki;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public final class PropertiesUtils {
    private static final String OTHER_WHITESPACE = "\t\r\n\f";
    private static final char[] HEXDIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private PropertiesUtils() {
    }

    public static String toSortedString(Properties properties) {
        TreeMap<Object, Object> treemap = new TreeMap<Object, Object>(properties);
        String string = "";
        for (Map.Entry<Object, Object> entry : treemap.entrySet()) {
            String key = (String)entry.getKey();
            String value = entry.getValue() == null ? "null" : entry.getValue().toString();
            string = String.valueOf(string) + PropertiesUtils.toLine(key, value) + '\n';
        }
        return string;
    }

    public static String toLine(String key, String value) {
        return String.valueOf(PropertiesUtils.saveConvert(key, true)) + '=' + PropertiesUtils.saveConvert(value, false);
    }

    public static String saveConvert(String string, boolean encodeWhiteSpace) {
        int i = string.length();
        StringBuilder stringbuffer = new StringBuilder(i * 2);
        int i3 = 0;
        while (i3 < i) {
            char c = string.charAt(i3);
            switch (c) {
                case ' ': {
                    if (i3 == 0 || encodeWhiteSpace) {
                        stringbuffer.append('\\');
                    }
                    stringbuffer.append(' ');
                    break;
                }
                case '\\': {
                    stringbuffer.append('\\');
                    stringbuffer.append('\\');
                    break;
                }
                case '\t': {
                    stringbuffer.append('\\');
                    stringbuffer.append('t');
                    break;
                }
                case '\n': {
                    stringbuffer.append('\\');
                    stringbuffer.append('n');
                    break;
                }
                case '\r': {
                    stringbuffer.append('\\');
                    stringbuffer.append('r');
                    break;
                }
                case '\f': {
                    stringbuffer.append('\\');
                    stringbuffer.append('f');
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        stringbuffer.append('\\');
                        stringbuffer.append('u');
                        stringbuffer.append(PropertiesUtils.toHex(c >> 12 & 0xF));
                        stringbuffer.append(PropertiesUtils.toHex(c >> 8 & 0xF));
                        stringbuffer.append(PropertiesUtils.toHex(c >> 4 & 0xF));
                        stringbuffer.append(PropertiesUtils.toHex(c & 0xF));
                        break;
                    }
                    if (OTHER_WHITESPACE.indexOf(c) != -1) {
                        stringbuffer.append('\\');
                    }
                    stringbuffer.append(c);
                }
            }
            ++i3;
        }
        return stringbuffer.toString();
    }

    private static char toHex(int i) {
        return HEXDIGIT[i & 0xF];
    }
}

