/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.htmltowiki;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.wiki.WikiContext;
import org.apache.wiki.htmltowiki.XHtmlElementToWikiTranslator;
import org.apache.wiki.htmltowiki.XHtmlToWikiConfig;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class HtmlStringToWikiTranslator {
    private static final String CYBERNEKO_PARSER = "org.cyberneko.html.parsers.SAXParser";

    public String translate(String html) throws JDOMException, IOException {
        return this.translate(html, new XHtmlToWikiConfig());
    }

    public String translate(String html, WikiContext wikiContext) throws JDOMException, IOException {
        return this.translate(html, new XHtmlToWikiConfig(wikiContext));
    }

    public String translate(String html, XHtmlToWikiConfig config) throws JDOMException, IOException {
        Element element = this.htmlStringToElement(html);
        XHtmlElementToWikiTranslator xhtmlTranslator = new XHtmlElementToWikiTranslator(element, config);
        String wikiMarkup = xhtmlTranslator.getWikiString();
        return wikiMarkup;
    }

    private Element htmlStringToElement(String html) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder(CYBERNEKO_PARSER, true);
        Document doc = builder.build((Reader)new StringReader(html));
        Element element = doc.getRootElement();
        return element;
    }

    public static String element2String(Element element) {
        Document document = new Document(element);
        XMLOutputter outputter = new XMLOutputter();
        return outputter.outputString(document);
    }
}

