/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.forms;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.ecs.xhtml.textarea;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.forms.FormElement;
import org.apache.wiki.forms.FormInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormTextarea
extends FormElement {
    public static final String PARAM_ROWS = "rows";
    public static final String PARAM_COLS = "cols";

    @Override
    public String execute(WikiContext ctx, Map<String, Object> params) throws PluginException {
        FormInfo info = this.getFormInfo(ctx);
        Map<String, Object> previousValues = null;
        ResourceBundle rb = ctx.getBundle("plugin.PluginResources");
        if (info != null) {
            if (info.hide()) {
                return "<p>" + rb.getString("formclose.noneedtoshow") + "</p>";
            }
            previousValues = info.getSubmission();
        }
        if (previousValues == null) {
            previousValues = new HashMap<String, Object>();
        }
        textarea field = null;
        field = this.buildTextArea(params, previousValues, rb);
        if (field != null) {
            return field.toString(ctx.getEngine().getContentEncoding());
        }
        return "";
    }

    private textarea buildTextArea(Map<String, Object> params, Map<String, Object> previousValues, ResourceBundle rb) throws PluginException {
        String inputName = (String)params.get("name");
        String rows = (String)params.get(PARAM_ROWS);
        String cols = (String)params.get(PARAM_COLS);
        if (inputName == null) {
            throw new PluginException(rb.getString("formtextarea.namemissing"));
        }
        textarea field = new textarea("nbf_" + inputName, rows, cols);
        if (previousValues != null) {
            String oldValue = (String)previousValues.get(inputName);
            if (oldValue != null) {
                field.addElement(oldValue);
            } else {
                oldValue = (String)params.get("value");
                if (oldValue != null) {
                    field.addElement(oldValue);
                }
            }
        }
        return field;
    }
}

