/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.forms;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.select;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.forms.FormElement;
import org.apache.wiki.forms.FormInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormSelect
extends FormElement {
    @Override
    public String execute(WikiContext ctx, Map<String, Object> params) throws PluginException {
        FormInfo info = this.getFormInfo(ctx);
        ResourceBundle rb = ctx.getBundle("plugin.PluginResources");
        Map<String, Object> previousValues = null;
        if (info != null) {
            if (info.hide()) {
                return "<p>" + rb.getString("forminput.noneedtoshow") + "</p>";
            }
            previousValues = info.getSubmission();
        }
        if (previousValues == null) {
            previousValues = new HashMap<String, Object>();
        }
        select field = null;
        field = this.buildSelect(params, previousValues, rb);
        if (field != null) {
            return field.toString(ctx.getEngine().getContentEncoding());
        }
        return "";
    }

    private select buildSelect(Map<String, Object> pluginParams, Map<String, Object> ctxValues, ResourceBundle rb) throws PluginException {
        String[] options;
        String optionSelector;
        String inputName = (String)pluginParams.get("name");
        if (inputName == null) {
            throw new PluginException(rb.getString("formselect.namemissing"));
        }
        String inputValue = (String)pluginParams.get("value");
        String previousValue = (String)ctxValues.get(inputName);
        String optionSeparator = (String)pluginParams.get("separator");
        if (optionSeparator == null) {
            optionSeparator = (String)ctxValues.get("separator." + inputName);
        }
        if (optionSeparator == null) {
            optionSeparator = (String)ctxValues.get("select.separator");
        }
        if (optionSeparator == null) {
            optionSeparator = ";";
        }
        if ((optionSelector = (String)pluginParams.get("selector")) == null) {
            optionSelector = (String)ctxValues.get("selector." + inputName);
        }
        if (optionSelector == null) {
            optionSelector = (String)ctxValues.get("select.selector");
        }
        if (optionSelector == null) {
            optionSelector = "*";
        }
        if (optionSelector.equals(optionSeparator)) {
            optionSelector = null;
        }
        if (inputValue == null) {
            inputValue = "";
        }
        boolean contextValueOverride = false;
        if (previousValue != null) {
            if (previousValue.indexOf(optionSeparator) != -1) {
                inputValue = previousValue;
                previousValue = null;
            } else {
                contextValueOverride = true;
            }
        }
        if ((options = inputValue.split(optionSeparator)) == null) {
            options = new String[]{};
        }
        int previouslySelected = -1;
        option[] optionElements = new option[options.length];
        int i = 0;
        while (i < options.length) {
            int indicated = -1;
            options[i] = options[i].trim();
            if (optionSelector != null && options[i].startsWith(optionSelector)) {
                options[i] = options[i].substring(optionSelector.length());
                indicated = i;
            }
            if (previouslySelected == -1) {
                if (!contextValueOverride && indicated > 0) {
                    previouslySelected = indicated;
                } else if (previousValue != null && options[i].equals(previousValue)) {
                    previouslySelected = i;
                }
            }
            optionElements[i] = new option(options[i]);
            optionElements[i].addElement(options[i]);
            ++i;
        }
        if (previouslySelected > -1) {
            optionElements[previouslySelected].setSelected(true);
        }
        select field = new select("nbf_" + inputName, optionElements);
        return field;
    }
}

