/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.forms;

import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.forms.FormElement;
import org.apache.wiki.forms.FormInfo;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormOpen
extends FormElement {
    private static Logger log = LoggerFactory.getLogger(FormOpen.class);
    public static final String PARAM_METHOD = "method";

    @Override
    public String execute(WikiContext ctx, Map<String, Object> params) throws PluginException {
        String method;
        ResourceBundle rb = ctx.getBundle("plugin.PluginResources");
        String formName = (String)params.get("form");
        if (formName == null) {
            Object[] args = new Object[]{"form"};
            throw new PluginException(MessageFormat.format(rb.getString("formopen.missingparam"), args));
        }
        String hide = (String)params.get("hide");
        String sourcePage = ctx.getPage().getName();
        String submitServlet = (String)params.get("submit");
        if (submitServlet == null) {
            submitServlet = ctx.getURL(WikiContext.VIEW, sourcePage);
        }
        if ((method = (String)params.get(PARAM_METHOD)) == null) {
            method = "post";
        }
        if (!method.equalsIgnoreCase("get") && !method.equalsIgnoreCase("post")) {
            throw new PluginException(rb.getString("formopen.postorgetonly"));
        }
        FormInfo info = this.getFormInfo(ctx);
        if (info != null) {
            if (formName.equals(info.getName())) {
                log.debug("Previous FormInfo for this form was found in context.", new Object[0]);
                if (hide != null && "onsuccess".equals(hide) && info.getStatus() == 1) {
                    info.setHide(true);
                    return "<p>" + rb.getString("formopen.noneedtoshow") + "</p>";
                }
            } else {
                info = new FormInfo();
            }
        } else {
            info = new FormInfo();
            this.storeFormInfo(ctx, info);
        }
        info.setName(formName);
        info.setAction(submitServlet);
        StringBuilder tag = new StringBuilder(40);
        tag.append("<div class=\"wikiform\">\n");
        tag.append("<form action=\"" + submitServlet);
        tag.append("\" name=\"" + formName);
        tag.append("\" accept-charset=\"" + ctx.getEngine().getContentEncoding());
        tag.append("\" method=\"" + method + "\" enctype=\"application/x-www-form-urlencoded\">\n");
        tag.append("  <input type=\"hidden\" name=\"formname");
        tag.append("\" value=\"" + formName + "\"/>\n");
        return tag.toString();
    }
}

