/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.forms;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.ecs.xhtml.input;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.forms.FormElement;
import org.apache.wiki.forms.FormInfo;
import org.apache.wiki.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormInput
extends FormElement {
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_SIZE = "size";

    @Override
    public String execute(WikiContext ctx, Map<String, Object> params) throws PluginException {
        String inputName = (String)params.get("name");
        String inputValue = (String)params.get("value");
        String inputType = (String)params.get(PARAM_TYPE);
        String size = (String)params.get(PARAM_SIZE);
        ResourceBundle rb = ctx.getBundle("plugin.PluginResources");
        if (inputName == null) {
            throw new PluginException(rb.getString("forminput.namemissing"));
        }
        if (inputValue == null) {
            inputValue = "";
        }
        FormInfo info = this.getFormInfo(ctx);
        Map<String, Object> previousValues = null;
        if (info != null) {
            if (info.hide()) {
                return "<p>" + rb.getString("forminput.noneedtoshow") + "</p>";
            }
            previousValues = info.getSubmission();
        }
        if (previousValues == null) {
            previousValues = new HashMap<String, Object>();
        }
        input field = new input(inputType, "nbf_" + inputName, inputValue);
        String checked = (String)params.get("checked");
        field.setChecked(TextUtil.isPositive(checked) || "checked".equalsIgnoreCase(checked));
        String oldValue = (String)previousValues.get(inputName);
        if (oldValue != null) {
            field.setValue(oldValue);
        }
        if (size != null) {
            field.setSize(size);
        }
        return field.toString(ctx.getEngine().getContentEncoding());
    }
}

