/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.filters;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.filters.BasicPageFilter;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.xmlrpc.AsyncCallback;
import org.apache.xmlrpc.XmlRpcClient;

public class PingWeblogsComFilter
extends BasicPageFilter {
    static Logger log = LoggerFactory.getLogger(PingWeblogsComFilter.class);
    private String m_pingURL;
    public static final String PROP_PINGURL = "pingurl";

    public void initialize(WikiEngine engine, Properties props) {
        this.m_pingURL = props.getProperty(PROP_PINGURL, "http://rpc.weblogs.com/RPC2");
    }

    public void postSave(WikiContext context, String pagecontent) {
        String blogName = context.getPage().getName();
        WikiEngine engine = context.getEngine();
        int blogentryTxt = blogName.indexOf("_blogentry_");
        if (blogentryTxt == -1) {
            return;
        }
        if ((blogName = blogName.substring(0, blogentryTxt)).equals(engine.getFrontPage())) {
            blogName = null;
        }
        try {
            XmlRpcClient xmlrpc = new XmlRpcClient(this.m_pingURL);
            Vector<String> params = new Vector<String>();
            params.addElement("The Butt Ugly Weblog");
            params.addElement(engine.getURL(WikiContext.VIEW, blogName, null, true));
            if (log.isDebugEnabled()) {
                log.debug("Pinging weblogs.com with URL: " + engine.getURL(WikiContext.VIEW, blogName, null, true), new Object[0]);
            }
            xmlrpc.executeAsync("weblogUpdates.ping", params, new AsyncCallback(){

                public void handleError(Exception ex, URL url, String method) {
                    log.error("Unable to execute weblogs.com ping to URL: " + url.toString(), ex);
                }

                public void handleResult(Object result, URL url, String method) {
                    Hashtable res = (Hashtable)result;
                    Boolean flerror = (Boolean)res.get("flerror");
                    String msg = (String)res.get("message");
                    if (flerror.booleanValue()) {
                        log.error("Failed to ping: " + msg, new Object[0]);
                    }
                    log.info("Weblogs.com has been pinged.", new Object[0]);
                }
            });
        }
        catch (MalformedURLException e) {
            log.error("Malformed URL", e);
        }
    }
}

