/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.filters;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.sourceforge.stripes.util.ResolverUtil;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.FilterException;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.filters.PageFilter;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.modules.ModuleManager;
import org.apache.wiki.modules.WikiModuleInfo;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.PriorityList;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterManager
extends ModuleManager {
    private PriorityList<PageFilter> m_pageFilters = new PriorityList();
    private HashMap<String, PageFilterInfo> m_filterClassMap = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(WikiEngine.class);
    public static final String PROP_FILTERXML = "jspwiki.filterConfig";
    public static final String DEFAULT_XMLFILE = "/WEB-INF/filters.xml";
    public static final int SYSTEM_FILTER_PRIORITY = -1000;
    public static final int USER_FILTER_PRIORITY = 0;

    public FilterManager(WikiEngine engine, Properties props) throws WikiException {
        super(engine);
        this.initialize(props);
    }

    public void addPageFilter(PageFilter f, int priority) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException("Attempt to provide a null filter - this should never happen.  Please check your configuration (or if you're a developer, check your own code.)");
        }
        this.m_pageFilters.add(f, priority);
    }

    private void initPageFilter(String className, Properties props) {
        try {
            PageFilterInfo info = this.m_filterClassMap.get(className);
            if (info != null && !this.checkCompatibility(info)) {
                String msg = "Filter '" + info.getName() + "' not compatible with this version of JSPWiki";
                log.warn(msg, new Object[0]);
                return;
            }
            int priority = 0;
            Class<?> cl = ClassUtil.findClass("org.apache.wiki.filters", className);
            PageFilter filter = (PageFilter)cl.newInstance();
            filter.initialize(this.m_engine, props);
            this.addPageFilter(filter, priority);
            log.info("Added page filter " + cl.getName() + " with priority " + priority, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to find the filter class: " + className, new Object[0]);
        }
        catch (InstantiationException e) {
            log.error("Cannot create filter class: " + className, new Object[0]);
        }
        catch (IllegalAccessException e) {
            log.error("You are not allowed to access class: " + className, new Object[0]);
        }
        catch (ClassCastException e) {
            log.error("Suggested class is not a PageFilter: " + className, new Object[0]);
        }
        catch (FilterException e) {
            log.error("Filter " + className + " failed to initialize itself.", e);
        }
    }

    protected void initialize(Properties props) throws WikiException {
        InputStream xmlStream = null;
        String xmlFile = props.getProperty(PROP_FILTERXML);
        try {
            this.registerAllFilters();
            if (this.m_engine.getServletContext() != null) {
                log.debug("Attempting to locate /WEB-INF/filters.xml from servlet context.", new Object[0]);
                xmlStream = xmlFile == null ? this.m_engine.getServletContext().getResourceAsStream(DEFAULT_XMLFILE) : this.m_engine.getServletContext().getResourceAsStream(xmlFile);
            }
            if (xmlStream == null) {
                log.debug("Attempting to locate filters.xml from class path.", new Object[0]);
                xmlStream = xmlFile == null ? this.getClass().getResourceAsStream("/filters.xml") : this.getClass().getResourceAsStream(xmlFile);
            }
            if (xmlStream == null && xmlFile != null) {
                log.debug("Attempting to load property file " + xmlFile, new Object[0]);
                xmlStream = new FileInputStream(new File(xmlFile));
            }
            if (xmlStream == null) {
                log.info("Cannot find property file for filters (this is okay, expected to find it as: '" + (xmlFile == null ? DEFAULT_XMLFILE : xmlFile) + "')", new Object[0]);
                return;
            }
            this.parseConfigFile(xmlStream);
        }
        catch (IOException e) {
            log.error("Unable to read property file", e);
        }
        catch (JDOMException e) {
            log.error("Problem in the XML file", e);
        }
    }

    private void parseConfigFile(InputStream xmlStream) throws JDOMException, IOException {
        Document doc = new SAXBuilder().build(xmlStream);
        XPath xpath = XPath.newInstance((String)"/pagefilters/filter");
        List nodes = xpath.selectNodes((Object)doc);
        for (Element f : nodes) {
            String filterClass = f.getChildText("class");
            Properties props = new Properties();
            List params = f.getChildren("param");
            for (Element p : params) {
                props.setProperty(p.getChildText("name"), p.getChildText("value"));
            }
            this.initPageFilter(filterClass, props);
        }
    }

    public String doPreTranslateFiltering(WikiContext context, String pageData) throws FilterException {
        this.fireEvent(12, context);
        for (PageFilter f : this.m_pageFilters) {
            pageData = f.preTranslate(context, pageData);
        }
        this.fireEvent(14, context);
        return pageData;
    }

    public String doPostTranslateFiltering(WikiContext context, String htmlData) throws FilterException {
        this.fireEvent(15, context);
        for (PageFilter f : this.m_pageFilters) {
            htmlData = f.postTranslate(context, htmlData);
        }
        this.fireEvent(17, context);
        return htmlData;
    }

    public String doPreSaveFiltering(WikiContext context, String pageData) throws FilterException {
        this.fireEvent(18, context);
        for (PageFilter f : this.m_pageFilters) {
            pageData = f.preSave(context, pageData);
        }
        this.fireEvent(20, context);
        return pageData;
    }

    public void doPostSaveFiltering(WikiContext context, String pageData) throws FilterException {
        this.fireEvent(21, context);
        for (PageFilter f : this.m_pageFilters) {
            f.postSave(context, pageData);
        }
        this.fireEvent(23, context);
    }

    public List<PageFilter> getFilterList() {
        return this.m_pageFilters;
    }

    public void destroy() {
        for (PageFilter f : this.m_pageFilters) {
            f.destroy(this.m_engine);
        }
    }

    public final void fireEvent(int type, WikiContext context) {
        if (WikiEventManager.isListening(this) && WikiPageEvent.isValidType(type)) {
            WikiPage page = context.getPage();
            WikiPath pageName = page == null ? null : page.getPath();
            WikiEventManager.fireEvent(this, new WikiPageEvent((Object)this.m_engine, type, pageName, new Serializable[0]));
        }
    }

    public Collection modules() {
        ArrayList<PageFilter> modules = new ArrayList<PageFilter>();
        modules.addAll(this.m_pageFilters);
        return modules;
    }

    private void registerAllFilters() {
        log.info("Registering filters", new Object[0]);
        List<String> searchPath = this.buildPluginSearchPath(this.m_engine.getWikiProperties());
        ResolverUtil resolver = new ResolverUtil();
        String[] paths = searchPath.toArray(new String[0]);
        resolver.findImplementations(PageFilter.class, paths);
        Set resultSet = resolver.getClasses();
        log.debug("Found " + resultSet.size() + " pagefilters", new Object[0]);
        for (Class clazz : resultSet) {
            PageFilterInfo pluginInfo = PageFilterInfo.newInstance(clazz);
            if (pluginInfo == null) continue;
            this.registerPlugin(pluginInfo);
        }
    }

    private void registerPlugin(PageFilterInfo pluginInfo) {
        this.m_filterClassMap.put(pluginInfo.getName(), pluginInfo);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PageFilterInfo
    extends WikiModuleInfo {
        private PageFilterInfo(Class<? extends PageFilter> clazz) {
            super(clazz.getName());
            this.initializeFromClass(clazz);
        }

        protected static PageFilterInfo newInstance(Class<? extends PageFilter> clazz) {
            PageFilterInfo info = new PageFilterInfo(clazz);
            return info;
        }
    }
}

