/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.filters;

import java.util.Properties;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.FilterException;
import org.apache.wiki.filters.BasicPageFilter;
import org.apache.wiki.parser.CreoleToJSPWikiTranslator;

public class CreoleFilter
extends BasicPageFilter {
    public void initialize(WikiEngine engine, Properties props) throws FilterException {
    }

    public String preSave(WikiContext wikiContext, String content) throws FilterException {
        try {
            String username = wikiContext.getCurrentUser().getName();
            Properties prop = wikiContext.getEngine().getWikiProperties();
            return new CreoleToJSPWikiTranslator().translateSignature(prop, content, username);
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public String preTranslate(WikiContext wikiContext, String content) throws FilterException {
        try {
            Properties prop = wikiContext.getEngine().getWikiProperties();
            return new CreoleToJSPWikiTranslator().translate(prop, content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.valueOf(content) + "\n \n %%error \n" + "[CreoleFilterError]: This page was not translated by the CreoleFilter due to " + "the following error: " + e.getMessage() + "\n \n" + "%%\n \n";
        }
    }
}

