/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.event;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WikiEventManager {
    private static final Logger log = LoggerFactory.getLogger(WikiEventManager.class);
    private static boolean c_permitMonitor = false;
    private static WikiEventListener c_monitor = null;
    private final Map<Object, WikiEventDelegate> m_delegates = new HashMap<Object, WikiEventDelegate>();
    private final Vector<WikiEventDelegate> m_preloadCache = new Vector();
    private static WikiEventManager c_instance = null;

    private WikiEventManager() {
        c_instance = this;
        log.debug("instantiated WikiEventManager", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WikiEventManager getInstance() {
        if (c_instance == null) {
            Class<WikiEventManager> clazz = WikiEventManager.class;
            synchronized (WikiEventManager.class) {
                WikiEventManager mgr = new WikiEventManager();
                // ** MonitorExit[var0] (shouldn't be in output)
                return mgr;
            }
        }
        return c_instance;
    }

    public static final boolean addWikiEventListener(Object client, WikiEventListener listener) {
        if (client == WikiEventManager.class) {
            if (c_permitMonitor) {
                c_monitor = listener;
            }
            return c_permitMonitor;
        }
        WikiEventDelegate delegate = WikiEventManager.getInstance().getDelegateFor(client);
        return delegate.addWikiEventListener(listener);
    }

    public static final boolean removeWikiEventListener(Object client, WikiEventListener listener) {
        if (client == WikiEventManager.class) {
            c_monitor = null;
            return true;
        }
        WikiEventDelegate delegate = WikiEventManager.getInstance().getDelegateFor(client);
        return delegate.removeWikiEventListener(listener);
    }

    public static final Set<WikiEventListener> getWikiEventListeners(Object client) throws UnsupportedOperationException {
        WikiEventDelegate delegate = WikiEventManager.getInstance().getDelegateFor(client);
        return delegate.getWikiEventListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean removeWikiEventListener(WikiEventListener listener) {
        Map<Object, WikiEventDelegate> sources;
        WikiEventManager mgr = WikiEventManager.getInstance();
        Map<Object, WikiEventDelegate> map = sources = mgr.getDelegates();
        synchronized (map) {
            Map.Entry<Object, WikiEventDelegate> entry;
            WikiEventDelegate delegate;
            Iterator<Map.Entry<Object, WikiEventDelegate>> iterator = sources.entrySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((delegate = (entry = iterator.next()).getValue()) == null || !delegate.removeWikiEventListener(listener));
            return true;
        }
    }

    public static boolean isListening(Object client) {
        WikiEventDelegate source = WikiEventManager.getInstance().getDelegateFor(client);
        return source != null ? source.isListening() : false;
    }

    public static void fireEvent(Object client, WikiEvent event) {
        WikiEventDelegate source = WikiEventManager.getInstance().getDelegateFor(client);
        if (source != null) {
            source.fireEvent(event);
        }
        if (c_monitor != null) {
            c_monitor.actionPerformed(event);
        }
    }

    private Map<Object, WikiEventDelegate> getDelegates() {
        return this.m_delegates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WikiEventDelegate getDelegateFor(Object client) {
        Map<Object, WikiEventDelegate> map = this.m_delegates;
        synchronized (map) {
            WikiEventDelegate delegate;
            if (client == null || client instanceof Class) {
                WikiEventDelegate delegate2 = new WikiEventDelegate(client);
                this.m_preloadCache.add(delegate2);
                this.m_delegates.put(client, delegate2);
                return delegate2;
            }
            if (!this.m_preloadCache.isEmpty()) {
                int i = this.m_preloadCache.size() - 1;
                while (i >= 0) {
                    WikiEventDelegate delegate3 = this.m_preloadCache.elementAt(i);
                    if ((delegate3.getClientClass() == null || delegate3.getClientClass().equals(client.getClass())) && !this.m_delegates.keySet().contains(client)) {
                        this.m_preloadCache.remove(delegate3);
                        this.m_delegates.put(client, delegate3);
                        return delegate3;
                    }
                    --i;
                }
            }
            if ((delegate = this.m_delegates.get(client)) == null) {
                delegate = new WikiEventDelegate(client);
                this.m_delegates.put(client, delegate);
            }
            return delegate;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WikiEventDelegate {
        private ArrayList<WeakReference<WikiEventListener>> m_listenerList = new ArrayList();
        private Class<?> m_class = null;

        protected WikiEventDelegate(Object client) {
            if (client instanceof Class) {
                this.m_class = (Class)client;
            }
        }

        protected Class<?> getClientClass() {
            return this.m_class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<WikiEventListener> getWikiEventListeners() {
            ArrayList<WeakReference<WikiEventListener>> arrayList = this.m_listenerList;
            synchronized (arrayList) {
                TreeSet<WikiEventListener> set = new TreeSet<WikiEventListener>(new WikiEventListenerComparator());
                for (WeakReference<WikiEventListener> ref : this.m_listenerList) {
                    WikiEventListener l = (WikiEventListener)ref.get();
                    if (l == null) continue;
                    set.add(l);
                }
                return Collections.unmodifiableSet(set);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addWikiEventListener(WikiEventListener listener) {
            ArrayList<WeakReference<WikiEventListener>> arrayList = this.m_listenerList;
            synchronized (arrayList) {
                return this.m_listenerList.add(new WeakReference<WikiEventListener>(listener));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean removeWikiEventListener(WikiEventListener listener) {
            ArrayList<WeakReference<WikiEventListener>> arrayList = this.m_listenerList;
            synchronized (arrayList) {
                WikiEventListener l;
                Iterator<WeakReference<WikiEventListener>> i = this.m_listenerList.iterator();
                do {
                    if (i.hasNext()) continue;
                    return false;
                } while ((l = (WikiEventListener)i.next().get()) != listener);
                i.remove();
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isListening() {
            ArrayList<WeakReference<WikiEventListener>> arrayList = this.m_listenerList;
            synchronized (arrayList) {
                return !this.m_listenerList.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireEvent(WikiEvent event) {
            boolean needsCleanup = false;
            try {
                ArrayList<WeakReference<WikiEventListener>> arrayList = this.m_listenerList;
                synchronized (arrayList) {
                    int i = 0;
                    while (i < this.m_listenerList.size()) {
                        WikiEventListener listener = (WikiEventListener)this.m_listenerList.get(i).get();
                        if (listener != null) {
                            listener.actionPerformed(event);
                        } else {
                            needsCleanup = true;
                        }
                        ++i;
                    }
                    if (needsCleanup) {
                        i = 0;
                        while (i < this.m_listenerList.size()) {
                            WeakReference<WikiEventListener> w = this.m_listenerList.get(i);
                            if (w.get() == null) {
                                this.m_listenerList.remove(i--);
                            }
                            ++i;
                        }
                    }
                }
            }
            catch (ConcurrentModificationException e) {
                log.info("Concurrent modification of event list; please report this.", e, new Object[0]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WikiEventListenerComparator
    implements Comparator<WikiEventListener> {
        private WikiEventListenerComparator() {
        }

        @Override
        public int compare(WikiEventListener w0, WikiEventListener w1) {
            if (w1 == w0 || w0.equals(w1)) {
                return 0;
            }
            return w1.hashCode() - w0.hashCode();
        }
    }
}

