/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.diff;

import java.io.IOException;
import java.text.ChoiceFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.jrcs.diff.AddDelta;
import org.apache.commons.jrcs.diff.ChangeDelta;
import org.apache.commons.jrcs.diff.Chunk;
import org.apache.commons.jrcs.diff.DeleteDelta;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.diff.DiffAlgorithm;
import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.commons.jrcs.diff.Revision;
import org.apache.commons.jrcs.diff.RevisionVisitor;
import org.apache.commons.jrcs.diff.myers.MyersDiff;
import org.apache.wiki.NoRequiredPropertyException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.diff.DiffProvider;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.util.TextUtil;

public class TraditionalDiffProvider
implements DiffProvider {
    private static final Logger log = LoggerFactory.getLogger(TraditionalDiffProvider.class);
    private static final String CSS_DIFF_ADDED = "<tr><td class=\"diffadd\">";
    private static final String CSS_DIFF_REMOVED = "<tr><td class=\"diffrem\">";
    private static final String CSS_DIFF_UNCHANGED = "<tr><td class=\"diff\">";
    private static final String CSS_DIFF_CLOSE = "</td></tr>" + Diff.NL;

    public String getProviderInfo() {
        return "TraditionalDiffProvider";
    }

    public void initialize(WikiEngine engine, Properties properties) throws NoRequiredPropertyException, IOException {
    }

    public String makeDiffHtml(WikiContext ctx, String p1, String p2) {
        Revision rev;
        block3: {
            String diffResult = "";
            try {
                Object[] first = Diff.stringToArray((String)TextUtil.replaceEntities(p1));
                Object[] second = Diff.stringToArray((String)TextUtil.replaceEntities(p2));
                rev = Diff.diff((Object[])first, (Object[])second, (DiffAlgorithm)new MyersDiff());
                if (rev != null && rev.size() != 0) break block3;
                return "";
            }
            catch (DifferentiationFailedException e) {
                diffResult = "makeDiff failed with DifferentiationFailedException";
                log.error(diffResult, e);
                return diffResult;
            }
        }
        StringBuffer ret = new StringBuffer(rev.size() * 20);
        ret.append("<table class=\"diff\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
        rev.accept((RevisionVisitor)new RevisionPrint(ctx, ret));
        ret.append("</table>\n");
        return ret.toString();
    }

    private static final class RevisionPrint
    implements RevisionVisitor {
        private StringBuffer m_result = null;
        private WikiContext m_context;
        private ResourceBundle m_rb;

        private RevisionPrint(WikiContext ctx, StringBuffer sb) {
            this.m_result = sb;
            this.m_context = ctx;
            this.m_rb = ctx.getBundle("CoreResources");
        }

        public void visit(Revision rev) {
        }

        public void visit(AddDelta delta) {
            Chunk changed = delta.getRevised();
            this.print(changed, this.m_rb.getString("diff.traditional.added"));
            changed.toString(this.m_result, TraditionalDiffProvider.CSS_DIFF_ADDED, CSS_DIFF_CLOSE);
        }

        public void visit(ChangeDelta delta) {
            Chunk changed = delta.getOriginal();
            this.print(changed, this.m_rb.getString("diff.traditional.changed"));
            changed.toString(this.m_result, TraditionalDiffProvider.CSS_DIFF_REMOVED, CSS_DIFF_CLOSE);
            delta.getRevised().toString(this.m_result, TraditionalDiffProvider.CSS_DIFF_ADDED, CSS_DIFF_CLOSE);
        }

        public void visit(DeleteDelta delta) {
            Chunk changed = delta.getOriginal();
            this.print(changed, this.m_rb.getString("diff.traditional.removed"));
            changed.toString(this.m_result, TraditionalDiffProvider.CSS_DIFF_REMOVED, CSS_DIFF_CLOSE);
        }

        private void print(Chunk changed, String type) {
            this.m_result.append(TraditionalDiffProvider.CSS_DIFF_UNCHANGED);
            String[] choiceString = new String[]{this.m_rb.getString("diff.traditional.oneline"), this.m_rb.getString("diff.traditional.lines")};
            double[] choiceLimits = new double[]{1.0, 2.0};
            MessageFormat fmt = new MessageFormat("");
            fmt.setLocale(this.m_context.getHttpRequest().getLocale());
            ChoiceFormat cfmt = new ChoiceFormat(choiceLimits, choiceString);
            fmt.applyPattern(type);
            Format[] formats = new Format[]{NumberFormat.getInstance(), cfmt, NumberFormat.getInstance()};
            fmt.setFormats(formats);
            Object[] params = new Object[]{changed.first() + 1, changed.size(), changed.size()};
            this.m_result.append(fmt.format(params));
            this.m_result.append(CSS_DIFF_CLOSE);
        }
    }
}

