/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.diff;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import org.apache.wiki.NoRequiredPropertyException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.diff.DiffProvider;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.util.FileUtil;
import org.apache.wiki.util.TextUtil;

public class ExternalDiffProvider
implements DiffProvider {
    private static final Logger log = LoggerFactory.getLogger(ExternalDiffProvider.class);
    public static final String PROP_DIFFCOMMAND = "jspwiki.diffCommand";
    private String m_diffCommand = null;
    private static final char DIFF_ADDED_SYMBOL = '+';
    private static final char DIFF_REMOVED_SYMBOL = '-';
    private static final String CSS_DIFF_ADDED = "<tr><td bgcolor=\"#99FF99\" class=\"diffadd\">";
    private static final String CSS_DIFF_REMOVED = "<tr><td bgcolor=\"#FF9933\" class=\"diffrem\">";
    private static final String CSS_DIFF_UNCHANGED = "<tr><td class=\"diff\">";
    private static final String CSS_DIFF_CLOSE = "</td></tr>";
    private boolean m_traditionalColorization = true;

    public String getProviderInfo() {
        return "ExternalDiffProvider";
    }

    public void initialize(WikiEngine engine, Properties properties) throws NoRequiredPropertyException, IOException {
        this.m_diffCommand = properties.getProperty(PROP_DIFFCOMMAND);
        if (this.m_diffCommand == null || this.m_diffCommand.trim().equals("")) {
            throw new NoRequiredPropertyException("ExternalDiffProvider missing required property", PROP_DIFFCOMMAND);
        }
    }

    public String makeDiffHtml(WikiContext ctx, String p1, String p2) {
        File f1 = null;
        File f2 = null;
        String diff = null;
        try {
            try {
                f1 = FileUtil.newTmpFile(p1, "UTF-8");
                f2 = FileUtil.newTmpFile(p2, "UTF-8");
                String cmd = TextUtil.replaceString(this.m_diffCommand, "%s1", f1.getPath());
                cmd = TextUtil.replaceString(cmd, "%s2", f2.getPath());
                String output = FileUtil.runSimpleCommand(cmd, f1.getParent());
                String rawWikiDiff = new String(output.getBytes("UTF-8"), "UTF-8");
                String htmlWikiDiff = TextUtil.replaceEntities(rawWikiDiff);
                diff = this.m_traditionalColorization ? ExternalDiffProvider.colorizeDiff(htmlWikiDiff) : htmlWikiDiff;
            }
            catch (IOException e) {
                log.error("Failed to do file diff", e);
                if (f1 != null) {
                    f1.delete();
                }
                if (f2 != null) {
                    f2.delete();
                }
            }
            catch (InterruptedException e) {
                block13: {
                    log.error("Interrupted", e);
                    if (f1 == null) break block13;
                    f1.delete();
                }
                if (f2 != null) {
                    f2.delete();
                }
            }
        }
        finally {
            if (f1 != null) {
                f1.delete();
            }
            if (f2 != null) {
                f2.delete();
            }
        }
        return diff;
    }

    static String colorizeDiff(String diffText) throws IOException {
        if (diffText == null) {
            return "Invalid diff - probably something wrong with server setup.";
        }
        String line = null;
        String start = null;
        String stop = null;
        BufferedReader in = new BufferedReader(new StringReader(diffText));
        StringBuffer out = new StringBuffer();
        out.append("<table class=\"diff\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
        while ((line = in.readLine()) != null) {
            stop = CSS_DIFF_CLOSE;
            if (line.length() > 0) {
                switch (line.charAt(0)) {
                    case '+': {
                        start = CSS_DIFF_ADDED;
                        break;
                    }
                    case '-': {
                        start = CSS_DIFF_REMOVED;
                        break;
                    }
                    default: {
                        start = CSS_DIFF_UNCHANGED;
                        break;
                    }
                }
            } else {
                start = CSS_DIFF_UNCHANGED;
            }
            out.append(start);
            out.append(line.trim());
            out.append(String.valueOf(stop) + "\n");
        }
        out.append("</table>\n");
        return out.toString();
    }
}

