/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.diff;

import java.io.IOException;
import java.util.Properties;
import org.apache.wiki.NoRequiredPropertyException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.diff.DiffProvider;
import org.apache.wiki.diff.TraditionalDiffProvider;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.util.ClassUtil;

public class DifferenceManager {
    private static final Logger log = LoggerFactory.getLogger(DifferenceManager.class);
    public static final String PROP_DIFF_PROVIDER = "jspwiki.diffProvider";
    private DiffProvider m_provider;

    public DifferenceManager(WikiEngine engine, Properties props) {
        this.loadProvider(props);
        this.initializeProvider(engine, props);
        log.info("Using difference provider: " + this.m_provider.getProviderInfo(), new Object[0]);
    }

    private void loadProvider(Properties props) {
        String providerClassName = props.getProperty(PROP_DIFF_PROVIDER, TraditionalDiffProvider.class.getName());
        try {
            Class<?> providerClass = ClassUtil.findClass("org.apache.wiki.diff", providerClassName);
            this.m_provider = (DiffProvider)providerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.warn("Failed loading DiffProvider, will use NullDiffProvider.", e, new Object[0]);
        }
        catch (InstantiationException e) {
            log.warn("Failed loading DiffProvider, will use NullDiffProvider.", e, new Object[0]);
        }
        catch (IllegalAccessException e) {
            log.warn("Failed loading DiffProvider, will use NullDiffProvider.", e, new Object[0]);
        }
        if (this.m_provider == null) {
            this.m_provider = new DiffProvider.NullDiffProvider();
        }
    }

    private void initializeProvider(WikiEngine engine, Properties props) {
        try {
            this.m_provider.initialize(engine, props);
        }
        catch (NoRequiredPropertyException e1) {
            log.warn("Failed initializing DiffProvider, will use NullDiffProvider.", e1, new Object[0]);
            this.m_provider = new DiffProvider.NullDiffProvider();
        }
        catch (IOException e1) {
            log.warn("Failed initializing DiffProvider, will use NullDiffProvider.", e1, new Object[0]);
            this.m_provider = new DiffProvider.NullDiffProvider();
        }
    }

    public String makeDiff(WikiContext context, String firstWikiText, String secondWikiText) {
        String diff = null;
        try {
            diff = this.m_provider.makeDiffHtml(context, firstWikiText, secondWikiText);
            if (diff == null) {
                diff = "";
            }
        }
        catch (Exception e) {
            diff = "Failed to create a diff, check the logs.";
            log.warn(diff, e, new Object[0]);
        }
        return diff;
    }
}

