/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content.resolver;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.content.resolver.PageNameResolver;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.providers.ProviderException;

public class SpecialPageNameResolver
extends PageNameResolver {
    private static final String PROP_SPECIALPAGE = "jspwiki.specialPage.";
    private static Logger log = LoggerFactory.getLogger(SpecialPageNameResolver.class);
    private final Map<String, URI> m_specialRedirects = new HashMap<String, URI>();

    public SpecialPageNameResolver(WikiEngine engine) {
        super(engine);
        this.initSpecialPageRedirects(engine.getWikiProperties());
    }

    public WikiPath resolve(WikiPath name) throws ProviderException {
        if (this.simplePageExists(name)) {
            return name;
        }
        return null;
    }

    protected final boolean simplePageExists(WikiPath page) throws ProviderException {
        if (this.m_specialRedirects.containsKey(page) || this.m_specialRedirects.containsKey(page.getPath())) {
            return true;
        }
        return this.m_engine.getContentManager().pageExists(page);
    }

    private void initSpecialPageRedirects(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(PROP_SPECIALPAGE)) continue;
            String specialPage = key.substring(PROP_SPECIALPAGE.length());
            String redirectUrl = (String)entry.getValue();
            if (specialPage == null || redirectUrl == null) continue;
            specialPage = specialPage.trim();
            redirectUrl = redirectUrl.trim();
            try {
                URI uri = new URI(redirectUrl);
                if (uri.getAuthority() == null && !redirectUrl.startsWith("/")) {
                    uri = new URI("/" + redirectUrl);
                }
                this.m_specialRedirects.put(specialPage, uri);
            }
            catch (URISyntaxException e) {
                log.error("Strange special page reference: " + redirectUrl, new Object[0]);
            }
        }
    }

    public final URI getSpecialPageURI(String page) {
        return this.m_specialRedirects.get(page);
    }
}

