/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content.resolver;

import org.apache.wiki.WikiEngine;
import org.apache.wiki.content.ContentManager;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.content.resolver.PageNameResolver;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.util.TextUtil;

public class EnglishPluralsPageNameResolver
extends PageNameResolver {
    private boolean m_matchEnglishPlurals;

    public EnglishPluralsPageNameResolver(WikiEngine engine) {
        super(engine);
        this.m_matchEnglishPlurals = TextUtil.getBooleanProperty(engine.getWikiProperties(), "jspwiki.translatorReader.matchEnglishPlurals", true);
    }

    public WikiPath resolve(WikiPath name) throws ProviderException {
        WikiPath alternativeName;
        ContentManager mgr = this.m_engine.getContentManager();
        if (mgr.pageExists(name)) {
            return name;
        }
        if (this.m_matchEnglishPlurals && mgr.pageExists(alternativeName = name.getPath().endsWith("s") ? new WikiPath(name.getSpace(), name.getPath().substring(0, name.getPath().length() - 1)) : new WikiPath(name.getSpace(), String.valueOf(name.getPath()) + "s"))) {
            return alternativeName;
        }
        return null;
    }
}

