/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content.jcr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.auth.acl.Acl;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.content.WikiPathResolver;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.providers.ProviderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRWikiPage
implements Cloneable,
WikiPage,
Attachment,
Comparable<WikiPage> {
    private static final long serialVersionUID = 1L;
    public static final String LAST_MODIFIED = "wiki:lastModified";
    private static final String AUTHOR = "wiki:author";
    private static final String ACL = "wiki:acl";
    private static final String ATTR_CONTENT = "wiki:content";
    public static final String ATTR_TITLE = "wiki:title";
    public static final String ATTR_VERSION = "wiki:version";
    public static final String ATTR_CREATED = "wiki:created";
    public static final String CONTENT_TYPE = "wiki:contentType";
    public static final String DATEFORMAT_ISO8601_2000 = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private WikiPath m_path;
    private WikiEngine m_engine;
    private String m_jcrPath;
    private static final Logger log = LoggerFactory.getLogger(JCRWikiPage.class);

    protected JCRWikiPage(WikiEngine engine, WikiPath path) {
        this.m_engine = engine;
        this.m_path = path;
        this.m_jcrPath = WikiPathResolver.getJCRPath(path, WikiPathResolver.PathRoot.PAGES);
    }

    public JCRWikiPage(WikiEngine engine, Node node) throws RepositoryException, ProviderException {
        this(engine, WikiPathResolver.getInstance(engine.getContentManager()).getWikiPath(node.getPath(), WikiPathResolver.PathRoot.PAGES), node);
    }

    public JCRWikiPage(WikiEngine engine, WikiPath path, Node node) throws RepositoryException {
        this.m_engine = engine;
        this.m_jcrPath = node.getPath();
        this.m_path = path;
    }

    @Override
    public String getChangeNote() throws ProviderException {
        try {
            if (this.getJCRNode().hasProperty("changenote")) {
                return this.getAttribute("changenote").toString();
            }
        }
        catch (RepositoryException e) {
            throw new ProviderException(e.getMessage(), e);
        }
        return null;
    }

    public Node getJCRNode() throws RepositoryException {
        Node node = this.m_engine.getContentManager().getJCRNode(this.m_jcrPath);
        return node;
    }

    @Override
    public String getName() {
        try {
            return this.getProperty(ATTR_TITLE).getString();
        }
        catch (Exception e) {
            return this.m_path.getPath();
        }
    }

    @Override
    public WikiPath getPath() {
        return this.m_path;
    }

    @Override
    public Serializable getAttribute(String key) {
        try {
            Property property = this.getJCRNode().getProperty(key);
            Object value = this.getValue(property);
            if (value instanceof Serializable) {
                return (Serializable)value;
            }
            throw new IllegalStateException("The value returned by " + key + " was not a Serializable, as expected.");
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (ItemNotFoundException e) {
            log.error("ItemNotFoundException occurred while getting Attribute " + key, e);
        }
        catch (RepositoryException e) {
            log.info("RepositoryException occurred while getting Attribute " + key + " : " + (Object)((Object)e), new Object[0]);
        }
        return null;
    }

    public Property getProperty(String key) throws PathNotFoundException, RepositoryException {
        return this.getJCRNode().getProperty(key);
    }

    private Object getValue(Property property) throws RepositoryException, ValueFormatException {
        switch (property.getType()) {
            case 1: {
                return property.getString();
            }
        }
        return property.getString();
    }

    @Override
    public void setAttribute(String key, Serializable attribute) {
        try {
            this.getJCRNode().setProperty(key, attribute.toString());
        }
        catch (RepositoryException e) {
            log.error("Exception occurred while setting (Serializable) attribute " + key, e);
        }
    }

    public void setAttribute(String key, Date attribute) {
        try {
            Calendar c = Calendar.getInstance();
            c.setTime(attribute);
            this.getJCRNode().setProperty(key, c);
        }
        catch (RepositoryException e) {
            log.error("Exception occurred while setting (Date) attribute " + key, e);
        }
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        return null;
    }

    @Override
    public Serializable removeAttribute(String key) {
        try {
            Property p = this.getJCRNode().getProperty(key);
            Object value = this.getValue(p);
            if (value instanceof Serializable) {
                p.remove();
                return (Serializable)value;
            }
            throw new IllegalStateException("The value returned by " + key + " was not a Serializable, as expected.");
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }

    @Override
    public Date getLastModified() {
        try {
            if (this.getJCRNode().hasProperty(LAST_MODIFIED)) {
                return this.getJCRNode().getProperty(LAST_MODIFIED).getDate().getTime();
            }
        }
        catch (RepositoryException e) {
            log.warn("RepositoryException while getting lastModified : " + (Object)((Object)e), new Object[0]);
        }
        return null;
    }

    public void setLastModified(Date date) {
        this.setAttribute(LAST_MODIFIED, date);
    }

    @Override
    public int getVersion() {
        try {
            return (int)this.getJCRNode().getProperty(ATTR_VERSION).getLong();
        }
        catch (PathNotFoundException pathNotFoundException) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public long getSize() {
        try {
            return this.getJCRNode().getProperty(ATTR_CONTENT).getLength();
        }
        catch (RepositoryException repositoryException) {
            return -1L;
        }
    }

    @Override
    public Acl getAcl() {
        ObjectInputStream in = null;
        try {
            Acl a;
            Property acl = this.getJCRNode().getProperty(ACL);
            in = new ObjectInputStream(acl.getStream());
            Acl acl2 = a = (Acl)in.readObject();
            return acl2;
        }
        catch (PathNotFoundException acl) {
        }
        catch (RepositoryException e) {
            log.error("RepositoryException occurred while getting ACL ", e);
        }
        catch (IOException e) {
            log.error("IOException occurred while getting ACL ", e);
        }
        catch (ClassNotFoundException e) {
            log.error("ClassNotFoundException occurred while getting ACL ", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    @Override
    public void setAcl(Acl acl) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oout = new ObjectOutputStream(out);
            oout.writeObject(acl);
            oout.close();
            this.getJCRNode().setProperty(ACL, (InputStream)new ByteArrayInputStream(out.toByteArray()));
        }
        catch (IOException e) {
            log.error("IOException occurred while setting ACL ", e);
        }
        catch (ValueFormatException e) {
            log.error("ValueFormatException occurred while setting ACL ", e);
        }
        catch (VersionException e) {
            log.error("VersionException occurred while setting ACL ", e);
        }
        catch (LockException e) {
            log.error("LockException occurred while setting ACL ", e);
        }
        catch (ConstraintViolationException e) {
            log.error("ConstraintViolationException occurred while setting ACL ", e);
        }
        catch (RepositoryException e) {
            log.error("RepositoryException occurred while setting ACL ", e);
        }
    }

    @Override
    public void setAuthor(String author) {
        this.setAttribute(AUTHOR, (Serializable)((Object)author));
    }

    @Override
    public String getAuthor() {
        return (String)((Object)this.getAttribute(AUTHOR));
    }

    @Override
    public String getWiki() {
        return this.m_path.getSpace();
    }

    public String toString() {
        return "WikiPage [" + this.m_path + ",ver=" + this.getVersion() + ",mod=" + this.getLastModified() + "]";
    }

    @Override
    public Object clone() {
        JCRWikiPage p;
        try {
            p = new JCRWikiPage(this.m_engine, this.m_path, this.getJCRNode());
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            throw new InternalWikiException(e.getMessage(), e);
        }
        return p;
    }

    @Override
    public int compareTo(WikiPage o) {
        WikiPage c = o;
        int res = this.getName().compareTo(c.getName());
        if (res == 0) {
            res = this.getVersion() - c.getVersion();
        }
        return res;
    }

    public boolean equals(Object o) {
        WikiPage oo;
        return o != null && o instanceof WikiPage && (oo = (WikiPage)o).getPath().equals(this.getPath()) && oo.getVersion() == this.getVersion();
    }

    public int hashCode() {
        return this.m_path.hashCode() * this.getVersion();
    }

    @Override
    public InputStream getContentAsStream() throws ProviderException {
        try {
            Property p = this.getJCRNode().getProperty(ATTR_CONTENT);
            return p.getStream();
        }
        catch (PathNotFoundException p) {
        }
        catch (RepositoryException e) {
            throw new ProviderException("Unable to get property", e);
        }
        return null;
    }

    @Override
    public String getContentType() {
        return (String)((Object)this.getAttribute(CONTENT_TYPE));
    }

    public List<WikiPath> getReferrers() throws ProviderException {
        return this.m_engine.getReferenceManager().getReferredBy(this.m_path);
    }

    @Override
    public List<WikiPath> getReferredBy() throws ProviderException {
        return this.m_engine.getReferenceManager().getReferredBy(this.m_path);
    }

    @Override
    public List<WikiPath> getRefersTo() throws ProviderException {
        return this.m_engine.getReferenceManager().getRefersTo(this.m_path);
    }

    @Override
    public void setContent(InputStream in) throws ProviderException {
        try {
            this.getJCRNode().setProperty(ATTR_CONTENT, in);
        }
        catch (RepositoryException e) {
            throw new ProviderException("Unable to set content", e);
        }
    }

    public void setContentType(String contentType) {
        this.setAttribute(CONTENT_TYPE, (Serializable)((Object)contentType));
    }

    @Override
    public void save() throws ProviderException {
        try {
            this.m_engine.getContentManager().save(this);
        }
        catch (RepositoryException e) {
            throw new ProviderException("Save failed", e);
        }
    }

    @Override
    public String getContentAsString() throws ProviderException {
        try {
            Property p = this.getJCRNode().getProperty(ATTR_CONTENT);
            return p.getString();
        }
        catch (PathNotFoundException p) {
        }
        catch (RepositoryException e) {
            throw new ProviderException("Unable to get property", e);
        }
        return null;
    }

    @Override
    public void setContent(String content) throws ProviderException {
        try {
            this.getJCRNode().setProperty(ATTR_CONTENT, content);
        }
        catch (RepositoryException e) {
            throw new ProviderException("Unable to set content", e);
        }
    }

    @Override
    public WikiPage getParent() throws PageNotFoundException, ProviderException {
        return this.m_engine.getContentManager().getPage(this.m_path.getParent());
    }

    @Override
    public String getFileName() {
        return this.m_path.getName();
    }

    public boolean isLatest() throws RepositoryException {
        return this.getJCRNode().getPath().indexOf("/wiki:versions/") == -1;
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public void setCacheable(boolean value) {
    }

    @Override
    public void setFileName(String name) {
    }

    @Override
    public boolean isAttachment() throws ProviderException {
        String contentType = this.getContentType();
        boolean exists = this.m_engine.getContentManager().pageExists(this.getPath());
        return exists && contentType != null && !"text/x-jspwiki".equals(contentType);
    }

    @Override
    public List<WikiPage> getChildren() throws ProviderException {
        ArrayList<WikiPage> pages = new ArrayList<WikiPage>();
        try {
            NodeIterator iter = this.getJCRNode().getNodes();
            while (iter.hasNext()) {
                Node n = iter.nextNode();
                if (n.getName().indexOf(58) != -1) continue;
                pages.add(new JCRWikiPage(this.m_engine, n));
            }
        }
        catch (PathNotFoundException e) {
            return new ArrayList<WikiPage>();
        }
        catch (RepositoryException e) {
            throw new ProviderException("Unable to list children", e);
        }
        return pages;
    }

    public JCRWikiPage getPredecessor() throws ProviderException, PageNotFoundException {
        List<WikiPage> versions = this.m_engine.getVersionHistory(this.getName());
        int thisVersion = this.getVersion();
        WikiPage p = null;
        int i = 0;
        while (i < versions.size()) {
            if (versions.get(i).getVersion() == thisVersion) break;
            p = versions.get(i);
            ++i;
        }
        if (p == null) {
            throw new PageNotFoundException("No predecessor");
        }
        return (JCRWikiPage)p;
    }

    @Override
    public Date getCreated() {
        try {
            if (this.getJCRNode().hasProperty(ATTR_CREATED)) {
                return this.getJCRNode().getProperty(ATTR_CREATED).getDate().getTime();
            }
        }
        catch (RepositoryException e) {
            log.warn("RepositoryException while getting created : " + (Object)((Object)e), new Object[0]);
        }
        return null;
    }

    public JCRWikiPage getCurrentVersion() throws ProviderException {
        try {
            return (JCRWikiPage)this.m_engine.getPage(this.getPath());
        }
        catch (PageNotFoundException e) {
            throw new ProviderException("version cannot access current page - this can be serious", e);
        }
    }
}

