/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content.inspect;

import java.util.Properties;
import org.apache.wiki.WikiContext;
import org.apache.wiki.content.inspect.Change;
import org.apache.wiki.content.inspect.Finding;
import org.apache.wiki.content.inspect.Inspection;
import org.apache.wiki.content.inspect.InspectionPlan;
import org.apache.wiki.content.inspect.Inspector;
import org.apache.wiki.content.inspect.Topic;
import org.apache.wiki.util.TextUtil;

public class UserInspector
implements Inspector {
    public static final String PROP_IGNORE_AUTHENTICATED = "ignoreauthenticated";
    private boolean m_ignoreAuthenticated = false;

    public Inspector.Scope getScope() {
        return Inspector.Scope.REQUEST;
    }

    public void initialize(InspectionPlan config) {
        Properties props = config.getProperties();
        this.m_ignoreAuthenticated = TextUtil.getBooleanProperty(props, PROP_IGNORE_AUTHENTICATED, this.m_ignoreAuthenticated);
    }

    public Finding[] inspect(Inspection inspection, Change change) {
        WikiContext context = inspection.getContext();
        if (context.hasAdminPermissions()) {
            return new Finding[]{new Finding(Topic.SPAM, Finding.Result.PASSED, "User is admin.")};
        }
        if (this.m_ignoreAuthenticated && context.getWikiSession().isAuthenticated()) {
            return new Finding[]{new Finding(Topic.SPAM, Finding.Result.PASSED, "User is authenticated.")};
        }
        return null;
    }
}

