/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content.inspect;

import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.content.inspect.AkismetInspector;
import org.apache.wiki.content.inspect.AsirraCaptcha;
import org.apache.wiki.content.inspect.BanListInspector;
import org.apache.wiki.content.inspect.BotTrapInspector;
import org.apache.wiki.content.inspect.Captcha;
import org.apache.wiki.content.inspect.ChangeRateInspector;
import org.apache.wiki.content.inspect.InspectionPlan;
import org.apache.wiki.content.inspect.Inspector;
import org.apache.wiki.content.inspect.LinkCountInspector;
import org.apache.wiki.content.inspect.PatternInspector;
import org.apache.wiki.content.inspect.UserInspector;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpamInspectionPlan
extends InspectionPlan {
    private static final Logger log = LoggerFactory.getLogger(SpamInspectionPlan.class);
    protected static final String PROP_INSPECTOR_WEIGHT_PREFIX = "inspectorWeight.spam.";
    public static final String PROP_SCORE_LIMIT = "spamScoreLimit";
    protected static final float DEFAULT_SCORE_LIMIT = -0.01f;
    protected static final String DEFAULT_CAPTCHA_CLASS = AsirraCaptcha.class.getName();
    protected static final float DEFAULT_WEIGHT = 0.0f;
    protected static final String PROP_CAPTCHA_CLASS = "jspwiki.captcha.implementation";
    private static final Map<WikiEngine, SpamInspectionPlan> c_plans = new WeakHashMap<WikiEngine, SpamInspectionPlan>();
    private final Captcha m_captcha;
    private final float m_limit;

    public static SpamInspectionPlan getInspectionPlan(WikiEngine engine) throws WikiException {
        SpamInspectionPlan plan = c_plans.get(engine);
        if (plan != null) {
            return plan;
        }
        Properties props = engine.getWikiProperties();
        plan = new SpamInspectionPlan(props);
        plan.addInspector(new UserInspector(), plan.getWeight(props, UserInspector.class));
        plan.addInspector(new BanListInspector(), plan.getWeight(props, BanListInspector.class));
        plan.addInspector(new ChangeRateInspector(), plan.getWeight(props, ChangeRateInspector.class));
        plan.addInspector(new LinkCountInspector(), plan.getWeight(props, LinkCountInspector.class));
        plan.addInspector(new BotTrapInspector(), plan.getWeight(props, BotTrapInspector.class));
        plan.addInspector(new AkismetInspector(), plan.getWeight(props, AkismetInspector.class));
        plan.addInspector(new PatternInspector(), plan.getWeight(props, PatternInspector.class));
        c_plans.put(engine, plan);
        return plan;
    }

    protected static Captcha initCaptcha(Properties props) throws WikiException {
        String captchaClassName = props.getProperty(PROP_CAPTCHA_CLASS, DEFAULT_CAPTCHA_CLASS);
        Class<?> captchaClass = null;
        try {
            captchaClass = Class.forName(captchaClassName);
        }
        catch (ClassNotFoundException e) {
            String msg = "No CAPTCHA implementation found for class " + captchaClassName;
            log.error(msg, e);
            throw new WikiException(msg, e);
        }
        Captcha captcha = null;
        if (captchaClass != null) {
            try {
                captcha = (Captcha)captchaClass.newInstance();
            }
            catch (Exception e) {
                String msg = "Could not create CAPTCHA instance for class " + captchaClassName;
                log.error(msg, e);
                throw new WikiException(msg, e);
            }
        }
        return captcha;
    }

    private SpamInspectionPlan(Properties properties) throws WikiException {
        super(properties);
        this.m_captcha = SpamInspectionPlan.initCaptcha(properties);
        float limit = -0.01f;
        String limitString = properties.getProperty(PROP_SCORE_LIMIT, String.valueOf(-0.01f));
        try {
            limit = Float.parseFloat(limitString);
        }
        catch (NumberFormatException e) {
            log.error("Property value spamScoreLimit did not parse to a float. Using -0.01", new Object[0]);
        }
        this.m_limit = limit;
    }

    public Captcha getCaptcha() throws WikiException {
        return this.m_captcha;
    }

    public float getSpamLimit() {
        return this.m_limit;
    }

    protected float getWeight(Properties props, Class<? extends Inspector> inspectorClass) {
        String key = PROP_INSPECTOR_WEIGHT_PREFIX + inspectorClass.getCanonicalName();
        float weight = 0.0f;
        String weightString = props.getProperty(key, String.valueOf(0.0f));
        try {
            weight = Float.parseFloat(weightString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return weight;
    }
}

