/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content.inspect;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.wiki.content.inspect.Change;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;

public class ReputationManager {
    private final List<Host> m_modifiers = new ArrayList<Host>();
    private final int m_banTime;
    private Map<String, Host> m_temporaryBanList = new HashMap<String, Host>();
    private static Logger log = LoggerFactory.getLogger(ReputationManager.class);
    public static final long NOT_BANNED = 0L;

    public ReputationManager(int minutes) {
        this.m_banTime = minutes;
    }

    public synchronized Host addModifier(HttpServletRequest request, Change change) {
        String addr = request.getRemoteAddr();
        Host host = new Host(addr, change, 0);
        this.m_modifiers.add(host);
        return host;
    }

    public Host banHost(HttpServletRequest request) {
        String ipAddress = request.getRemoteAddr();
        Host host = new Host(ipAddress, null, this.m_banTime);
        this.m_temporaryBanList.put(ipAddress, host);
        return host;
    }

    public int getBanTime() {
        return this.m_banTime;
    }

    public synchronized Host[] getModifiers() {
        Iterator<Host> iterator = this.m_modifiers.iterator();
        long time = System.currentTimeMillis() - 60000L;
        while (iterator.hasNext()) {
            Host modifier = iterator.next();
            if (modifier.getAddedTime() >= time) continue;
            log.debug("Removed host " + modifier.getAddress() + " from modification queue (expired)", new Object[0]);
            iterator.remove();
        }
        return this.m_modifiers.toArray(new Host[this.m_modifiers.size()]);
    }

    public long getRemainingBan(String ipAddress) {
        long now = System.currentTimeMillis();
        if (this.m_temporaryBanList.containsKey(ipAddress)) {
            Host host = this.m_temporaryBanList.get(ipAddress);
            if (host.getReleaseTime() < now) {
                log.debug("Removed host " + host.getAddress() + " from temporary ban list (expired)", new Object[0]);
                this.m_temporaryBanList.remove(ipAddress);
                return 0L;
            }
            long timeleft = (host.getReleaseTime() - now) / 1000L;
            return timeleft;
        }
        return 0L;
    }

    public Host unbanHost(HttpServletRequest request) {
        String ipAddress = request.getRemoteAddr();
        if (this.m_temporaryBanList.containsKey(ipAddress)) {
            return this.m_temporaryBanList.remove(ipAddress);
        }
        return null;
    }

    static class Host {
        private final long m_addedTime = System.currentTimeMillis();
        private final long m_releaseTime;
        private final String m_address;
        private final String m_change;

        public Host(String ipaddress, Change change, int releaseTime) {
            this.m_address = ipaddress;
            this.m_change = change == null ? null : change.getChange();
            this.m_releaseTime = System.currentTimeMillis() + (long)(releaseTime * 60) * 1000L;
        }

        public long getAddedTime() {
            return this.m_addedTime;
        }

        public String getAddress() {
            return this.m_address;
        }

        public String getChange() {
            return this.m_change;
        }

        public long getReleaseTime() {
            return this.m_releaseTime;
        }

        public String toString() {
            return "[" + this.m_address + " " + new Date(this.m_addedTime).toString() + " " + this.m_change.toString() + "]";
        }
    }
}

