/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content.inspect;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.inspect.Change;
import org.apache.wiki.content.inspect.Finding;
import org.apache.wiki.content.inspect.Inspection;
import org.apache.wiki.content.inspect.InspectionPlan;
import org.apache.wiki.content.inspect.Inspector;
import org.apache.wiki.content.inspect.Topic;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternInspector
implements Inspector {
    private String m_forbiddenWordsPage = "SpamFilterWordList";
    private String m_blacklist = "SpamFilterWordList/blacklist.txt";
    private static final Logger log = LoggerFactory.getLogger(PatternInspector.class);
    public static final String PROP_WORDLIST = "wordlist";
    public static final String PROP_BLACKLIST = "blacklist";
    private Collection<Pattern> m_spamPatterns = null;
    private Date m_lastRebuild = new Date(0L);
    private static final String LISTVAR = "spamwords";

    @Override
    public Inspector.Scope getScope() {
        return Inspector.Scope.FIELD;
    }

    @Override
    public void initialize(InspectionPlan config) {
        Properties properties = config.getProperties();
        this.m_forbiddenWordsPage = properties.getProperty(PROP_WORDLIST, this.m_forbiddenWordsPage);
        this.m_blacklist = properties.getProperty(PROP_BLACKLIST, this.m_blacklist);
    }

    @Override
    public Finding[] inspect(Inspection inspection, Change change) {
        WikiContext context = inspection.getContext();
        this.refreshBlacklists(context);
        if (this.m_spamPatterns == null || context.getPage().getName().equals(this.m_forbiddenWordsPage)) {
            return null;
        }
        String ch = change.toString();
        if (context.getHttpRequest() != null) {
            ch = String.valueOf(ch) + context.getHttpRequest().getRemoteAddr();
        }
        for (Pattern p : this.m_spamPatterns) {
            Matcher matcher = p.matcher(ch);
            if (!matcher.find()) continue;
            return new Finding[]{new Finding(Topic.SPAM, Finding.Result.FAILED, "'" + p.pattern() + "' is spam word. (Incident code " + inspection.getUid() + ")")};
        }
        return null;
    }

    private Collection<Pattern> parseBlacklist(String list) {
        ArrayList<Pattern> compiledpatterns = new ArrayList<Pattern>();
        if (list != null) {
            try {
                String line;
                BufferedReader in = new BufferedReader(new StringReader(list));
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                    int ws = line.indexOf(32);
                    if (ws == -1) {
                        ws = line.indexOf(9);
                    }
                    if (ws != -1) {
                        line = line.substring(0, ws);
                    }
                    try {
                        compiledpatterns.add(Pattern.compile(line));
                    }
                    catch (PatternSyntaxException e) {
                        log.debug("Malformed spam filter pattern " + line, new Object[0]);
                    }
                }
            }
            catch (IOException e) {
                log.info("Could not read patterns; returning what I got", e, new Object[0]);
            }
        }
        return compiledpatterns;
    }

    private Collection<Pattern> parseWordList(WikiPage source, String list) {
        ArrayList<Pattern> compiledpatterns = new ArrayList<Pattern>();
        if (list != null) {
            StringTokenizer tok = new StringTokenizer(list, " \t\n");
            while (tok.hasMoreTokens()) {
                String pattern = tok.nextToken();
                try {
                    compiledpatterns.add(Pattern.compile(pattern));
                }
                catch (PatternSyntaxException e) {
                    log.debug("Malformed spam filter pattern " + pattern, new Object[0]);
                    source.setAttribute("error", (Serializable)((Object)("Malformed spam filter pattern " + pattern)));
                }
            }
        }
        return compiledpatterns;
    }

    private void refreshBlacklists(WikiContext context) {
        try {
            WikiPage source = null;
            Attachment att = null;
            try {
                source = context.getEngine().getPage(this.m_forbiddenWordsPage);
                att = context.getEngine().getAttachmentManager().getAttachmentInfo(context, this.m_blacklist);
            }
            catch (PageNotFoundException pageNotFoundException) {
                // empty catch block
            }
            boolean rebuild = false;
            if (source != null && (this.m_spamPatterns == null || this.m_spamPatterns.isEmpty() || source.getLastModified().after(this.m_lastRebuild))) {
                rebuild = true;
            }
            if (att != null && (this.m_spamPatterns == null || this.m_spamPatterns.isEmpty() || att.getLastModified().after(this.m_lastRebuild))) {
                rebuild = true;
            }
            if (rebuild) {
                this.m_lastRebuild = new Date();
                this.m_spamPatterns = this.parseWordList(source, source != null ? (String)((Object)source.getAttribute(LISTVAR)) : null);
                log.info("Spam filter reloaded - recognizing " + this.m_spamPatterns.size() + " patterns from page " + this.m_forbiddenWordsPage, new Object[0]);
                if (att != null) {
                    InputStream in = context.getEngine().getAttachmentManager().getAttachmentStream(att);
                    StringWriter out = new StringWriter();
                    FileUtil.copyContents(new InputStreamReader(in, "UTF-8"), out);
                    Collection<Pattern> blackList = this.parseBlacklist(out.toString());
                    log.info("...recognizing additional " + blackList.size() + " patterns from blacklist " + this.m_blacklist, new Object[0]);
                    this.m_spamPatterns.addAll(blackList);
                }
            }
        }
        catch (IOException ex) {
            log.info("Unable to read attachment data, continuing...", ex, new Object[0]);
        }
        catch (ProviderException ex) {
            log.info("Failed to read spam filter attachment, continuing...", ex, new Object[0]);
        }
    }
}

