/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content.inspect;

import java.io.IOException;
import java.util.Locale;
import org.apache.wiki.WikiSession;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.content.inspect.Challenge;
import org.apache.wiki.i18n.InternationalizationManager;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;

public class PasswordChallenge
implements Challenge {
    private static final String PASSWORD_DESCRIPTION_KEY = "org.apache.wiki.content.inspect.PasswordChallenge.description";
    private static final String PASSWORD_KEY = "password";

    public boolean check(WikiActionBeanContext context) throws IOException {
        AuthenticationManager authMgr = context.getEngine().getAuthenticationManager();
        WikiSession wikiSession = context.getWikiSession();
        if (!wikiSession.isAuthenticated() || authMgr.isContainerAuthenticated()) {
            return false;
        }
        String loginName = wikiSession.getLoginPrincipal().getName();
        String password = context.getRequest().getParameter("j_password");
        if (loginName == null || password == null) {
            return false;
        }
        UserDatabase db = context.getEngine().getUserManager().getUserDatabase();
        return db.validatePassword(loginName, password);
    }

    public String formContent(WikiActionBeanContext context) throws IOException {
        boolean isContainerAuthentication = context.getEngine().getAuthenticationManager().isContainerAuthenticated();
        if (isContainerAuthentication) {
            return null;
        }
        Locale locale = context.getLocale();
        InternationalizationManager i18n = context.getEngine().getInternationalizationManager();
        String description = i18n.get("CoreResources", locale, PASSWORD_DESCRIPTION_KEY);
        String password = i18n.get("CoreResources", locale, PASSWORD_KEY);
        StringBuilder b = new StringBuilder();
        b.append("<div class=\"password\">" + description + "</div>");
        b.append("<label for=\"j_password\" value=\"" + password + "\" />\n");
        b.append("<input name=\"j_password\" id=\"j_password\" type=\"password\" />\n");
        return b.toString();
    }
}

