/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content.inspect;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.content.inspect.Change;
import org.apache.wiki.content.inspect.Finding;
import org.apache.wiki.content.inspect.Inspection;
import org.apache.wiki.content.inspect.InspectionPlan;
import org.apache.wiki.content.inspect.Inspector;
import org.apache.wiki.content.inspect.ReputationManager;
import org.apache.wiki.content.inspect.Topic;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.util.TextUtil;

public class LinkCountInspector
implements Inspector {
    private Pattern m_urlPattern;
    private static final String URL_REGEXP = "(http://|https://|mailto:)([A-Za-z0-9_/\\.\\+\\?\\#\\-\\@=&;]+)";
    private static Logger log = LoggerFactory.getLogger(LinkCountInspector.class);
    private InspectionPlan m_config;
    public static final String PROP_MAXURLS = "maxurls";
    private int m_maxUrls = 10;

    public Inspector.Scope getScope() {
        return Inspector.Scope.FIELD;
    }

    public void initialize(InspectionPlan config) {
        this.m_config = config;
        try {
            this.m_urlPattern = Pattern.compile(URL_REGEXP);
        }
        catch (PatternSyntaxException e) {
            log.error("Internal error: Someone put in a faulty pattern.", e);
            throw new InternalWikiException("Faulty pattern.");
        }
        this.m_maxUrls = TextUtil.getIntegerProperty(config.getProperties(), PROP_MAXURLS, this.m_maxUrls);
    }

    public Finding[] inspect(Inspection inspection, Change change) {
        String tstChange = change.toString();
        int urlCounter = 0;
        Matcher matcher = this.m_urlPattern.matcher(tstChange);
        while (matcher.find()) {
            ++urlCounter;
        }
        if (urlCounter > this.m_maxUrls) {
            WikiContext context = inspection.getContext();
            ReputationManager.Host host = this.m_config.getReputationManager().banHost(context.getHttpRequest());
            log.info("Added host " + host.getAddress() + " to temporary ban list for adding too many URLs. Change: " + change.toString(), new Object[0]);
            return new Finding[]{new Finding(Topic.SPAM, Finding.Result.FAILED, "You look like a spammer to me. (Incident code " + inspection.getUid() + ")")};
        }
        return null;
    }
}

