/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content.inspect;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.wiki.content.inspect.Inspector;
import org.apache.wiki.content.inspect.ReputationManager;
import org.apache.wiki.util.TextUtil;

public class InspectionPlan {
    private final Properties m_props;
    private final ReputationManager m_reputationManager;
    public static final String PROP_BANTIME = "bantime";
    private final Map<Inspector, Float> m_inspectors;

    public ReputationManager getReputationManager() {
        return this.m_reputationManager;
    }

    public InspectionPlan(Properties props) {
        this.m_props = props;
        int banTime = TextUtil.getIntegerProperty(props, PROP_BANTIME, 60);
        this.m_inspectors = new LinkedHashMap<Inspector, Float>();
        this.m_reputationManager = new ReputationManager(banTime);
    }

    public void addInspector(Inspector inspector, float weight) {
        this.m_inspectors.put(inspector, Float.valueOf(weight));
        inspector.initialize(this);
    }

    public Inspector[] getInspectors() {
        Set<Inspector> inspectors = this.m_inspectors.keySet();
        return inspectors.toArray(new Inspector[inspectors.size()]);
    }

    public float getWeight(Inspector inspector) {
        Float weight = this.m_inspectors.get(inspector);
        return weight == null ? 0.0f : weight.floatValue();
    }

    public Properties getProperties() {
        return this.m_props;
    }
}

