/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content.inspect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.content.inspect.Change;
import org.apache.wiki.content.inspect.Finding;
import org.apache.wiki.content.inspect.InspectionPlan;
import org.apache.wiki.content.inspect.Inspector;
import org.apache.wiki.content.inspect.ReputationManager;
import org.apache.wiki.content.inspect.Topic;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.util.TextUtil;

public class Inspection {
    private static final Logger log = LoggerFactory.getLogger(Inspection.class);
    private static final Logger c_spamlog = LoggerFactory.getLogger("SpamLog");
    private final Map<Topic, Float> m_scores = new HashMap<Topic, Float>();
    private final Map<Topic, List<Finding>> m_findings = new HashMap<Topic, List<Finding>>();
    private final InspectionPlan m_plan;
    private final WikiContext m_context;
    private final String m_uid;

    private static String getUniqueID() {
        StringBuilder sb = new StringBuilder();
        Random rand = new Random();
        int i = 0;
        while (i < 6) {
            char x = (char)(65 + rand.nextInt(26));
            sb.append(x);
            ++i;
        }
        return sb.toString();
    }

    public Inspection(WikiContext context, InspectionPlan plan) {
        if (context == null || plan == null) {
            throw new IllegalArgumentException("WikiContext and InspectionPlan must be supplied.");
        }
        this.m_context = context;
        this.m_plan = plan;
        this.m_uid = Inspection.getUniqueID();
    }

    public WikiContext getContext() {
        return this.m_context;
    }

    public Finding[] getFindings(Topic topic) {
        List<Finding> scores = this.m_findings.get(topic);
        if (scores == null) {
            return new Finding[0];
        }
        return scores.toArray(new Finding[scores.size()]);
    }

    public InspectionPlan getPlan() {
        return this.m_plan;
    }

    public float getScore(Topic topic) {
        if (this.m_scores.containsKey(topic)) {
            Float score = this.m_scores.get(topic);
            return score.floatValue();
        }
        return 0.0f;
    }

    public String getUid() {
        return this.m_uid;
    }

    public void inspect(Change ... changes) {
        this.m_scores.clear();
        this.m_findings.clear();
        Inspector[] inspectors = this.m_plan.getInspectors();
        Object[] objectArray = inspectors;
        int n = inspectors.length;
        int n2 = 0;
        while (n2 < n) {
            Inspector inspector = objectArray[n2];
            if (inspector.getScope() == Inspector.Scope.REQUEST) {
                Finding[] findings = inspector.inspect(this, null);
                this.processFindings(inspector, findings);
            }
            ++n2;
        }
        if (changes == null) {
            return;
        }
        objectArray = changes;
        n = changes.length;
        n2 = 0;
        while (n2 < n) {
            Object change = objectArray[n2];
            Inspector[] inspectorArray = inspectors;
            int n3 = inspectors.length;
            int n4 = 0;
            while (n4 < n3) {
                Inspector inspector = inspectorArray[n4];
                if (inspector.getScope() == Inspector.Scope.FIELD) {
                    Finding[] findings = inspector.inspect(this, (Change)change);
                    this.processFindings(inspector, findings);
                }
                ++n4;
            }
            ++n2;
        }
        ReputationManager mgr = this.m_plan.getReputationManager();
        Change[] changeArray = changes;
        int n5 = changes.length;
        n = 0;
        while (n < n5) {
            Change change = changeArray[n];
            mgr.addModifier(this.m_context.getHttpRequest(), change);
            ++n;
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Inspection[inspectors=");
        s.append(this.m_plan.getInspectors().length);
        s.append(",scores=");
        for (Map.Entry<Topic, Float> score : this.m_scores.entrySet()) {
            s.append(score.getKey().toString());
            s.append('=');
            s.append(score.getValue());
            s.append(' ');
        }
        return s.toString();
    }

    private void processFindings(Inspector inspector, Finding[] findings) {
        float weight = this.m_plan.getWeight(inspector);
        if (findings != null) {
            Finding[] findingArray = findings;
            int n = findings.length;
            int n2 = 0;
            while (n2 < n) {
                Finding finding = findingArray[n2];
                Topic topic = finding.getTopic();
                this.updateScore(topic, finding, weight);
                this.log(inspector, finding, weight);
                ++n2;
            }
        }
    }

    private void log(Inspector inspector, Finding finding, float weight) {
        String logMessage = finding.getMessage();
        log.info(logMessage, new Object[0]);
        logMessage = TextUtil.replaceString(logMessage, "\r\n", "\\r\\n");
        logMessage = TextUtil.replaceString(logMessage, "\"", "\\\"");
        WikiPage page = this.m_context.getPage();
        String pageName = page == null ? "(no page)" : page.getName();
        String reason = "UNKNOWN";
        String addr = this.m_context.getHttpRequest() != null ? this.m_context.getHttpRequest().getRemoteAddr() : "-";
        String source = inspector.getClass().getName();
        Finding.Result result = finding.getResult();
        switch (result) {
            case PASSED: {
                reason = "PASSED+" + weight;
                break;
            }
            case FAILED: {
                reason = "FAILED-" + weight;
                break;
            }
            default: {
                reason = " ";
            }
        }
        c_spamlog.info(String.valueOf(this.m_uid) + " " + reason + " " + source + " " + addr + " \"" + pageName + "\" " + logMessage, new Object[0]);
    }

    private void updateScore(Topic topic, Finding finding, float weight) {
        List<Finding> findings = this.m_findings.get(topic);
        if (findings == null) {
            findings = new ArrayList<Finding>();
            this.m_findings.put(topic, findings);
        }
        findings.add(finding);
        Float score = this.m_scores.get(topic);
        if (score == null) {
            score = Float.valueOf(0.0f);
        }
        switch (finding.getResult()) {
            case PASSED: {
                score = Float.valueOf(score.floatValue() + weight);
                break;
            }
            case FAILED: {
                score = Float.valueOf(score.floatValue() - weight);
            }
        }
        this.m_scores.put(topic, score);
    }
}

