/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content.inspect;

import org.apache.wiki.content.inspect.Topic;

public class Finding {
    private final Topic m_topic;
    private final String m_message;
    private final Result m_result;

    public Finding(Topic topic, Result result, String message) {
        if (topic == null || result == null || message == null) {
            throw new IllegalArgumentException("Topic, result and message must be supplied.");
        }
        this.m_topic = topic;
        this.m_result = result;
        this.m_message = message;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Finding)) {
            return false;
        }
        Finding f = (Finding)obj;
        return this.m_topic.equals(f.m_topic) && this.m_result.equals((Object)f.m_result) && this.m_message.equals(f.m_message);
    }

    public String getMessage() {
        return this.m_message;
    }

    public Result getResult() {
        return this.m_result;
    }

    public Topic getTopic() {
        return this.m_topic;
    }

    public int hashCode() {
        return this.m_topic.hashCode() + 7 * this.m_result.hashCode() + 31 * this.m_message.hashCode();
    }

    public String toString() {
        return "Finding[" + this.m_topic + ", " + this.m_result.toString() + ", \"" + this.m_message + "\"]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Result {
        PASSED,
        FAILED,
        NO_EFFECT;

    }
}

