/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content.inspect;

import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.wiki.content.inspect.Change;
import org.apache.wiki.content.inspect.Finding;
import org.apache.wiki.content.inspect.Inspection;
import org.apache.wiki.content.inspect.InspectionPlan;
import org.apache.wiki.content.inspect.Inspector;
import org.apache.wiki.content.inspect.ReputationManager;
import org.apache.wiki.content.inspect.Topic;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.util.TextUtil;

public class ChangeRateInspector
implements Inspector {
    public static final String PROP_PAGECHANGES = "spam.limit.pageChanges";
    public static final String PROP_SIMILARCHANGES = "spam.limit.similarChanges";
    private static Logger log = LoggerFactory.getLogger(ChangeRateInspector.class);
    private int m_limitSinglePageChanges = 5;
    private int m_limitSimilarChanges = 2;

    public Inspector.Scope getScope() {
        return Inspector.Scope.FIELD;
    }

    public void initialize(InspectionPlan config) {
        Properties props = config.getProperties();
        this.m_limitSinglePageChanges = TextUtil.getIntegerProperty(props, PROP_PAGECHANGES, this.m_limitSinglePageChanges);
        this.m_limitSimilarChanges = TextUtil.getIntegerProperty(props, PROP_SIMILARCHANGES, this.m_limitSimilarChanges);
        log.info("Spam filter initialized.  Temporary ban time " + config.getReputationManager().getBanTime() + " mins, max page changes/minute: " + this.m_limitSinglePageChanges, new Object[0]);
    }

    public Finding[] inspect(Inspection inspection, Change change) {
        HttpServletRequest req = inspection.getContext().getHttpRequest();
        if (req == null) {
            return null;
        }
        String addr = req.getRemoteAddr();
        int hostCounter = 0;
        int changeCounter = 0;
        log.debug("Change is " + change.getChange(), new Object[0]);
        ReputationManager.Host[] hostArray = inspection.getPlan().getReputationManager().getModifiers();
        int n = hostArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReputationManager.Host host = hostArray[n2];
            if (host.getAddress().equals(addr)) {
                ++hostCounter;
            }
            if (host.getChange() != null && host.getChange().equals(change.getChange())) {
                ++changeCounter;
            }
            ++n2;
        }
        if (hostCounter >= this.m_limitSinglePageChanges) {
            inspection.getPlan().getReputationManager().banHost(req);
            log.info("Too many modifications/minute. Added host " + addr + " to temporary ban list. Change: " + change.getChange(), new Object[0]);
            return new Finding[]{new Finding(Topic.SPAM, Finding.Result.FAILED, "You look like a spammer to me. (Incident code " + inspection.getUid() + ")")};
        }
        if (changeCounter >= this.m_limitSimilarChanges) {
            inspection.getPlan().getReputationManager().banHost(req);
            log.info("Too many similar modifications. Added host " + addr + " to temporary ban list. Change: " + change.getChange(), new Object[0]);
            return new Finding[]{new Finding(Topic.SPAM, Finding.Result.FAILED, "You look like a spammer to me. (Incident code " + inspection.getUid() + ")")};
        }
        return null;
    }
}

