/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content.inspect;

import org.apache.commons.jrcs.diff.AddDelta;
import org.apache.commons.jrcs.diff.ChangeDelta;
import org.apache.commons.jrcs.diff.DeleteDelta;
import org.apache.commons.jrcs.diff.Delta;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.diff.DiffAlgorithm;
import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.commons.jrcs.diff.Revision;
import org.apache.commons.jrcs.diff.myers.MyersDiff;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.providers.ProviderException;

public class Change {
    private final String m_name;
    private final String m_value;
    private final String m_change;
    private final int m_adds;
    private final int m_removals;

    public static Change getChange(String name, String newText) {
        return new Change(name, newText, 1, 0, newText);
    }

    public static Change getChange(String name, String oldText, String newText) throws DifferentiationFailedException {
        Object[] second;
        if (oldText == null || newText == null) {
            throw new IllegalArgumentException("Parameters oldText and newText must be supplied.");
        }
        StringBuffer changes = new StringBuffer();
        Object[] first = Diff.stringToArray((String)oldText);
        Revision rev = Diff.diff((Object[])first, (Object[])(second = Diff.stringToArray((String)newText)), (DiffAlgorithm)new MyersDiff());
        if (rev == null || rev.size() == 0) {
            return new Change(name, newText, 0, 0, null);
        }
        int adds = 0;
        int removals = 0;
        int i = 0;
        while (i < rev.size()) {
            String suffix;
            Delta d = rev.getDelta(i);
            String string = suffix = i < rev.size() - 1 ? "\r\n" : "";
            if (d instanceof AddDelta) {
                d.getRevised().toString(changes, "", suffix);
                ++adds;
            } else if (d instanceof ChangeDelta) {
                d.getRevised().toString(changes, "", suffix);
                ++adds;
            } else if (d instanceof DeleteDelta) {
                ++removals;
            }
            ++i;
        }
        return new Change(name, newText, adds, removals, changes.toString());
    }

    public String getName() {
        return this.m_name;
    }

    public static Change getPageChange(WikiContext context, String newText) throws DifferentiationFailedException {
        WikiPage page = context.getPage();
        WikiEngine engine = context.getEngine();
        StringBuilder changes = new StringBuilder();
        if (engine.pageExists(page.getName())) {
            String oldText;
            try {
                oldText = page.getContentAsString();
            }
            catch (ProviderException e) {
                e.printStackTrace();
                throw new DifferentiationFailedException("Differentiation failed: " + e.getMessage());
            }
            changes.append(oldText);
            String changeNote = (String)((Object)page.getAttribute("changenote"));
            if (changeNote != null) {
                changes.append("\r\n");
                changes.append(changeNote);
            }
            if (page.getAuthor() != null) {
                changes.append("\r\n" + page.getAuthor());
            }
        }
        return Change.getChange("page", changes.toString(), newText);
    }

    private Change(String name, String newText, int adds, int removals, String change) {
        this.m_name = name;
        this.m_value = newText;
        this.m_adds = adds;
        this.m_removals = removals;
        this.m_change = change;
    }

    public boolean equals(Object o) {
        if (o instanceof Change) {
            return this.m_name.equals(((Change)o).m_name) && this.m_change.equals(((Change)o).m_change);
        }
        return false;
    }

    public int getAdds() {
        return this.m_adds;
    }

    public String getChange() {
        return this.m_change;
    }

    public int getRemovals() {
        return this.m_removals;
    }

    public String getValue() {
        return this.m_value;
    }

    public int hashCode() {
        return this.m_change.hashCode() + 17;
    }

    public String toString() {
        return this.m_change;
    }
}

