/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content.inspect;

import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.util.CryptoUtil;
import org.apache.wiki.WikiContext;
import org.apache.wiki.content.inspect.Change;
import org.apache.wiki.content.inspect.Finding;
import org.apache.wiki.content.inspect.Inspection;
import org.apache.wiki.content.inspect.InspectionPlan;
import org.apache.wiki.content.inspect.Inspector;
import org.apache.wiki.content.inspect.Topic;

public class BotTrapInspector
implements Inspector {
    public static final String REQ_ENCODING_CHECK = "__wikiEncodingcheck";
    public static final String REQ_TRAP_PARAM = "submit_auth";
    public static final String REQ_SPAM_PARAM = "__wikiCheck";

    public Inspector.Scope getScope() {
        return Inspector.Scope.REQUEST;
    }

    public void initialize(InspectionPlan config) {
    }

    public Finding[] inspect(Inspection inspection, Change change) {
        WikiContext context = inspection.getContext();
        HttpServletRequest request = context.getHttpRequest();
        if (request == null) {
            return new Finding[]{new Finding(Topic.SPAM, Finding.Result.NO_EFFECT, "No HTTP request supplied.")};
        }
        String trapParam = request.getParameter(REQ_TRAP_PARAM);
        if (trapParam != null && trapParam.length() > 0) {
            return new Finding[]{new Finding(Topic.SPAM, Finding.Result.FAILED, "Bot detected: trap parameter was set (should have been null).")};
        }
        String encryptedParam = request.getParameter(REQ_SPAM_PARAM);
        if (encryptedParam == null) {
            return new Finding[]{new Finding(Topic.SPAM, Finding.Result.FAILED, "Missing encrypted spam parameter.")};
        }
        String tokenParam = CryptoUtil.decrypt((String)encryptedParam);
        if (tokenParam == null) {
            return new Finding[]{new Finding(Topic.SPAM, Finding.Result.FAILED, "Could not obtain name of token parameter.")};
        }
        String tokenValue = request.getParameter(tokenParam);
        if (tokenValue == null || !request.getSession().getId().equals(tokenValue)) {
            return new Finding[]{new Finding(Topic.SPAM, Finding.Result.FAILED, "Could not obtain token value.")};
        }
        String utf8field = request.getParameter(REQ_ENCODING_CHECK);
        if (utf8field == null || !utf8field.equals("\u3041")) {
            return new Finding[]{new Finding(Topic.SPAM, Finding.Result.FAILED, "Bot detected: missing UTF-8 parameter.")};
        }
        return null;
    }
}

