/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content.inspect;

import javax.servlet.http.HttpServletRequest;
import org.apache.wiki.WikiContext;
import org.apache.wiki.content.inspect.Change;
import org.apache.wiki.content.inspect.Finding;
import org.apache.wiki.content.inspect.Inspection;
import org.apache.wiki.content.inspect.InspectionPlan;
import org.apache.wiki.content.inspect.Inspector;
import org.apache.wiki.content.inspect.ReputationManager;
import org.apache.wiki.content.inspect.Topic;

public class BanListInspector
implements Inspector {
    public Inspector.Scope getScope() {
        return Inspector.Scope.REQUEST;
    }

    public void initialize(InspectionPlan config) {
    }

    public Finding[] inspect(Inspection inspection, Change change) {
        String remote;
        long timeleft;
        ReputationManager banList = inspection.getPlan().getReputationManager();
        WikiContext context = inspection.getContext();
        HttpServletRequest req = context.getHttpRequest();
        if (req != null && (timeleft = banList.getRemainingBan(remote = req.getRemoteAddr())) != 0L) {
            return new Finding[]{new Finding(Topic.SPAM, Finding.Result.FAILED, "You have been temporarily banned from modifying this wiki. (" + timeleft + " seconds of ban left)")};
        }
        return null;
    }
}

