/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content.inspect;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.util.CryptoUtil;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.wiki.content.inspect.Captcha;
import org.apache.wiki.content.inspect.InspectionPlan;
import org.apache.wiki.i18n.InternationalizationManager;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsirraCaptcha
implements Captcha {
    protected static final Pattern SESSION_ID_PATTERN = Pattern.compile("NewSessionComplete.+?\"(.+?)\"", 8);
    protected static final Pattern CATS_PATTERN = Pattern.compile("ImgRec\\(\"(.+?)\",\"(.+?)\",", 8);
    private static final String ASIRRA_ADOPT_ME_KEY = "org.apache.wiki.content.inspect.AsirraCaptcha.adoptMe";
    private static final String ASIRRA_DESCRIPTION_KEY = "org.apache.wiki.content.inspect.AsirraCaptcha.description";
    private static final String CAT_PARAM_PREFIX = "asirra_cat_";
    private static final Random RANDOM = new Random();
    private static final String SESSION_ID_PARAM = "asirra_session_id";
    private boolean m_enabled = false;
    protected static final String CHALLENGE_URL = "http://challenge.asirra.com/cgi/Asirra?action=CreateSession";
    protected static final String CHECK_URL = "http://challenge.asirra.com/cgi/Asirra?action=ScoreResponse";
    protected static final String SERVICE_URL = "http://challenge.asirra.com/";
    private static Logger log = LoggerFactory.getLogger(AsirraCaptcha.class);

    private static String random() {
        String nonce = String.valueOf(Math.abs(RANDOM.nextInt()));
        return "&rand=" + nonce;
    }

    protected static List<Pet> extractChallenges(String challengeResponse) {
        ArrayList<Pet> pets = new ArrayList<Pet>();
        Matcher matcher = CATS_PATTERN.matcher(challengeResponse);
        while (matcher.find()) {
            pets.add(new Pet(matcher.group(1), matcher.group(2)));
        }
        return pets;
    }

    protected static String extractSessionId(String challengeResponse) {
        Matcher m = SESSION_ID_PATTERN.matcher(challengeResponse);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    protected static String getChallengeResponse() throws IOException {
        HttpClient client = new HttpClient();
        String challengeUrl = CHALLENGE_URL + AsirraCaptcha.random();
        GetMethod method = new GetMethod(challengeUrl);
        int status = client.executeMethod((HttpMethod)method);
        if (status == 200) {
            return method.getResponseBodyAsString();
        }
        throw new IOException("Response from Asirra was unexpected: " + status);
    }

    @Override
    public boolean check(WikiActionBeanContext actionBeanContext) {
        HttpServletRequest request = actionBeanContext.getRequest();
        String encryptedSessionId = request.getParameter(SESSION_ID_PARAM);
        String sessionId = null;
        if (encryptedSessionId != null) {
            sessionId = CryptoUtil.decrypt((String)encryptedSessionId);
        }
        String response = "";
        int i = 0;
        while (i < 12) {
            String cat = request.getParameter(CAT_PARAM_PREFIX + i);
            String singleResponse = cat == null || !"1".equals(cat) ? "0" : "1";
            response = String.valueOf(response) + singleResponse;
            ++i;
        }
        String submission = "http://challenge.asirra.com/cgi/Asirra?action=ScoreResponse&sessionId=" + sessionId + "&response=" + response + AsirraCaptcha.random();
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(submission);
        try {
            int status = client.executeMethod((HttpMethod)method);
            String body = method.getResponseBodyAsString();
            return status == 200 && body.indexOf("/* correct */") != -1;
        }
        catch (Exception e) {
            log.error("Could not execute Asirra CAPTHA: " + e.getMessage(), new Object[0]);
            return false;
        }
    }

    @Override
    public String formContent(WikiActionBeanContext context) throws IOException {
        String challengeResponse = AsirraCaptcha.getChallengeResponse();
        String sessionId = AsirraCaptcha.extractSessionId(challengeResponse);
        List<Pet> pets = AsirraCaptcha.extractChallenges(challengeResponse);
        Locale locale = context.getLocale();
        InternationalizationManager i18n = context.getEngine().getInternationalizationManager();
        String description = i18n.get("CoreResources", locale, ASIRRA_DESCRIPTION_KEY);
        String adoptMe = i18n.get("CoreResources", locale, ASIRRA_ADOPT_ME_KEY);
        StringBuilder b = new StringBuilder();
        b.append("<input name=\"asirra_session_id\" type=\"hidden\" value=\"" + CryptoUtil.encrypt((String)sessionId) + "\" />\n");
        b.append("<div class=\"asirra\">" + description + "</div>");
        b.append("<table class=\"asirraCaptcha\">");
        int i = 0;
        for (Pet pet : pets) {
            boolean lastInRow;
            boolean firstInRow = i % 4 == 0;
            boolean bl = lastInRow = (i + 1) % 4 == 0;
            if (firstInRow) {
                b.append("<tr>");
            }
            b.append("<td>");
            b.append("<img src=\"http:" + pet.url() + "\" />");
            b.append("<br/>");
            b.append("<input type=\"checkbox\" name=\"asirra_cat_" + i + "\" value=\"1\">");
            b.append(adoptMe);
            b.append("</input>");
            b.append("</td>");
            if (lastInRow) {
                b.append("</tr>");
            }
            ++i;
        }
        b.append("</table>");
        return b.toString();
    }

    public void initialize(InspectionPlan config) {
        try {
            URL url = new URL(SERVICE_URL);
            url.openConnection();
            this.m_enabled = true;
        }
        catch (MalformedURLException url) {
        }
        catch (IOException e) {
            log.info("Asirra CAPTCHA service not available. Disabling...", new Object[0]);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.m_enabled;
    }

    protected static class Pet {
        private final String m_id;
        private final String m_url;

        public Pet(String id, String url) {
            this.m_id = id;
            this.m_url = url;
        }

        public String id() {
            return this.m_id;
        }

        public String url() {
            return this.m_url;
        }
    }
}

