/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content.inspect;

import javax.servlet.http.HttpServletRequest;
import net.sf.akismet.Akismet;
import org.apache.commons.lang.time.StopWatch;
import org.apache.wiki.WikiContext;
import org.apache.wiki.content.inspect.Change;
import org.apache.wiki.content.inspect.Finding;
import org.apache.wiki.content.inspect.Inspection;
import org.apache.wiki.content.inspect.InspectionPlan;
import org.apache.wiki.content.inspect.Inspector;
import org.apache.wiki.content.inspect.Topic;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.util.TextUtil;

public class AkismetInspector
implements Inspector {
    private static Logger log = LoggerFactory.getLogger(AkismetInspector.class);
    private String m_akismetAPIKey = null;
    private Akismet m_akismet;
    public static final String PROP_AKISMET_API_KEY = "akismet-apikey";

    public void initialize(InspectionPlan config) {
        this.m_akismetAPIKey = TextUtil.getStringProperty(config.getProperties(), PROP_AKISMET_API_KEY, this.m_akismetAPIKey);
    }

    public Inspector.Scope getScope() {
        return Inspector.Scope.REQUEST;
    }

    public Finding[] inspect(Inspection inspection, Change change) {
        WikiContext context = inspection.getContext();
        HttpServletRequest req = context.getHttpRequest();
        if (this.m_akismetAPIKey == null || req == null) {
            return null;
        }
        if (this.m_akismet == null) {
            log.info("Initializing Akismet spam protection.", new Object[0]);
            this.m_akismet = new Akismet(this.m_akismetAPIKey, context.getEngine().getBaseURL());
            if (!this.m_akismet.verifyAPIKey()) {
                log.error("Akismet API key cannot be verified.  Please check your config.", new Object[0]);
                this.m_akismetAPIKey = null;
                this.m_akismet = null;
                return null;
            }
        }
        if (change.getAdds() == 0 && change.getRemovals() > 0) {
            return null;
        }
        log.debug("Calling Akismet to check for spam...", new Object[0]);
        StopWatch sw = new StopWatch();
        sw.start();
        String ipAddress = req.getRemoteAddr();
        String userAgent = req.getHeader("User-Agent");
        String referrer = req.getHeader("Referer");
        String permalink = context.getViewURL(context.getPage().getName());
        String commentType = context.getRequestContext().equals(WikiContext.COMMENT) ? "comment" : "edit";
        String commentAuthor = context.getCurrentUser().getName();
        String commentAuthorEmail = null;
        String commentAuthorURL = null;
        boolean isSpam = this.m_akismet.commentCheck(ipAddress, userAgent, referrer, permalink, commentType, commentAuthor, commentAuthorEmail, commentAuthorURL, change.toString(), null);
        sw.stop();
        log.debug("Akismet request done in: " + sw, new Object[0]);
        if (isSpam) {
            log.info("Akismet thinks change is spam; added host " + ipAddress + " to temporary ban list. Change: " + change.toString(), new Object[0]);
            return new Finding[]{new Finding(Topic.SPAM, Finding.Result.FAILED, "You look like a spammer to me. (Incident code " + inspection.getUid() + ")")};
        }
        return null;
    }
}

