/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.wiki.content.ContentManager;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.content.jcr.JCRWikiPage;
import org.apache.wiki.providers.ProviderException;

public class WikiPathResolver {
    public static final PathRoot[] PATH_ROOTS = new PathRoot[]{PathRoot.NOT_CREATED, PathRoot.PAGES};
    private Node[] m_searchNodes = null;
    private static final Map<ContentManager, WikiPathResolver> c_resolvers = new HashMap<ContentManager, WikiPathResolver>();
    private final ContentManager m_cm;
    private final Map<String, WikiPath> m_uuids = new HashMap<String, WikiPath>();
    private final Map<WikiPath, String> m_paths = new HashMap<WikiPath, String>();
    private final Map<String, WikiPath> m_canonicalPaths = new HashMap<String, WikiPath>();

    private WikiPathResolver(ContentManager contentManager) {
        this.m_cm = contentManager;
    }

    public static WikiPathResolver getInstance(ContentManager contentManager) {
        WikiPathResolver cache = c_resolvers.get(contentManager);
        if (cache == null) {
            cache = new WikiPathResolver(contentManager);
            c_resolvers.put(contentManager, cache);
        }
        return cache;
    }

    public static String getJCRPath(WikiPath path, PathRoot foundry) {
        String spaceName = path.getSpace().toLowerCase();
        String spacePath = path.getPath().toLowerCase();
        return String.valueOf(foundry.path()) + spaceName + "/" + spacePath;
    }

    public synchronized void clear() {
        this.m_canonicalPaths.clear();
        this.m_paths.clear();
        this.m_uuids.clear();
    }

    protected synchronized void add(WikiPath path, String uuid) throws RepositoryException {
        WikiPath canonicalPath = this.canonicalizeFromJCRPath(String.valueOf(path.getSpace()) + "/" + path.getPath());
        this.m_paths.put(canonicalPath, uuid);
        this.m_uuids.put(uuid, canonicalPath);
    }

    protected synchronized void remove(WikiPath path) {
        if (this.m_paths.containsKey(path)) {
            String uuid = this.m_paths.get(path);
            this.m_canonicalPaths.remove(path);
            this.m_paths.remove(path);
            this.m_uuids.remove(uuid);
        }
    }

    public WikiPath getWikiPath(String jcrPath, PathRoot foundry) throws ProviderException {
        if (jcrPath.startsWith(foundry.path())) {
            try {
                return this.canonicalizeFromJCRPath(jcrPath.substring(foundry.path().length()));
            }
            catch (RepositoryException e) {
                throw new ProviderException("Could not canonicalize WikiPath: " + jcrPath, e);
            }
        }
        throw new ProviderException("This is not a valid JSPWiki JCR path: " + jcrPath);
    }

    protected WikiPath canonicalizeFromJCRPath(String rawPath) throws RepositoryException {
        WikiPath canonicalPath = this.m_canonicalPaths.get(rawPath);
        if (canonicalPath != null) {
            return canonicalPath;
        }
        if (this.m_searchNodes == null) {
            Node root = this.m_cm.getCurrentSession().getRootNode();
            this.m_searchNodes = new Node[]{root.getNode(PathRoot.NOT_CREATED.path()), root.getNode(PathRoot.PAGES.path())};
        }
        String[] components = rawPath.split("/");
        String path = "";
        String jcrPath = "";
        boolean seenSpace = false;
        String[] stringArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            String component = stringArray[n2];
            String title = null;
            jcrPath = String.valueOf(jcrPath) + component;
            Node[] nodeArray = this.m_searchNodes;
            int n3 = this.m_searchNodes.length;
            int n4 = 0;
            while (n4 < n3) {
                Node searchNode = nodeArray[n4];
                try {
                    if (searchNode.hasNode(jcrPath)) {
                        Node node = searchNode.getNode(jcrPath);
                        title = node.getProperty("wiki:title").getString();
                        break;
                    }
                }
                catch (PathNotFoundException pathNotFoundException) {
                    // empty catch block
                }
                ++n4;
            }
            jcrPath = String.valueOf(jcrPath) + "/";
            path = String.valueOf(path) + (title == null ? component : title) + (seenSpace ? "/" : ":");
            seenSpace = true;
            ++n2;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        canonicalPath = WikiPath.valueOf(path);
        this.m_canonicalPaths.put(rawPath, canonicalPath);
        return canonicalPath;
    }

    protected WikiPath getByUUID(String uuid) throws RepositoryException {
        if (uuid == null) {
            throw new IllegalArgumentException("null UUID given to getByUUID()");
        }
        WikiPath path = this.m_uuids.get(uuid);
        if (path != null) {
            return path;
        }
        Node node = this.m_cm.getCurrentSession().getNodeByUUID(uuid);
        String jcrPath = node.getPath();
        PathRoot[] pathRootArray = PATH_ROOTS;
        int n = PATH_ROOTS.length;
        int n2 = 0;
        while (n2 < n) {
            PathRoot pathRoot = pathRootArray[n2];
            String prefix = pathRoot.path();
            if (jcrPath.startsWith(prefix)) {
                try {
                    return this.getWikiPath(jcrPath, pathRoot);
                }
                catch (ProviderException e) {
                    throw new RepositoryException("Could not construct WikiPath for " + jcrPath, (Throwable)e);
                }
            }
            ++n2;
        }
        throw new RepositoryException("This is not a valid JSPWiki JCR path: " + jcrPath);
    }

    protected String getUUID(WikiPath path) throws RepositoryException, ItemNotFoundException {
        if (path == null) {
            throw new IllegalArgumentException("null WikiPath given to getUUID()");
        }
        String uuid = this.m_paths.get(path);
        if (uuid != null) {
            return uuid;
        }
        try {
            if (this.m_cm.pageExists(path)) {
                JCRWikiPage page = this.m_cm.getPage(path);
                uuid = page.getJCRNode().getUUID();
                this.add(path, uuid);
                return uuid;
            }
        }
        catch (ProviderException e) {
            throw new RepositoryException("Error getting path " + path.toString() + ".", (Throwable)e);
        }
        catch (PageNotFoundException e) {
            throw new RepositoryException("Bug: could not retrieve " + path.toString() + " even though ContentManager said it existed.", (Throwable)e);
        }
        throw new ItemNotFoundException("No saved node for path " + path + " was found.");
    }

    public static class PathRoot {
        public static final PathRoot PAGES = new PathRoot("/pages/");
        public static final PathRoot NOT_CREATED = new PathRoot("/wiki:references/wiki:notCreated/");
        private final String m_path;

        public String path() {
            return this.m_path;
        }

        private PathRoot(String jcrPath) {
            this.m_path = jcrPath;
        }
    }
}

