/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WikiPath
implements Serializable,
Comparable<WikiPath> {
    private static final long serialVersionUID = 1L;
    private final String m_space;
    private final String m_path;
    private final String m_name;
    private final String m_stringRepresentation;
    private final String m_insensitiveString;

    public WikiPath(String space, String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path must not be null!");
        }
        this.m_path = path;
        int lastSlash = path.lastIndexOf("/");
        this.m_name = lastSlash == -1 ? path : (lastSlash == path.length() - 1 ? "" : path.substring(lastSlash + 1, path.length()));
        this.m_space = space == null ? "Main" : space;
        this.m_stringRepresentation = String.valueOf(this.m_space) + ":" + this.m_path;
        this.m_insensitiveString = this.m_stringRepresentation.toLowerCase();
    }

    public static WikiPath valueOf(String path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException("null path given to WikiPath.valueOf().");
        }
        int colon = path.indexOf(58);
        if (colon != -1) {
            return new WikiPath(path.substring(0, colon), path.substring(colon + 1));
        }
        return new WikiPath("Main", path);
    }

    public String getName() {
        return this.m_name;
    }

    public String getSpace() {
        return this.m_space;
    }

    public String getPath() {
        return this.m_path;
    }

    public WikiPath getParent() {
        int slash = this.m_path.lastIndexOf(47);
        if (slash == -1) {
            return null;
        }
        return new WikiPath(this.m_space, this.m_path.substring(0, slash));
    }

    public WikiPath resolve(String path) {
        int colon = path.indexOf(58);
        if (colon != -1) {
            return WikiPath.valueOf(path);
        }
        return new WikiPath(this.getSpace(), path);
    }

    public String toString() {
        return this.m_stringRepresentation;
    }

    public int hashCode() {
        return this.m_insensitiveString.hashCode();
    }

    @Override
    public int compareTo(WikiPath o) {
        return this.m_insensitiveString.compareTo(o.m_insensitiveString);
    }

    public boolean equals(Object o) {
        if (o instanceof WikiPath) {
            WikiPath n = (WikiPath)o;
            return this.m_insensitiveString.equals(n.m_insensitiveString);
        }
        if (o instanceof String) {
            return this.m_insensitiveString.equals(((String)o).toLowerCase());
        }
        return false;
    }
}

