/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.content.ContentManager;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.content.WikiPathResolver;
import org.apache.wiki.content.jcr.JCRWikiPage;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.modules.InternalModule;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;
import org.apache.wiki.util.LinkCollector;
import org.apache.wiki.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceManager
implements InternalModule,
WikiEventListener {
    private static final long serialVersionUID = 4L;
    private static final String PROPERTY_NOT_REFERENCED = "notReferenced";
    private static final String[] NO_VALUES = new String[0];
    protected static final Pattern LINK_PATTERN = Pattern.compile("([\\[\\~]?)\\[([^\\|\\]]*)(\\|)?([^\\|\\]]*)(\\|)?([^\\|\\]]*)\\]");
    protected static final String REFERENCES_ROOT = "/wiki:references";
    protected static final String PROPERTY_REFERRED_BY = "wiki:referredBy";
    protected static final String PROPERTY_REFERS_TO = "wiki:refersTo";
    protected static final String NOT_REFERENCED = "/wiki:references/wiki:notReferenced";
    protected static final String NOT_CREATED = "/wiki:references/wiki:notCreated";
    private WikiEngine m_engine;
    private ContentManager m_cm;
    private WikiPathResolver m_pathCache;
    private boolean m_camelCase = false;
    private boolean m_matchEnglishPlurals = false;

    private static String renameCamelCaseLinks(String sourceText, String from, String to) {
        StringBuilder sb = new StringBuilder(sourceText.length() + 32);
        Pattern linkPattern = Pattern.compile("\\p{Lu}+\\p{Ll}+\\p{Lu}+[\\p{L}\\p{Digit}]*");
        Matcher matcher = linkPattern.matcher(sourceText);
        int start = 0;
        while (matcher.find(start)) {
            String match = matcher.group();
            sb.append(sourceText.substring(start, matcher.start()));
            int lastOpenBrace = sourceText.lastIndexOf(91, matcher.start());
            int lastCloseBrace = sourceText.lastIndexOf(93, matcher.start());
            if (match.equals(from) && lastCloseBrace >= lastOpenBrace) {
                sb.append(to);
            } else {
                sb.append(match);
            }
            start = matcher.end();
        }
        sb.append(sourceText.substring(start));
        return sb.toString();
    }

    private static String renameLink(String original, String from, String newlink) {
        int hash = original.indexOf(35);
        int slash = original.indexOf(47);
        String reallink = original;
        if (hash != -1) {
            reallink = original.substring(0, hash);
        }
        if (slash != -1) {
            reallink = original.substring(0, slash);
        }
        reallink = MarkupParser.cleanLink(reallink);
        String oldStyleRealLink = MarkupParser.wikifyLink(reallink);
        if (reallink.equalsIgnoreCase(from) || original.equalsIgnoreCase(from) || oldStyleRealLink.equalsIgnoreCase(from)) {
            int blank = reallink.indexOf(" ");
            if (blank != -1) {
                return String.valueOf(original) + "|" + newlink;
            }
            return String.valueOf(newlink) + (hash > 0 ? original.substring(hash) : "");
        }
        return original;
    }

    protected static String renameLinks(String sourceText, String from, String to) {
        StringBuilder sb = new StringBuilder(sourceText.length() + 32);
        Matcher matcher = LINK_PATTERN.matcher(sourceText);
        int start = 0;
        while (matcher.find(start)) {
            int charBefore = 65535;
            if (matcher.start() > 0) {
                charBefore = sourceText.charAt(matcher.start() - 1);
            }
            if (matcher.group(1).length() > 0 || charBefore == 126 || charBefore == 91) {
                sb.append(sourceText.substring(start, matcher.end()));
                start = matcher.end();
                continue;
            }
            String text = matcher.group(2);
            String link = matcher.group(4);
            String attr = matcher.group(6);
            if (link.length() == 0) {
                text = ReferenceManager.renameLink(text, from, to);
            } else {
                link = ReferenceManager.renameLink(link, from, to);
                text = TextUtil.replaceString(text, from, to);
            }
            sb.append(sourceText.substring(start, matcher.start()));
            sb.append("[" + text);
            if (link.length() > 0) {
                sb.append("|" + link);
            }
            if (attr.length() > 0) {
                sb.append("|" + attr);
            }
            sb.append("]");
            start = matcher.end();
        }
        sb.append(sourceText.substring(start));
        return sb.toString();
    }

    @Override
    public void actionPerformed(WikiEvent event) {
        if (!(event instanceof WikiPageEvent)) {
            return;
        }
        WikiPath path = ((WikiPageEvent)event).getPath();
        if (!this.m_engine.pageExists(path.toString())) {
            return;
        }
        try {
            Session session = this.m_cm.getCurrentSession();
            JCRWikiPage page = this.m_cm.getPage(path);
            String uuid = page.getJCRNode().getUUID();
            switch (event.getType()) {
                case 201: {
                    String[] destinations;
                    String[] stringArray = destinations = this.getFromProperty(page.getJCRNode().getPath(), PROPERTY_REFERS_TO);
                    int n = destinations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String destination = stringArray[n2];
                        this.removeReferral(uuid, destination);
                        ++n2;
                    }
                    List<String> toUuids = this.extractLinks(page);
                    for (String destination : toUuids) {
                        this.addReferral(uuid, destination);
                        session.save();
                    }
                    String[] fromUuids = this.getFromProperty(page.getJCRNode().getPath(), PROPERTY_REFERRED_BY);
                    if (fromUuids.length == 0) {
                        this.addToProperty(NOT_REFERENCED, PROPERTY_NOT_REFERENCED, uuid);
                    }
                    session.save();
                    break;
                }
                case 220: {
                    String[] destinations;
                    Node node = page.getJCRNode();
                    String[] stringArray = destinations = this.getFromProperty(node.getPath(), PROPERTY_REFERS_TO);
                    int n = destinations.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String destination = stringArray[n3];
                        this.removeReferral(uuid, destination);
                        ++n3;
                    }
                    this.removeFromProperty(NOT_REFERENCED, PROPERTY_NOT_REFERENCED, uuid);
                    session.save();
                    break;
                }
                case 211: {
                    WikiPath oldPath = (WikiPath)((WikiPageEvent)event).getArgs()[0];
                    this.changeWikiReferences(page, oldPath.getPath());
                    session.save();
                }
            }
        }
        catch (PageNotFoundException e) {
            e.printStackTrace();
        }
        catch (ProviderException e) {
            e.printStackTrace();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    private void changeWikiReferences(JCRWikiPage page, String oldPath) throws ProviderException, RepositoryException {
        String[] destinations;
        String newPath = page.getPath().getPath();
        Node node = page.getJCRNode();
        String[] stringArray = destinations = this.getFromProperty(node.getPath(), PROPERTY_REFERRED_BY);
        int n = destinations.length;
        int n2 = 0;
        while (n2 < n) {
            String destination = stringArray[n2];
            try {
                WikiPath referrer = this.m_pathCache.getByUUID(destination);
                JCRWikiPage p = this.m_cm.getPage(referrer);
                String sourceText = p.getContentAsString();
                String newText = ReferenceManager.renameLinks(sourceText, oldPath, newPath);
                if (this.m_camelCase) {
                    newText = ReferenceManager.renameCamelCaseLinks(newText, oldPath, newPath);
                }
                if (!sourceText.equals(newText)) {
                    p.setAttribute("changenote", (Serializable)((Object)(String.valueOf(oldPath) + " ==> " + newPath)));
                    p.setContent(newText);
                }
            }
            catch (PageNotFoundException pageNotFoundException) {
                // empty catch block
            }
            ++n2;
        }
        if (!page.isAttachment()) {
            NodeIterator children = node.getNodes();
            while (children.hasNext()) {
                node = children.nextNode();
                WikiPathResolver cache = WikiPathResolver.getInstance(this.m_cm);
                WikiPath path = cache.getWikiPath(node.getPath(), WikiPathResolver.PathRoot.PAGES);
                page = new JCRWikiPage(this.m_engine, path, node);
                String oldChildPath = String.valueOf(oldPath) + "/" + path.getName();
                this.changeWikiReferences(page, oldChildPath);
            }
        }
    }

    public Set<String> findCreated() throws ProviderException {
        List<WikiPage> c = this.m_engine.getContentManager().getAllPages(null);
        TreeSet<String> results = new TreeSet<String>();
        for (WikiPage link : c) {
            results.add(link.getPath().toString());
        }
        return results;
    }

    public List<String> findRefersTo(String pageName) throws ProviderException {
        List<WikiPath> links = this.getRefersTo(WikiPath.valueOf(pageName));
        ArrayList<String> results = new ArrayList<String>();
        for (WikiPath link : links) {
            results.add(link.toString());
        }
        return results;
    }

    public List<WikiPath> findUncreated() throws RepositoryException {
        Session session = this.m_cm.getCurrentSession();
        QueryManager mgr = session.getWorkspace().getQueryManager();
        String uncreated = "/jcr:root" + WikiPathResolver.PathRoot.NOT_CREATED.path() + "/*";
        Query q = mgr.createQuery(uncreated, "xpath");
        QueryResult qr = q.execute();
        ArrayList<WikiPath> links = new ArrayList<WikiPath>();
        NodeIterator ni = qr.getNodes();
        while (ni.hasNext()) {
            Node nd = ni.nextNode();
            if (nd.getDepth() <= 3) continue;
            String uuid = nd.getUUID();
            links.add(this.m_pathCache.getByUUID(uuid));
        }
        return links;
    }

    public List<WikiPath> findUnreferenced() throws RepositoryException {
        String[] uuids = this.getFromProperty(NOT_REFERENCED, PROPERTY_NOT_REFERENCED);
        ArrayList<WikiPath> links = new ArrayList<WikiPath>();
        String[] stringArray = uuids;
        int n = uuids.length;
        int n2 = 0;
        while (n2 < n) {
            String uuid = stringArray[n2];
            links.add(this.m_pathCache.getByUUID(uuid));
            ++n2;
        }
        return links;
    }

    public List<WikiPath> getReferredBy(WikiPath destination) throws ProviderException {
        if (destination == null) {
            throw new IllegalArgumentException("Destination cannot be null!");
        }
        try {
            Node node = this.m_cm.getCurrentSession().getNodeByUUID(this.getSafeNodeByUUID(destination));
            String[] uuids = this.getFromProperty(node.getPath(), PROPERTY_REFERRED_BY);
            ArrayList<WikiPath> referrers = new ArrayList<WikiPath>();
            String[] stringArray = uuids;
            int n = uuids.length;
            int n2 = 0;
            while (n2 < n) {
                String uuid = stringArray[n2];
                referrers.add(this.m_pathCache.getByUUID(uuid));
                ++n2;
            }
            try {
                NodeIterator children = node.getNodes();
                while (children.hasNext()) {
                    Node child = children.nextNode();
                    if (!child.getPrimaryNodeType().isMixin()) continue;
                    String uuid = child.getUUID();
                    WikiPath childPath = this.m_pathCache.getByUUID(uuid);
                    referrers.addAll(this.getReferredBy(childPath));
                }
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
            return referrers;
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            throw new ProviderException("Could not set 'referredBy' property for " + destination.toString(), e);
        }
    }

    public List<WikiPath> getRefersTo(WikiPath source) throws ProviderException {
        if (source == null) {
            throw new IllegalArgumentException("Source cannot be null!");
        }
        try {
            String jcrPath = WikiPathResolver.getJCRPath(source, WikiPathResolver.PathRoot.PAGES);
            String[] uuids = this.getFromProperty(jcrPath, PROPERTY_REFERS_TO);
            ArrayList<WikiPath> refersTo = new ArrayList<WikiPath>();
            String[] stringArray = uuids;
            int n = uuids.length;
            int n2 = 0;
            while (n2 < n) {
                String uuid = stringArray[n2];
                refersTo.add(this.m_pathCache.getByUUID(uuid));
                ++n2;
            }
            return refersTo;
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            throw new ProviderException("Could not get 'refersTo' property for " + source.toString(), e);
        }
    }

    public void initialize(WikiEngine engine, Properties props) throws WikiException {
        this.m_engine = engine;
        this.m_cm = engine.getContentManager();
        this.m_pathCache = WikiPathResolver.getInstance(this.m_cm);
        this.m_matchEnglishPlurals = TextUtil.getBooleanProperty(engine.getWikiProperties(), "jspwiki.translatorReader.matchEnglishPlurals", this.m_matchEnglishPlurals);
        this.m_camelCase = TextUtil.getBooleanProperty(this.m_engine.getWikiProperties(), "jspwiki.translatorReader.camelCaseLinks", false);
        try {
            Node root = this.m_cm.getCurrentSession().getRootNode();
            if (!root.hasNode(REFERENCES_ROOT) || !root.hasNode(NOT_REFERENCED)) {
                this.rebuild();
            }
        }
        catch (RepositoryException e) {
            throw new ProviderException("Failed to initialize repository contents", e);
        }
        WikiEventManager.addWikiEventListener(engine.getContentManager(), this);
        this.m_cm.release();
    }

    public void rebuild() throws RepositoryException {
        ContentManager cm = this.m_engine.getContentManager();
        Session s = cm.getCurrentSession();
        if (s.getRootNode().hasNode(REFERENCES_ROOT)) {
            Node nd = s.getRootNode().getNode(REFERENCES_ROOT);
            nd.remove();
        }
        if (!s.getRootNode().hasNode(REFERENCES_ROOT)) {
            s.getRootNode().addNode(REFERENCES_ROOT);
        }
        if (!s.getRootNode().hasNode(NOT_REFERENCED)) {
            s.getRootNode().addNode(NOT_REFERENCED);
        }
        if (!s.getRootNode().hasNode(NOT_CREATED)) {
            s.getRootNode().addNode(NOT_CREATED);
        }
        s.save();
    }

    private WikiPath resolvePage(WikiPath path) throws ProviderException {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null!");
        }
        WikiPath finalPath = this.m_engine.getFinalPageName(path);
        return finalPath == null ? path : finalPath;
    }

    protected void addReferral(String from, String to) throws RepositoryException {
        Session session = this.m_cm.getCurrentSession();
        Node fromNode = session.getNodeByUUID(from);
        Node toNode = session.getNodeByUUID(to);
        this.addToProperty(fromNode.getPath(), PROPERTY_REFERS_TO, to);
        this.addToProperty(toNode.getPath(), PROPERTY_REFERRED_BY, from);
        this.removeFromProperty(NOT_REFERENCED, PROPERTY_NOT_REFERENCED, to);
    }

    protected void removeReferral(String from, String to) throws RepositoryException {
        Session session = this.m_cm.getCurrentSession();
        Node fromNode = session.getNodeByUUID(from);
        this.removeFromProperty(fromNode.getPath(), PROPERTY_REFERS_TO, to);
        try {
            Node toNode = session.getNodeByUUID(to);
            this.removeFromProperty(toNode.getPath(), PROPERTY_REFERRED_BY, from);
            String[] referrals = this.getFromProperty(toNode.getPath(), PROPERTY_REFERRED_BY);
            if (referrals.length == 0) {
                this.addToProperty(NOT_REFERENCED, PROPERTY_NOT_REFERENCED, to);
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void addToProperty(String jcrPath, String property, String newValue) throws RepositoryException {
        block12: {
            if (jcrPath == null || property == null || newValue == null) {
                throw new IllegalArgumentException("jcrNode, property and newValue cannot be null!");
            }
            session = this.m_cm.getCurrentSession();
            node = null;
            try {
                node = (Node)session.getItem(jcrPath);
                break block12;
            }
            catch (PathNotFoundException e) {
                components = StringUtils.split((String)jcrPath, (String)"/");
                node = session.getRootNode();
                i = 0;
                ** while (i < components.length)
            }
lbl-1000:
            // 1 sources

            {
                parent = node;
                try {
                    node = node.getNode(components[i]);
                }
                catch (PathNotFoundException e2) {
                    node = node.addNode(components[i]);
                    parent.save();
                }
                ++i;
                continue;
            }
        }
        newValues = new ArrayList<String>();
        try {
            p = node.getProperty(property);
            notFound = true;
            values = p.getValues();
            i = 0;
            while (i < values.length) {
                valueString = values[i].getString();
                if (valueString != null && valueString.length() > 0) {
                    newValues.add(valueString);
                    if (newValue.equals(valueString)) {
                        notFound = false;
                    }
                }
                ++i;
            }
            if (notFound) {
                newValues.add(newValue);
            }
            node.setProperty(property, newValues.toArray(new String[newValues.size()]));
        }
        catch (PathNotFoundException e) {
            node.setProperty(property, new String[]{newValue});
        }
        node.save();
    }

    protected List<String> extractLinks(JCRWikiPage page) throws PageNotFoundException, ProviderException, RepositoryException {
        String uuid;
        WikiPath finalPath;
        if (page == null) {
            throw new IllegalArgumentException("Path cannot be null!");
        }
        LinkCollector pageLinks = new LinkCollector();
        LinkCollector attachmentLinks = new LinkCollector();
        String pagedata = page.getContentAsString();
        WikiActionBeanContext context = this.m_engine.getWikiContextFactory().newViewContext(page);
        MarkupParser mp = this.m_engine.getRenderingManager().getParser(context, pagedata);
        mp.addLocalLinkHook(pageLinks);
        mp.addAttachmentLinkHook(attachmentLinks);
        mp.disableAccessRules();
        try {
            mp.parse();
        }
        catch (IOException e) {
            throw new ProviderException("Could not parse the document.", e);
        }
        ArrayList<String> links = new ArrayList<String>();
        for (String s : pageLinks.getLinks()) {
            finalPath = this.resolvePage(WikiPath.valueOf(s));
            uuid = this.getSafeNodeByUUID(finalPath);
            if (links.contains(uuid)) continue;
            links.add(uuid);
        }
        for (String s : attachmentLinks.getLinks()) {
            finalPath = this.resolvePage(WikiPath.valueOf(s));
            uuid = this.getSafeNodeByUUID(finalPath);
            if (links.contains(uuid)) continue;
            links.add(uuid);
        }
        return links;
    }

    /*
     * Unable to fully structure code
     */
    protected String getSafeNodeByUUID(WikiPath path) throws PathNotFoundException, RepositoryException {
        block7: {
            try {
                return WikiPathResolver.getInstance(this.m_cm).getUUID(path);
            }
            catch (ItemNotFoundException var2_2) {
                nd = null;
                jcrPath = WikiPathResolver.getJCRPath(path, WikiPathResolver.PathRoot.NOT_CREATED);
                session = this.m_cm.getCurrentSession();
                try {
                    nd = session.getRootNode().getNode(jcrPath);
                }
                catch (PathNotFoundException var5_6) {
                    // empty catch block
                }
                if (nd != null) break block7;
                currentNode = session.getRootNode().getNode("/wiki:references/wiki:notCreated");
                if (!currentNode.hasNode((space = path.getSpace()).toLowerCase())) {
                    nd = currentNode.addNode(space.toLowerCase());
                    nd.addMixin("mix:referenceable");
                    nd.setProperty("wiki:contentType", "text/x-jspwiki");
                    nd.setProperty("wiki:title", space);
                }
                currentNode = currentNode.getNode(space.toLowerCase());
                var11_10 = pathComponents = path.getPath().split("/");
                var10_11 = pathComponents.length;
                var9_12 = 0;
                ** while (var9_12 < var10_11)
            }
lbl-1000:
            // 1 sources

            {
                pathComponent = var11_10[var9_12];
                if (!currentNode.hasNode(pathComponent.toLowerCase())) {
                    nd = currentNode.addNode(pathComponent.toLowerCase());
                    nd.addMixin("mix:referenceable");
                    nd.setProperty("wiki:contentType", "text/x-jspwiki");
                    nd.setProperty("wiki:title", pathComponent);
                }
                currentNode = currentNode.getNode(pathComponent.toLowerCase());
                ++var9_12;
                continue;
            }
lbl37:
            // 1 sources

            session.save();
            nd = session.getRootNode().getNode(jcrPath);
        }
        cache = WikiPathResolver.getInstance(this.m_cm);
        cache.add(path, nd.getUUID());
        return nd.getUUID();
    }

    protected String[] getFromProperty(String jcrPath, String property) throws RepositoryException {
        if (jcrPath == null || property == null) {
            throw new IllegalArgumentException("jcrNode and property cannot be null!");
        }
        ContentManager cm = this.m_engine.getContentManager();
        Node node = null;
        try {
            node = (Node)cm.getCurrentSession().getItem(jcrPath);
        }
        catch (PathNotFoundException e) {
            return NO_VALUES;
        }
        String[] stringValues = NO_VALUES;
        try {
            Property p = node.getProperty(property);
            Value[] values = p.getValues();
            stringValues = new String[values.length];
            int i = 0;
            while (i < values.length) {
                stringValues[i] = values[i].getString();
                ++i;
            }
        }
        catch (PathNotFoundException e) {
            return NO_VALUES;
        }
        return stringValues;
    }

    protected void removeFromProperty(String jcrPath, String property, String value) throws RepositoryException {
        if (jcrPath == null || property == null || value == null) {
            throw new IllegalArgumentException("jcrNode, property and value cannot be null!");
        }
        ContentManager cm = this.m_engine.getContentManager();
        Node node = null;
        try {
            node = (Node)cm.getCurrentSession().getItem(jcrPath);
        }
        catch (PathNotFoundException e) {
            return;
        }
        ArrayList<String> newValues = new ArrayList<String>();
        try {
            Property p = node.getProperty(property);
            Value[] values = p.getValues();
            int i = 0;
            while (i < values.length) {
                String valueString = values[i].getString();
                if (valueString != null && valueString.length() > 0 && !value.equals(valueString)) {
                    newValues.add(valueString);
                }
                ++i;
            }
            p.remove();
            p.save();
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        if (newValues.size() > 0) {
            node.setProperty(property, newValues.toArray(new String[newValues.size()]));
        }
        node.save();
    }
}

