/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jcr.Credentials;
import javax.jcr.ItemExistsException;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.ValueFormatException;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.acl.Acl;
import org.apache.wiki.auth.acl.AclEntry;
import org.apache.wiki.auth.acl.AclEntryImpl;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.content.PageAlreadyExistsException;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.content.WikiPathResolver;
import org.apache.wiki.content.jcr.JCRWikiPage;
import org.apache.wiki.content.lock.PageLock;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.event.WikiPageRenameEvent;
import org.apache.wiki.event.WikiSecurityEvent;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.util.WikiBackgroundThread;
import org.apache.wiki.workflow.Outcome;
import org.apache.wiki.workflow.Task;
import org.apache.wiki.workflow.Workflow;
import org.priha.RepositoryManager;
import org.priha.util.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentManager
implements WikiEventListener {
    private static final String WIKI_VERSIONS = "wiki:versions";
    public static final String DEFAULT_SPACE = "Main";
    private static final String JCR_DEFAULT_SPACE = "pages/" + "Main".toLowerCase();
    private static final String JCR_PAGES_NODE = "pages";
    static final String JCR_PAGES_PATH = "/pages/";
    private static final long serialVersionUID = 2L;
    private static final String PRESAVE_PAGE_ACL = "page.acl";
    private static final String PRESAVE_PAGE_AUTHOR = "page.author";
    private static final String PRESAVE_PAGE_ATTRIBUTES = "page.attributes";
    private static final String PRESAVE_PAGE_LASTMODIFIED = "page.lastmodified";
    private static final String PRESAVE_PAGE_NAME = "page.name";
    private static final String PRESAVE_PAGE_TEXT = "page.text";
    public static final String PROP_LOCKEXPIRY = "jspwiki.lockExpiryTime";
    public static final String PRESAVE_TASK_MESSAGE_KEY = "task.preSaveWikiPage";
    public static final String SAVE_APPROVER = "workflow.saveWikiPage";
    public static final String SAVE_DECISION_MESSAGE_KEY = "decision.saveWikiPage";
    public static final String SAVE_REJECT_MESSAGE_KEY = "notification.saveWikiPage.reject";
    public static final String SAVE_TASK_MESSAGE_KEY = "task.saveWikiPage";
    public static final String FACT_PAGE_NAME = "fact.pageName";
    public static final String FACT_DIFF_TEXT = "fact.diffText";
    public static final String FACT_CURRENT_TEXT = "fact.currentText";
    public static final String FACT_PROPOSED_TEXT = "fact.proposedText";
    public static final String FACT_IS_AUTHENTICATED = "fact.isAuthenticated";
    public static final String JSPWIKI_CONTENT_TYPE = "text/x-jspwiki";
    private static final String NS_JSPWIKI = "http://www.jspwiki.org/ns#";
    private static final String DEFAULT_WORKSPACE = "jspwiki";
    private static final Serializable[] NO_ARGS = new Serializable[0];
    static Logger log = LoggerFactory.getLogger(ContentManager.class);
    protected HashMap<String, PageLock> m_pageLocks = new HashMap();
    private WikiEngine m_engine;
    private int m_expiryTime = 60;
    private LockReaper m_reaper = null;
    private Repository m_repository;
    private String m_workspaceName = "jspwiki";
    private JCRSessionManager m_sessionManager = new JCRSessionManager();
    private static final List<String> MANDATORY_PROPERTIES;

    static {
        ArrayList<String> props = new ArrayList<String>();
        props.add("wiki:title");
        props.add("wiki:contentType");
        props.add("wiki:referredBy");
        props.add("jcr:mixinTypes");
        props.add("jcr:primaryType");
        props.add("jcr:uuid");
        MANDATORY_PROPERTIES = Collections.unmodifiableList(props);
    }

    public ContentManager(WikiEngine engine) throws WikiException {
        this.m_engine = engine;
        this.m_expiryTime = TextUtil.parseIntParameter(engine.getWikiProperties().getProperty(PROP_LOCKEXPIRY), 60);
        try {
            InitialContext context = new InitialContext();
            Context environment = (Context)context.lookup("java:comp/env");
            this.m_repository = (Repository)environment.lookup("jcr/repository");
        }
        catch (NamingException e) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to locate the repository from JNDI", e, new Object[0]);
            } else {
                log.info("Unable to locate the repository from JNDI, attempting to locate from jspwiki.properties", new Object[0]);
            }
            String repositoryName = engine.getWikiProperties().getProperty("jspwiki.repository", "priha");
            log.info("Trying repository " + repositoryName, new Object[0]);
            if ("priha".equals(repositoryName)) {
                try {
                    Properties prihaProps = new Properties();
                    InputStream in = null;
                    boolean propsLoaded = false;
                    try {
                        ServletContext servletContext = engine.getServletContext();
                        System.err.println(servletContext);
                        if (servletContext != null) {
                            in = servletContext.getResourceAsStream("/WEB-INF/classes/priha.properties");
                        }
                        if (in != null) {
                            prihaProps.load(in);
                            this.m_repository = RepositoryManager.getRepository((Properties)prihaProps);
                            propsLoaded = true;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (!propsLoaded) {
                        this.m_repository = RepositoryManager.getRepository();
                    }
                }
                catch (ConfigurationException e1) {
                    throw new WikiException("Unable to initialize Priha as the main repository", e1);
                }
            }
            if ("jackrabbit".equals(repositoryName)) {
                try {
                    Class<?> jackrabbitRepo = Class.forName("org.apache.jackrabbit.core.TransientRepository");
                    this.m_repository = (Repository)jackrabbitRepo.newInstance();
                }
                catch (ClassNotFoundException e1) {
                    throw new WikiException("Jackrabbit libraries not found in the classpath", e1);
                }
                catch (InstantiationException e1) {
                    throw new WikiException("Jackrabbit could not be initialized", e1);
                }
                catch (IllegalAccessException e1) {
                    throw new WikiException("You do not have permission to access Jackrabbit", e1);
                }
            }
            throw new WikiException("Unable to initialize repository for repositorytype " + repositoryName);
        }
        try {
            this.initialize();
        }
        catch (RepositoryException e) {
            throw new WikiException("Failed to initialize the repository content", e);
        }
        log.info("ContentManager initialized!", new Object[0]);
    }

    private void initialize() throws LoginException, RepositoryException {
        Session session = this.m_sessionManager.getSession();
        session.getWorkspace().getNamespaceRegistry().registerNamespace("wiki", NS_JSPWIKI);
        Node root = session.getRootNode();
        if (!root.hasNode(JCR_PAGES_NODE)) {
            root.addNode(JCR_PAGES_NODE);
        }
        if (!this.hasSpace(session, JCR_DEFAULT_SPACE)) {
            this.createSpace(session, DEFAULT_SPACE);
        }
        session.save();
        WikiPathResolver.getInstance(this).clear();
    }

    private boolean hasSpace(Session s, String spaceName) throws RepositoryException {
        return s.itemExists(JCR_PAGES_PATH + spaceName.toLowerCase());
    }

    private void createSpace(Session s, String spaceName) throws RepositoryException {
        String path = "pages/" + spaceName.toLowerCase();
        if (!s.itemExists("/" + path)) {
            Node space = s.getRootNode().addNode(path);
            space.setProperty("wiki:title", spaceName);
        }
    }

    public void release() {
        this.m_sessionManager.releaseSession();
    }

    protected Session temporarySession() throws RepositoryException {
        return this.m_sessionManager.newSession();
    }

    private void checkin(String path, int currentVersion) throws RepositoryException {
        Session copierSession = this.m_sessionManager.newSession();
        try {
            String versionName;
            if (!copierSession.itemExists(path)) {
                return;
            }
            Node nd = (Node)copierSession.getItem(path);
            Node versions = !nd.hasNode(WIKI_VERSIONS) ? nd.addNode(WIKI_VERSIONS) : nd.getNode(WIKI_VERSIONS);
            if (versions.hasNode(versionName = Integer.toString(currentVersion))) {
                throw new ItemExistsException("Version already exists: " + currentVersion + ". This is a JSPWiki internal error, please report!");
            }
            Node newVersion = versions.addNode(versionName);
            newVersion.addMixin("mix:referenceable");
            this.copyProperties(nd, newVersion);
            copierSession.save();
        }
        finally {
            copierSession.logout();
        }
    }

    private void copyProperties(Node source, Node dest) throws RepositoryException, ValueFormatException, VersionException, LockException, ConstraintViolationException {
        PropertyIterator pi = source.getProperties();
        while (pi.hasNext()) {
            Property p = pi.nextProperty();
            int opp = p.getDefinition().getOnParentVersion();
            if (opp != 1 || p.getName().equals("jcr:uuid")) continue;
            if (p.getDefinition().isMultiple()) {
                dest.setProperty(p.getName(), p.getValues());
                continue;
            }
            dest.setProperty(p.getName(), p.getValue());
        }
    }

    public void save(WikiPage page) throws RepositoryException {
        Node nd;
        Session session = this.getCurrentSession();
        WikiPath path = page.getPath();
        boolean isNotCreatedPage = false;
        try {
            nd = session.getRootNode().getNode(WikiPathResolver.getJCRPath(path, WikiPathResolver.PathRoot.PAGES));
        }
        catch (PathNotFoundException e) {
            nd = session.getRootNode().getNode(WikiPathResolver.getJCRPath(path, WikiPathResolver.PathRoot.NOT_CREATED));
            isNotCreatedPage = true;
        }
        int version = page.getVersion();
        Calendar timestamp = Calendar.getInstance();
        if (this.isNew(nd)) {
            if (isNotCreatedPage) {
                String newPath = WikiPathResolver.getJCRPath(path, WikiPathResolver.PathRoot.PAGES);
                this.getCurrentSession().move(nd.getPath(), newPath);
                WikiPathResolver.getInstance(this).remove(path);
                nd = session.getRootNode().getNode(newPath);
            }
            nd.setProperty("wiki:version", 1L);
            nd.setProperty("wiki:created", timestamp);
            nd.setProperty("wiki:lastModified", timestamp);
            session.save();
            page = new JCRWikiPage(this.m_engine, path, nd);
        } else {
            this.checkin(WikiPathResolver.getJCRPath(path, WikiPathResolver.PathRoot.PAGES), version);
            nd.setProperty("wiki:version", (long)(version + 1));
            nd.setProperty("wiki:lastModified", timestamp);
            nd.save();
        }
        this.fireEvent(201, path, NO_ARGS);
    }

    public void shutdown() {
        String[] jcrRepoClassNames;
        this.release();
        if (this.m_repository == null) {
            return;
        }
        String[] stringArray = jcrRepoClassNames = new String[]{"org.apache.jackrabbit.core.JackrabbitRepository", "org.priha.core.RepositoryImpl"};
        int n = jcrRepoClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String jcrRepoClassName = stringArray[n2];
            try {
                Class<?> jcrRepoClass = Class.forName(jcrRepoClassName);
                if (this.m_repository.getClass().isAssignableFrom(jcrRepoClass)) {
                    log.info("Shutting down JCR repository...", new Object[0]);
                    Method m = jcrRepoClass.getMethod("shutdown", new Class[0]);
                    m.invoke((Object)this.m_repository, new Object[0]);
                }
                WikiPathResolver.getInstance(this).clear();
            }
            catch (ClassNotFoundException jcrRepoClass) {
            }
            catch (NoSuchMethodException e) {
                log.error("No shutdown() method for repository class " + this.m_repository.getClass().getName(), new Object[0]);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        this.m_repository = null;
    }

    public Session getCurrentSession() throws LoginException, RepositoryException {
        return this.m_sessionManager.getSession();
    }

    public List<WikiPage> getAllPages(String space) throws ProviderException {
        if (space != null) {
            space = space.toLowerCase();
        }
        ArrayList<WikiPage> results = new ArrayList<WikiPage>();
        try {
            Session session = this.m_sessionManager.getSession();
            QueryManager mgr = session.getWorkspace().getQueryManager();
            Query q = mgr.createQuery("/jcr:root/pages" + (space != null ? "/" + space : "/*") + "/*", "xpath");
            QueryResult qr = q.execute();
            NodeIterator ni = qr.getNodes();
            while (ni.hasNext()) {
                JCRWikiPage page;
                Node n = ni.nextNode();
                if (this.isSpaceRoot(n) || n.getPath().indexOf(58) != -1 || results.contains(page = new JCRWikiPage(this.getEngine(), n))) continue;
                results.add(page);
            }
        }
        catch (RepositoryException e) {
            throw new ProviderException("getAllPages()", e);
        }
        catch (WikiException e) {
            throw new ProviderException("getAllPages()", e);
        }
        return results;
    }

    public List<WikiPage> getAllPages(String space, Comparator<WikiPage> comparator) throws ProviderException {
        if (comparator == null) {
            throw new IllegalArgumentException("Comparator cannot be null.");
        }
        List<WikiPage> pages = this.getAllPages(space);
        Collections.sort(pages, comparator);
        return pages;
    }

    private boolean isSpaceRoot(Node nd) throws RepositoryException {
        return nd != null && nd.getPath().startsWith("/pages") && nd.getDepth() == 2;
    }

    private boolean isNew(Node nd) {
        try {
            return !nd.hasProperty("wiki:created");
        }
        catch (RepositoryException e) {
            log.error("Could not obtain attribute wiki:created from node " + nd.toString(), new Object[0]);
            e.printStackTrace();
            return true;
        }
    }

    public WikiEngine getEngine() {
        return this.m_engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageLock lockPage(WikiPage page, String user) {
        PageLock lock = null;
        if (this.m_reaper == null) {
            this.m_reaper = new LockReaper(this.m_engine);
            this.m_reaper.start();
        }
        HashMap<String, PageLock> hashMap = this.m_pageLocks;
        synchronized (hashMap) {
            this.fireEvent(10, page.getPath(), NO_ARGS);
            lock = this.m_pageLocks.get(page.getName());
            if (lock == null) {
                Date d = new Date();
                lock = new PageLock(page, user, d, new Date(d.getTime() + (long)(this.m_expiryTime * 60) * 1000L));
                this.m_pageLocks.put(page.getName(), lock);
                log.debug("Lock set : " + lock, new Object[0]);
            } else {
                log.debug("The lock  " + lock + " already exists", new Object[0]);
                lock = null;
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockPage(PageLock lock) {
        if (lock == null) {
            return;
        }
        HashMap<String, PageLock> hashMap = this.m_pageLocks;
        synchronized (hashMap) {
            this.m_pageLocks.remove(lock.getPath());
            log.debug("Released lock " + lock, new Object[0]);
        }
        this.fireEvent(11, lock.getPath(), NO_ARGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageLock getCurrentLock(WikiPage page) {
        PageLock lock = null;
        HashMap<String, PageLock> hashMap = this.m_pageLocks;
        synchronized (hashMap) {
            lock = this.m_pageLocks.get(page.getName());
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PageLock> getActiveLocks() {
        ArrayList<PageLock> result = new ArrayList<PageLock>();
        HashMap<String, PageLock> hashMap = this.m_pageLocks;
        synchronized (hashMap) {
            for (PageLock lock : this.m_pageLocks.values()) {
                result.add(lock);
            }
        }
        return result;
    }

    public List<WikiPage> getVersionHistory(WikiPath path) throws ProviderException, PageNotFoundException {
        ArrayList<WikiPage> result = new ArrayList<WikiPage>();
        try {
            Node base = this.getJCRNode(WikiPathResolver.getJCRPath(path, WikiPathResolver.PathRoot.PAGES));
            if (base.hasNode(WIKI_VERSIONS)) {
                Node versionHistory = base.getNode(WIKI_VERSIONS);
                NodeIterator ni = versionHistory.getNodes();
                while (ni.hasNext()) {
                    Node v = ni.nextNode();
                    result.add(new JCRWikiPage(this.m_engine, path, v));
                }
            }
            result.add(new JCRWikiPage(this.m_engine, base));
        }
        catch (RepositoryException e) {
            throw new ProviderException("Failure in trying to get version history", e);
        }
        return result;
    }

    public String getProviderDescription() {
        return this.m_repository.getDescriptor("jcr.repository.name");
    }

    public String getProvider() {
        return this.m_repository.getClass().getName();
    }

    public int getTotalPageCount(String space) throws ProviderException {
        return this.getAllPages(space).size();
    }

    public boolean pageExists(WikiPath wikiPath) throws ProviderException {
        if (wikiPath == null) {
            throw new ProviderException("Illegal page name");
        }
        String jcrPath = WikiPathResolver.getJCRPath(wikiPath, WikiPathResolver.PathRoot.PAGES);
        Node node = null;
        try {
            node = this.getJCRNode(jcrPath);
        }
        catch (PathNotFoundException e) {
            return false;
        }
        catch (RepositoryException e) {
            throw new ProviderException("Unable to check for page existence", e);
        }
        return !this.isNew(node);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean pageExists(WikiPath wikiPath, int version) throws ProviderException {
        if (wikiPath == null) {
            throw new ProviderException("Illegal page name");
        }
        String jcrPath = WikiPathResolver.getJCRPath(wikiPath, WikiPathResolver.PathRoot.PAGES);
        Node node = null;
        try {
            boolean noVersions;
            node = this.getJCRNode(jcrPath);
            if (node == null) {
                return false;
            }
            if (node.hasProperty("wiki:version")) {
                Property versionProperty = node.getProperty("wiki:version");
                try {
                    if ((long)version == versionProperty.getLong()) {
                        return true;
                    }
                }
                catch (ValueFormatException e) {
                    throw new ProviderException("Property wiki:version for node " + jcrPath + " cannot be " + " coerced to a Long. This is strange.");
                }
            }
            boolean bl = noVersions = !node.hasNode(WIKI_VERSIONS);
            if (version != -1 && !noVersions) {
                String v = Integer.toString(version);
                Node versions = node.getNode(WIKI_VERSIONS);
                if (!versions.hasNode(v)) return false;
                if (this.isNew(versions.getNode(v))) return false;
                return true;
            }
            if (!this.isNew(node)) return true;
            return false;
        }
        catch (PathNotFoundException e) {
            return false;
        }
        catch (RepositoryException e) {
            throw new ProviderException("Unable to check for page existence", e);
        }
    }

    public boolean deleteVersion(WikiPage page) throws ProviderException {
        JCRWikiPage jcrPage = (JCRWikiPage)page;
        try {
            if (jcrPage.isLatest()) {
                try {
                    JCRWikiPage pred = jcrPage.getPredecessor();
                    this.restore(pred);
                }
                catch (PageNotFoundException e) {
                    this.deletePage(page);
                }
                catch (PageAlreadyExistsException e) {
                    throw new ProviderException("Page which was already removed still exists?", e);
                }
            } else {
                jcrPage.getJCRNode().remove();
                jcrPage.getJCRNode().getParent().save();
            }
            this.fireEvent(201, page.getPath(), NO_ARGS);
            return true;
        }
        catch (PathNotFoundException e) {
            return false;
        }
        catch (RepositoryException e) {
            throw new ProviderException("Unable to delete a page", e);
        }
    }

    private void restore(JCRWikiPage page) throws ProviderException, RepositoryException, PageAlreadyExistsException {
        JCRWikiPage original = page.getCurrentVersion();
        Node origNode = original.getJCRNode();
        PropertyIterator pi = origNode.getProperties();
        while (pi.hasNext()) {
            Property p = pi.nextProperty();
            if (p.getDefinition().isProtected() || p.getName().equals("jcr:uuid")) continue;
            p.remove();
        }
        origNode.save();
        this.copyProperties(page.getJCRNode(), origNode);
        origNode.save();
    }

    public boolean deletePage(WikiPage page) throws ProviderException {
        WikiPath path = page.getPath();
        this.fireEvent(220, path, NO_ARGS);
        try {
            Node nd = ((JCRWikiPage)page).getJCRNode();
            List<WikiPath> referrers = page.getReferredBy();
            int outsideReferrers = referrers.size();
            for (WikiPath referrer : referrers) {
                if (!referrer.equals(path)) continue;
                --outsideReferrers;
            }
            if (outsideReferrers > 0) {
                String uncreatedPath = WikiPathResolver.getJCRPath(path, WikiPathResolver.PathRoot.NOT_CREATED);
                this.getCurrentSession().move(nd.getPath(), uncreatedPath);
                PropertyIterator props = nd.getProperties();
                while (props.hasNext()) {
                    Property prop = props.nextProperty();
                    if (MANDATORY_PROPERTIES.contains(prop.getName())) continue;
                    prop.remove();
                }
                NodeIterator nodes = nd.getNodes();
                while (nodes.hasNext()) {
                    nodes.nextNode().remove();
                }
                this.getCurrentSession().save();
            } else {
                nd.remove();
                nd.getParent().save();
            }
            WikiPathResolver.getInstance(this).remove(path);
            this.fireEvent(221, page.getPath(), NO_ARGS);
            return true;
        }
        catch (PathNotFoundException e) {
            return false;
        }
        catch (RepositoryException e) {
            throw new ProviderException("Deletion of pages failed: " + e.getMessage(), e);
        }
    }

    public String renamePage(WikiContext context, String renameFrom, String renameTo) throws WikiException {
        WikiPage page;
        if (renameFrom == null || renameFrom.length() == 0) {
            throw new WikiException("From name may not be null or empty");
        }
        if (renameTo == null || renameTo.length() == 0) {
            throw new WikiException("To name may not be null or empty");
        }
        String renameToClean = MarkupParser.cleanLink(renameTo.trim());
        if (renameToClean.equals(renameFrom)) {
            throw new WikiException("You cannot rename the page to itself");
        }
        WikiEngine engine = context.getEngine();
        WikiPath fromPath = WikiPath.valueOf(renameFrom);
        WikiPath toPath = WikiPath.valueOf(renameToClean);
        try {
            this.getCurrentSession().move(WikiPathResolver.getJCRPath(fromPath, WikiPathResolver.PathRoot.PAGES), WikiPathResolver.getJCRPath(toPath, WikiPathResolver.PathRoot.PAGES));
            this.getCurrentSession().save();
            WikiPathResolver.getInstance(this).remove(fromPath);
            WikiPathResolver.getInstance(this).remove(toPath);
        }
        catch (RepositoryException e) {
            throw new WikiException("Could not rename page. Reason: " + e.getMessage(), e);
        }
        try {
            page = engine.getPage(toPath);
            if (engine.pageExists(fromPath.toString())) {
                throw new InternalWikiException("Rename failed: fromPage " + fromPath + " still exists after move!");
            }
        }
        catch (PageNotFoundException e) {
            throw new InternalWikiException("Rename failed: toPage " + toPath + " not found after move!");
        }
        page.setAttribute("changenote", (Serializable)((Object)(String.valueOf(fromPath.toString()) + " ==> " + toPath.toString())));
        page.setAuthor(context.getCurrentUser().getName());
        page.setAttribute("wiki:title", (Serializable)((Object)renameToClean));
        this.fireEvent(211, toPath, fromPath);
        page.save();
        WikiEventManager.fireEvent(this, new WikiPageRenameEvent((Object)this, fromPath, toPath));
        return renameToClean;
    }

    protected final void fireEvent(int type, WikiPath pagename, Serializable ... args) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiPageEvent((Object)this.m_engine, type, pagename, args));
        }
    }

    public JCRWikiPage addPage(WikiPath path, String contentType) throws PageAlreadyExistsException, ProviderException {
        this.checkValidContentType(contentType);
        Node nd = null;
        try {
            String jcrPath;
            Session session = this.m_sessionManager.getSession();
            try {
                jcrPath = WikiPathResolver.getJCRPath(path, WikiPathResolver.PathRoot.NOT_CREATED);
                nd = session.getRootNode().getNode(jcrPath);
            }
            catch (PathNotFoundException e) {
                try {
                    String jcrPath2 = WikiPathResolver.getJCRPath(path, WikiPathResolver.PathRoot.PAGES);
                    nd = session.getRootNode().getNode(jcrPath2);
                    if (!this.isNew(nd)) {
                        nd = null;
                    }
                }
                catch (PathNotFoundException pathNotFoundException) {
                    // empty catch block
                }
            }
            if (nd == null) {
                jcrPath = WikiPathResolver.getJCRPath(path, WikiPathResolver.PathRoot.PAGES);
                nd = session.getRootNode().addNode(jcrPath);
                nd.addMixin("mix:referenceable");
                nd.setProperty("wiki:contentType", contentType);
            }
            nd.setProperty("wiki:title", path.getName());
            WikiPathResolver.getInstance(this).remove(path);
            JCRWikiPage page = new JCRWikiPage(this.m_engine, path, nd);
            return page;
        }
        catch (RepositoryException e) {
            throw new ProviderException("Unable to add a page", e);
        }
    }

    private void checkValidContentType(String type) throws ProviderException {
        if (type == null) {
            throw new ProviderException("null content type");
        }
        if (type.indexOf(47) == -1) {
            throw new ProviderException("Not RFC compliant type");
        }
    }

    public JCRWikiPage getPage(WikiPath path) throws ProviderException, PageNotFoundException {
        if (path == null) {
            throw new PageNotFoundException("null WikiPath given to getPage()");
        }
        try {
            Session session = this.m_sessionManager.getSession();
            String jcrPath = WikiPathResolver.getJCRPath(path, WikiPathResolver.PathRoot.PAGES);
            JCRWikiPage page = new JCRWikiPage(this.m_engine, path, (Node)session.getItem(jcrPath));
            return page;
        }
        catch (PathNotFoundException e) {
            throw new PageNotFoundException(path);
        }
        catch (RepositoryException e) {
            throw new ProviderException("Unable to get a page", e);
        }
    }

    public JCRWikiPage getPage(WikiPath path, int version) throws ProviderException, PageNotFoundException {
        try {
            Session session = this.m_sessionManager.getSession();
            Node original = session.getRootNode().getNode(WikiPathResolver.getJCRPath(path, WikiPathResolver.PathRoot.PAGES));
            Property p = original.getProperty("wiki:version");
            if (p.getLong() == (long)version || version == -1) {
                return new JCRWikiPage(this.m_engine, original);
            }
            Node versionHistory = original.getNode(WIKI_VERSIONS);
            Node v = versionHistory.getNode(Integer.toString(version));
            return new JCRWikiPage(this.m_engine, path, v);
        }
        catch (PathNotFoundException e) {
            throw new PageNotFoundException("No such version " + version + " exists for path " + path);
        }
        catch (RepositoryException e) {
            throw new ProviderException("Repository failed", e);
        }
    }

    @Override
    public void actionPerformed(WikiEvent event) {
        if (!(event instanceof WikiSecurityEvent)) {
            return;
        }
        WikiSecurityEvent se = (WikiSecurityEvent)event;
        if (se.getType() == 54) {
            UserProfile[] profiles = (UserProfile[])se.getTarget();
            Principal[] oldPrincipals = new Principal[]{new WikiPrincipal(profiles[0].getLoginName()), new WikiPrincipal(profiles[0].getFullname()), new WikiPrincipal(profiles[0].getWikiName())};
            WikiPrincipal newPrincipal = new WikiPrincipal(profiles[1].getFullname());
            try {
                int pagesChanged = 0;
                List<WikiPage> pages = this.getAllPages(null);
                for (WikiPage page : pages) {
                    Acl acl = this.changeAcl(page, oldPrincipals, newPrincipal);
                    if (acl == null) continue;
                    try {
                        this.m_engine.getAclManager().setPermissions(page, acl);
                    }
                    catch (WikiSecurityException e) {
                        log.error("Could not change page ACL for page " + page.getName() + ": " + e.getMessage(), new Object[0]);
                    }
                    ++pagesChanged;
                }
                log.info("Profile name change for '" + newPrincipal.toString() + "' caused " + pagesChanged + " page ACLs to change also.", new Object[0]);
            }
            catch (WikiException e) {
                log.error("Could not change user name in Page ACLs because of Provider error:" + e.getMessage(), new Object[0]);
            }
        }
    }

    protected Acl changeAcl(WikiPage page, Principal[] oldPrincipals, Principal newPrincipal) {
        Acl acl = page.getAcl();
        boolean aclChanged = false;
        if (acl != null) {
            Enumeration<AclEntry> entries = acl.entries();
            ArrayList<AclEntryImpl> entriesToAdd = new ArrayList<AclEntryImpl>();
            ArrayList<AclEntry> entriesToRemove = new ArrayList<AclEntry>();
            while (entries.hasMoreElements()) {
                AclEntry entry = entries.nextElement();
                if (!ArrayUtils.contains((Object[])oldPrincipals, (Object)entry.getPrincipal())) continue;
                AclEntryImpl aclEntryImpl = new AclEntryImpl();
                aclEntryImpl.setPrincipal(newPrincipal);
                Enumeration<Permission> permissions = entry.permissions();
                while (permissions.hasMoreElements()) {
                    Permission permission = permissions.nextElement();
                    aclEntryImpl.addPermission(permission);
                }
                aclChanged = true;
                entriesToRemove.add(entry);
                entriesToAdd.add(aclEntryImpl);
            }
            for (AclEntry aclEntry : entriesToRemove) {
                acl.removeEntry(aclEntry);
            }
            for (AclEntry aclEntry : entriesToAdd) {
                acl.addEntry(aclEntry);
            }
        }
        return aclChanged ? acl : null;
    }

    public Node getJCRNode(String jcrPath) throws RepositoryException {
        return (Node)this.m_sessionManager.getSession().getItem(jcrPath);
    }

    public void importXML(String xmlfile) throws LoginException, RepositoryException, FileNotFoundException, IOException, PageAlreadyExistsException, ProviderException {
        String wikiSpace;
        Session s = this.getCurrentSession();
        FileReader fr = new FileReader(xmlfile);
        try {
            char[] guessBuffer = new char[1024];
            fr.read(guessBuffer);
            String g = new String(guessBuffer);
            int a = g.indexOf("sv:name=");
            if (a < 0) {
                throw new IOException("Invalid format " + g);
            }
            int b = g.indexOf("'", (a += "sv:name=".length()) + 2);
            int c = g.indexOf("\"", a + 2);
            if ((b = b > 0 && c > 0 ? Math.min(c, b) : Math.max(c, b)) < 0) {
                throw new IOException("Invalid format " + g);
            }
            wikiSpace = g.substring(a + 1, b);
            System.out.println("SPACE = " + wikiSpace);
        }
        finally {
            fr.close();
        }
        String jcrPath = JCR_PAGES_PATH + wikiSpace;
        if (s.itemExists(jcrPath)) {
            log.warn("Space '" + wikiSpace + "' exists; removing it first (no merges)...", new Object[0]);
            List<WikiPage> allPages = this.getAllPages(wikiSpace);
            for (WikiPage p : allPages) {
                this.deletePage(p);
            }
            s.getItem(jcrPath).remove();
        }
        s.save();
        Workspace ws = s.getWorkspace();
        log.info("Importing content from %s to %s", xmlfile, JCR_PAGES_PATH);
        ws.importXML(JCR_PAGES_PATH, (InputStream)new FileInputStream(xmlfile), 3);
    }

    protected class JCRSessionManager {
        private final ThreadLocal<Session> m_currentSession = new ThreadLocal();
        private final Owner m_trueOwner = new Owner(true);
        private final Owner m_fakeOwner = new Owner(false);

        protected JCRSessionManager() {
        }

        public Object createSession() throws LoginException, RepositoryException {
            Session session = this.m_currentSession.get();
            if (session == null) {
                session = this.newSession();
                this.m_currentSession.set(session);
                return this.m_trueOwner;
            }
            return this.m_fakeOwner;
        }

        public Session newSession() throws LoginException, RepositoryException {
            Session session = ContentManager.this.m_repository.login((Credentials)new SimpleCredentials("jspwikiUser", "passwordDoesNotMatter".toCharArray()), ContentManager.this.m_workspaceName);
            return session;
        }

        public void destroySession(Object ownership) {
            if (ownership != null && ((Owner)ownership).m_identity) {
                this.releaseSession();
            }
        }

        public void releaseSession() {
            Session session = this.m_currentSession.get();
            if (session != null) {
                session.logout();
                this.m_currentSession.set(null);
            }
        }

        public Session getSession() throws LoginException, RepositoryException {
            Session s = this.m_currentSession.get();
            if (s == null) {
                this.createSession();
                s = this.m_currentSession.get();
            }
            return s;
        }
    }

    private class LockReaper
    extends WikiBackgroundThread {
        public LockReaper(WikiEngine engine) {
            super(engine, 60);
            this.setName("Lock Reaper");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void backgroundTask() throws Exception {
            HashMap<String, PageLock> hashMap = ContentManager.this.m_pageLocks;
            synchronized (hashMap) {
                Collection<PageLock> entries = ContentManager.this.m_pageLocks.values();
                Date now = new Date();
                Iterator<PageLock> i = entries.iterator();
                while (i.hasNext()) {
                    PageLock p = i.next();
                    if (!now.after(p.getExpiryTime())) continue;
                    i.remove();
                    log.info("Reaped lock: " + p, new Object[0]);
                }
            }
        }
    }

    private static class Owner {
        boolean m_identity = false;

        public Owner(boolean identity) {
            this.m_identity = identity;
        }
    }

    public static class PreSaveWikiPageTask
    extends Task {
        private static final long serialVersionUID = 6304715570092804615L;
        private final WikiContext m_context;
        private final String m_proposedText;

        public PreSaveWikiPageTask(WikiContext context, String proposedText) {
            super(ContentManager.PRESAVE_TASK_MESSAGE_KEY);
            this.m_context = context;
            this.m_proposedText = proposedText;
        }

        public Outcome execute() throws WikiException {
            WikiEngine engine = this.m_context.getEngine();
            Workflow workflow = this.getWorkflow();
            WikiPage page = this.m_context.getPage();
            String author = null;
            if (page.getAuthor() != null) {
                author = page.getAuthor();
            }
            if (author == null) {
                author = this.m_context.getCurrentUser().getName();
            }
            String saveText = engine.getFilterManager().doPreSaveFiltering(this.m_context, this.m_proposedText);
            workflow.setAttribute(ContentManager.PRESAVE_PAGE_ACL, page.getAcl());
            workflow.setAttribute(ContentManager.PRESAVE_PAGE_AUTHOR, (Serializable)((Object)author));
            workflow.setAttribute(ContentManager.PRESAVE_PAGE_ATTRIBUTES, (Serializable)((Object)page.getAttributes()));
            workflow.setAttribute(ContentManager.PRESAVE_PAGE_LASTMODIFIED, new Date());
            workflow.setAttribute(ContentManager.PRESAVE_PAGE_NAME, page.getPath());
            workflow.setAttribute(ContentManager.PRESAVE_PAGE_TEXT, (Serializable)((Object)saveText));
            return Outcome.STEP_COMPLETE;
        }
    }

    public static class SaveWikiPageTask
    extends Task {
        private static final long serialVersionUID = 3190559953484411420L;

        public SaveWikiPageTask() {
            super(ContentManager.SAVE_TASK_MESSAGE_KEY);
        }

        public Outcome execute() throws WikiException {
            JCRWikiPage page;
            Workflow workflow = this.getWorkflow();
            WikiEngine engine = workflow.getWorkflowManager().getEngine();
            WikiPath path = (WikiPath)workflow.getAttribute(ContentManager.PRESAVE_PAGE_NAME);
            try {
                page = engine.getContentManager().getPage(path);
            }
            catch (PageNotFoundException e) {
                try {
                    page = engine.getContentManager().addPage(path, ContentManager.JSPWIKI_CONTENT_TYPE);
                }
                catch (PageAlreadyExistsException e1) {
                    throw new InternalWikiException("We were just told the page didn't exist. And now it does? Explain, please.");
                }
            }
            Acl acl = (Acl)workflow.getAttribute(ContentManager.PRESAVE_PAGE_ACL);
            String author = (String)((Object)workflow.getAttribute(ContentManager.PRESAVE_PAGE_AUTHOR));
            Map attributes = (Map)((Object)workflow.getAttribute(ContentManager.PRESAVE_PAGE_ATTRIBUTES));
            Date date = (Date)workflow.getAttribute(ContentManager.PRESAVE_PAGE_LASTMODIFIED);
            String text = (String)((Object)workflow.getAttribute(ContentManager.PRESAVE_PAGE_TEXT));
            page.setAcl(acl);
            page.setAuthor(author);
            if (attributes != null) {
                for (Map.Entry attribute : attributes.entrySet()) {
                    page.setAttribute((String)attribute.getKey(), (Serializable)attribute.getValue());
                }
            }
            page.setLastModified(date);
            page.setContent(text);
            page.save();
            try {
                WikiActionBeanContext context = engine.getWikiContextFactory().newViewContext(page);
                engine.getPage(page.getName());
                engine.textToHTML(context, text);
                engine.getRenderingManager().getParser(context, text).parse();
                engine.getFilterManager().doPostSaveFiltering(context, text);
            }
            catch (PageNotFoundException e) {
                e.printStackTrace();
                throw new WikiException(e.getMessage(), e);
            }
            catch (IOException ioe) {
                log.error("unable to parse", ioe);
                throw new WikiException(ioe.getMessage(), ioe);
            }
            return Outcome.STEP_COMPLETE;
        }
    }
}

