/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.user;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.security.Principal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.wiki.NoRequiredPropertyException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.user.AbstractUserDatabase;
import org.apache.wiki.auth.user.DuplicateUserException;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.util.Serializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XMLUserDatabase
extends AbstractUserDatabase {
    public static final String PROP_USERDATABASE = "jspwiki.xmlUserDatabaseFile";
    private static final String DEFAULT_USERDATABASE = "userdatabase.xml";
    private static final String ATTRIBUTES_TAG = "attributes";
    private static final String CREATED = "created";
    private static final String EMAIL = "email";
    private static final String FULL_NAME = "fullName";
    private static final String LOGIN_NAME = "loginName";
    private static final String LAST_MODIFIED = "lastModified";
    private static final String LOCK_EXPIRY = "lockExpiry";
    private static final String PASSWORD = "password";
    private static final String UID = "uid";
    private static final String USER_TAG = "user";
    private static final String WIKI_NAME = "wikiName";
    private Document c_dom = null;
    private DateFormat c_defaultFormat = DateFormat.getDateTimeInstance();
    private DateFormat c_format = new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss:SSS z");
    private File c_file = null;
    private long c_lastCheck = 0L;
    private long c_lastModified = 0L;

    public synchronized void deleteByLoginName(String loginName) throws NoSuchPrincipalException, WikiSecurityException {
        if (this.c_dom == null) {
            throw new WikiSecurityException("FATAL: database does not exist");
        }
        NodeList users = this.c_dom.getDocumentElement().getElementsByTagName(USER_TAG);
        int i = 0;
        while (i < users.getLength()) {
            Element user = (Element)users.item(i);
            if (user.getAttribute(LOGIN_NAME).equals(loginName)) {
                this.c_dom.getDocumentElement().removeChild(user);
                this.saveDOM();
                return;
            }
            ++i;
        }
        throw new NoSuchPrincipalException("Not in database: " + loginName);
    }

    public UserProfile findByEmail(String index) throws NoSuchPrincipalException {
        UserProfile profile = this.findByAttribute(EMAIL, index);
        if (profile != null) {
            return profile;
        }
        throw new NoSuchPrincipalException("Not in database: " + index);
    }

    public UserProfile findByFullName(String index) throws NoSuchPrincipalException {
        UserProfile profile = this.findByAttribute(FULL_NAME, index);
        if (profile != null) {
            return profile;
        }
        throw new NoSuchPrincipalException("Not in database: " + index);
    }

    public UserProfile findByLoginName(String index) throws NoSuchPrincipalException {
        UserProfile profile = this.findByAttribute(LOGIN_NAME, index);
        if (profile != null) {
            return profile;
        }
        throw new NoSuchPrincipalException("Not in database: " + index);
    }

    public UserProfile findByUid(String uid) throws NoSuchPrincipalException {
        UserProfile profile = this.findByAttribute(UID, uid);
        if (profile != null) {
            return profile;
        }
        throw new NoSuchPrincipalException("Not in database: " + uid);
    }

    public UserProfile findByWikiName(String index) throws NoSuchPrincipalException {
        UserProfile profile = this.findByAttribute(WIKI_NAME, index);
        if (profile != null) {
            return profile;
        }
        throw new NoSuchPrincipalException("Not in database: " + index);
    }

    public Principal[] getWikiNames() throws WikiSecurityException {
        if (this.c_dom == null) {
            throw new IllegalStateException("FATAL: database does not exist");
        }
        TreeSet<WikiPrincipal> principals = new TreeSet<WikiPrincipal>();
        NodeList users = this.c_dom.getElementsByTagName(USER_TAG);
        int i = 0;
        while (i < users.getLength()) {
            Element user = (Element)users.item(i);
            String wikiName = user.getAttribute(WIKI_NAME);
            if (wikiName == null) {
                log.warn("Detected null wiki name in XMLUserDataBase. Check your user database.", new Object[0]);
            } else {
                WikiPrincipal principal = new WikiPrincipal(wikiName, WIKI_NAME);
                principals.add(principal);
            }
            ++i;
        }
        return principals.toArray(new Principal[principals.size()]);
    }

    public void initialize(WikiEngine engine, Properties props) throws NoRequiredPropertyException {
        File defaultFile = null;
        if (engine.getRootPath() == null) {
            log.warn("Cannot identify JSPWiki root path", new Object[0]);
            defaultFile = new File("WEB-INF/userdatabase.xml").getAbsoluteFile();
        } else {
            defaultFile = new File(String.valueOf(engine.getRootPath()) + "/WEB-INF/" + DEFAULT_USERDATABASE);
        }
        String file = props.getProperty(PROP_USERDATABASE);
        if (file == null) {
            log.warn("XML user database property jspwiki.xmlUserDatabaseFile not found; trying " + defaultFile, new Object[0]);
            this.c_file = defaultFile;
        } else {
            this.c_file = new File(file);
        }
        log.info("XML user database at " + this.c_file.getAbsolutePath(), new Object[0]);
        this.buildDOM();
        this.sanitizeDOM();
    }

    private void buildDOM() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setExpandEntityReferences(false);
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(false);
        try {
            this.c_dom = factory.newDocumentBuilder().parse(this.c_file);
            log.debug("Database successfully initialized", new Object[0]);
            this.c_lastModified = this.c_file.lastModified();
            this.c_lastCheck = System.currentTimeMillis();
        }
        catch (ParserConfigurationException e) {
            log.error("Configuration error: " + e.getMessage(), new Object[0]);
        }
        catch (SAXException e) {
            log.error("SAX error: " + e.getMessage(), new Object[0]);
        }
        catch (FileNotFoundException e) {
            log.info("User database not found; creating from scratch...", new Object[0]);
        }
        catch (IOException e) {
            log.error("IO error: " + e.getMessage(), new Object[0]);
        }
        if (this.c_dom == null) {
            try {
                this.c_dom = factory.newDocumentBuilder().newDocument();
                this.c_dom.appendChild(this.c_dom.createElement("users"));
            }
            catch (ParserConfigurationException e) {
                log.error("Could not create in-memory DOM", new Object[0]);
            }
        }
    }

    private void saveDOM() throws WikiSecurityException {
        if (this.c_dom == null) {
            log.error("User database doesn't exist in memory.", new Object[0]);
        }
        File newFile = new File(String.valueOf(this.c_file.getAbsolutePath()) + ".new");
        try {
            BufferedWriter io = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), "UTF-8"));
            io.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            io.write("<users>\n");
            Element root = this.c_dom.getDocumentElement();
            NodeList nodes = root.getElementsByTagName(USER_TAG);
            int i = 0;
            while (i < nodes.getLength()) {
                Element user = (Element)nodes.item(i);
                io.write("    <user ");
                io.write(UID);
                io.write("=\"" + user.getAttribute(UID) + "\" ");
                io.write(LOGIN_NAME);
                io.write("=\"" + user.getAttribute(LOGIN_NAME) + "\" ");
                io.write(WIKI_NAME);
                io.write("=\"" + user.getAttribute(WIKI_NAME) + "\" ");
                io.write(FULL_NAME);
                io.write("=\"" + user.getAttribute(FULL_NAME) + "\" ");
                io.write(EMAIL);
                io.write("=\"" + user.getAttribute(EMAIL) + "\" ");
                io.write(PASSWORD);
                io.write("=\"" + user.getAttribute(PASSWORD) + "\" ");
                io.write(CREATED);
                io.write("=\"" + user.getAttribute(CREATED) + "\" ");
                io.write(LAST_MODIFIED);
                io.write("=\"" + user.getAttribute(LAST_MODIFIED) + "\" ");
                io.write(LOCK_EXPIRY);
                io.write("=\"" + user.getAttribute(LOCK_EXPIRY) + "\" ");
                io.write(">");
                NodeList attributes = user.getElementsByTagName(ATTRIBUTES_TAG);
                int j = 0;
                while (j < attributes.getLength()) {
                    Element attribute = (Element)attributes.item(j);
                    String value = this.extractText(attribute);
                    io.write("\n        <attributes>");
                    io.write(value);
                    io.write("</attributes>");
                    ++j;
                }
                io.write("\n    </user>\n");
                ++i;
            }
            io.write("</users>");
            io.close();
        }
        catch (IOException e) {
            throw new WikiSecurityException(e.getLocalizedMessage(), e);
        }
        File backup = new File(String.valueOf(this.c_file.getAbsolutePath()) + ".old");
        if (backup.exists() && !backup.delete()) {
            log.error("Could not delete old user database backup: " + backup, new Object[0]);
        }
        if (!this.c_file.renameTo(backup)) {
            log.error("Could not create user database backup: " + backup, new Object[0]);
        }
        if (!newFile.renameTo(this.c_file)) {
            log.error("Could not save database: " + backup + " restoring backup.", new Object[0]);
            if (!backup.renameTo(this.c_file)) {
                log.error("Restore failed. Check the file permissions.", new Object[0]);
            }
            log.error("Could not save database: " + this.c_file + ". Check the file permissions", new Object[0]);
        }
    }

    private void checkForRefresh() {
        long lastModified;
        long time = System.currentTimeMillis();
        if (time - this.c_lastCheck > 60000L && (lastModified = this.c_file.lastModified()) > this.c_lastModified) {
            this.buildDOM();
        }
    }

    public synchronized void rename(String loginName, String newName) throws NoSuchPrincipalException, DuplicateUserException, WikiSecurityException {
        if (this.c_dom == null) {
            log.error("Could not rename profile '" + loginName + "'; database does not exist", new Object[0]);
            throw new IllegalStateException("FATAL: database does not exist");
        }
        this.checkForRefresh();
        UserProfile profile = this.findByLoginName(loginName);
        try {
            UserProfile otherProfile = this.findByLoginName(newName);
            if (otherProfile != null) {
                throw new DuplicateUserException("Cannot rename: the login name '" + newName + "' is already taken.");
            }
        }
        catch (NoSuchPrincipalException otherProfile) {
            // empty catch block
        }
        NodeList users = this.c_dom.getElementsByTagName(USER_TAG);
        int i = 0;
        while (i < users.getLength()) {
            Element user = (Element)users.item(i);
            if (user.getAttribute(LOGIN_NAME).equals(loginName)) {
                Date modDate = new Date(System.currentTimeMillis());
                this.setAttribute(user, LOGIN_NAME, newName);
                this.setAttribute(user, LAST_MODIFIED, this.c_format.format(modDate));
                profile.setLoginName(newName);
                profile.setLastModified(modDate);
                break;
            }
            ++i;
        }
        this.saveDOM();
    }

    public synchronized void save(UserProfile profile) throws WikiSecurityException {
        String oldPassword;
        if (this.c_dom == null) {
            log.error("Could not save profile " + profile + " database does not exist", new Object[0]);
            throw new IllegalStateException("FATAL: database does not exist");
        }
        this.checkForRefresh();
        String index = profile.getLoginName();
        NodeList users = this.c_dom.getElementsByTagName(USER_TAG);
        Element user = null;
        int i = 0;
        while (i < users.getLength()) {
            Element currentUser = (Element)users.item(i);
            if (currentUser.getAttribute(LOGIN_NAME).equals(index)) {
                user = currentUser;
                break;
            }
            ++i;
        }
        boolean isNew = false;
        Date modDate = new Date(System.currentTimeMillis());
        if (user == null) {
            profile.setCreated(modDate);
            log.info("Creating new user " + index, new Object[0]);
            user = this.c_dom.createElement(USER_TAG);
            this.c_dom.getDocumentElement().appendChild(user);
            this.setAttribute(user, CREATED, this.c_format.format(profile.getCreated()));
            isNew = true;
        } else {
            NodeList attributes = user.getElementsByTagName(ATTRIBUTES_TAG);
            int i2 = 0;
            while (i2 < attributes.getLength()) {
                user.removeChild(attributes.item(i2));
                ++i2;
            }
        }
        this.setAttribute(user, UID, profile.getUid());
        this.setAttribute(user, LAST_MODIFIED, this.c_format.format(modDate));
        this.setAttribute(user, LOGIN_NAME, profile.getLoginName());
        this.setAttribute(user, FULL_NAME, profile.getFullname());
        this.setAttribute(user, WIKI_NAME, profile.getWikiName());
        this.setAttribute(user, EMAIL, profile.getEmail());
        Date lockExpiry = profile.getLockExpiry();
        this.setAttribute(user, LOCK_EXPIRY, lockExpiry == null ? "" : this.c_format.format(lockExpiry));
        String newPassword = profile.getPassword();
        if (newPassword != null && !newPassword.equals("") && !(oldPassword = user.getAttribute(PASSWORD)).equals(newPassword)) {
            this.setAttribute(user, PASSWORD, this.getHash(newPassword));
        }
        if (profile.getAttributes().size() > 0) {
            try {
                String encodedAttributes = Serializer.serializeToBase64(profile.getAttributes());
                Element attributes = this.c_dom.createElement(ATTRIBUTES_TAG);
                user.appendChild(attributes);
                Text value = this.c_dom.createTextNode(encodedAttributes);
                attributes.appendChild(value);
            }
            catch (IOException e) {
                throw new WikiSecurityException("Could not save user profile attribute. Reason: " + e.getMessage(), e);
            }
        }
        if (isNew) {
            profile.setCreated(modDate);
        }
        profile.setLastModified(modDate);
        this.saveDOM();
    }

    private UserProfile findByAttribute(String matchAttribute, String index) {
        if (this.c_dom == null) {
            throw new IllegalStateException("FATAL: database does not exist");
        }
        this.checkForRefresh();
        NodeList users = this.c_dom.getElementsByTagName(USER_TAG);
        if (users == null) {
            return null;
        }
        int i = 0;
        while (i < users.getLength()) {
            Element user = (Element)users.item(i);
            if (user.getAttribute(matchAttribute).equals(index)) {
                UserProfile profile = this.newProfile();
                profile.setUid(user.getAttribute(UID));
                if (profile.getUid() == null || profile.getUid().length() == 0) {
                    profile.setUid(XMLUserDatabase.generateUid(this));
                }
                profile.setLoginName(user.getAttribute(LOGIN_NAME));
                profile.setFullname(user.getAttribute(FULL_NAME));
                profile.setPassword(user.getAttribute(PASSWORD));
                profile.setEmail(user.getAttribute(EMAIL));
                String created = user.getAttribute(CREATED);
                String modified = user.getAttribute(LAST_MODIFIED);
                profile.setCreated(this.parseDate(profile, created));
                profile.setLastModified(this.parseDate(profile, modified));
                String lockExpiry = user.getAttribute(LOCK_EXPIRY);
                if (lockExpiry == null || lockExpiry.length() == 0) {
                    profile.setLockExpiry(null);
                } else {
                    profile.setLockExpiry(new Date(Long.parseLong(lockExpiry)));
                }
                NodeList attributes = user.getElementsByTagName(ATTRIBUTES_TAG);
                int j = 0;
                while (j < attributes.getLength()) {
                    Element attribute = (Element)attributes.item(j);
                    String serializedMap = this.extractText(attribute);
                    try {
                        Map<String, ? extends Serializable> map = Serializer.deserializeFromBase64(serializedMap);
                        profile.getAttributes().putAll(map);
                    }
                    catch (IOException e) {
                        log.error("Could not parse user profile attributes!", e);
                    }
                    ++j;
                }
                return profile;
            }
            ++i;
        }
        return null;
    }

    private String extractText(Element element) {
        String text = "";
        if (element.getChildNodes().getLength() > 0) {
            NodeList children = element.getChildNodes();
            int k = 0;
            while (k < children.getLength()) {
                Node child = children.item(k);
                if (child.getNodeType() == 3) {
                    text = String.valueOf(text) + ((Text)child).getData();
                }
                ++k;
            }
        }
        return text;
    }

    private Date parseDate(UserProfile profile, String date) {
        try {
            return this.c_format.parse(date);
        }
        catch (ParseException e) {
            try {
                return this.c_defaultFormat.parse(date);
            }
            catch (ParseException e2) {
                log.warn("Could not parse 'created' or 'lastModified' attribute for  profile '" + profile.getLoginName() + "'." + " It may have been tampered with.", new Object[0]);
                return null;
            }
        }
    }

    private void sanitizeDOM() {
        if (this.c_dom == null) {
            throw new IllegalStateException("FATAL: database does not exist");
        }
        NodeList users = this.c_dom.getElementsByTagName(USER_TAG);
        int i = 0;
        while (i < users.getLength()) {
            Element user = (Element)users.item(i);
            String uid = user.getAttribute(UID).trim();
            if (uid == null || uid.length() == 0 || "-1".equals(uid)) {
                uid = String.valueOf(XMLUserDatabase.generateUid(this));
                user.setAttribute(UID, uid);
            }
            String loginName = user.getAttribute(LOGIN_NAME);
            String created = user.getAttribute(CREATED);
            String modified = user.getAttribute(LAST_MODIFIED);
            try {
                created = this.c_format.format(this.c_format.parse(created));
                modified = this.c_format.format(this.c_format.parse(modified));
                user.setAttribute(CREATED, created);
                user.setAttribute(LAST_MODIFIED, modified);
            }
            catch (ParseException e) {
                try {
                    created = this.c_format.format(this.c_defaultFormat.parse(created));
                    modified = this.c_format.format(this.c_defaultFormat.parse(modified));
                    user.setAttribute(CREATED, created);
                    user.setAttribute(LAST_MODIFIED, modified);
                }
                catch (ParseException e2) {
                    log.warn("Could not parse 'created' or 'lastModified' attribute for  profile '" + loginName + "'." + " It may have been tampered with.", new Object[0]);
                }
            }
            ++i;
        }
    }

    private void setAttribute(Element element, String attribute, String value) {
        if (value != null) {
            element.setAttribute(attribute, value);
        }
    }
}

