/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.user;

import java.security.Principal;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.apache.wiki.NoRequiredPropertyException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.auth.LdapConfig;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.user.AbstractUserDatabase;
import org.apache.wiki.auth.user.DuplicateUserException;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.util.TextUtil;
import org.freshcookies.security.Keychain;

public class LdapUserDatabase
extends AbstractUserDatabase {
    private LdapConfig m_cfg = null;
    private static final String[] REQUIRED_PROPERTIES = new String[]{"ldap.connectionURL", "ldap.userBase"};

    public void deleteByLoginName(String loginName) throws NoSuchPrincipalException, WikiSecurityException {
        throw new WikiSecurityException("Operation not supported");
    }

    public UserProfile findByEmail(String index) throws NoSuchPrincipalException {
        index = LdapConfig.escapeFilterString(index);
        return this.findLdapUser("(&(objectClass=" + this.m_cfg.userObjectClass + ")(mail=" + index + "))");
    }

    public UserProfile findByFullName(String index) throws NoSuchPrincipalException {
        index = LdapConfig.escapeFilterString(index);
        return this.findLdapUser("(&(objectClass=" + this.m_cfg.userObjectClass + ")(cn=" + index + "))");
    }

    public UserProfile findByLoginName(String index) throws NoSuchPrincipalException {
        index = LdapConfig.escapeFilterString(index);
        return this.findLdapUser("(&(objectClass=" + this.m_cfg.userObjectClass + ")(" + this.m_cfg.userLoginNameAttribute + "=" + index + "))");
    }

    public UserProfile findByUid(String uid) throws NoSuchPrincipalException {
        String filter = "(objectClass=" + this.m_cfg.userObjectClass + ")";
        try {
            Hashtable<String, String> env = this.m_cfg.newJndiEnvironment();
            InitialLdapContext ctx = new InitialLdapContext(env, null);
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(new String[]{this.m_cfg.userLoginNameAttribute, "cn", "givenName", "sn", "mail"});
            searchControls.setSearchScope(2);
            NamingEnumeration<SearchResult> results = ctx.search(uid, filter, searchControls);
            if (results.hasMore()) {
                SearchResult user = results.next();
                Attributes attributes = user.getAttributes();
                Attribute loginName = attributes.get(this.m_cfg.userLoginNameAttribute);
                Attribute cn = attributes.get("cn");
                Attribute mail = attributes.get("mail");
                if (loginName == null || cn == null || mail == null) {
                    throw new NamingException("Malformed directory entry; missing cn, mail or uid.");
                }
                UserProfile p = this.newProfile();
                p.setUid(user.getNameInNamespace());
                p.setLoginName(loginName.get(0).toString());
                p.setFullname(LdapConfig.getFullName(user.getAttributes()));
                p.setEmail(mail.get(0).toString());
                return p;
            }
        }
        catch (NamingException e) {
            throw new NoSuchPrincipalException("Could not find object: " + e.getMessage());
        }
        throw new NoSuchPrincipalException("Could not find object.");
    }

    public UserProfile findByWikiName(String index) throws NoSuchPrincipalException {
        index = LdapConfig.escapeFilterString(index);
        index = TextUtil.beautifyString(index);
        return this.findLdapUser("(&(objectClass=" + this.m_cfg.userObjectClass + ")(cn=" + index + "))");
    }

    public Principal[] getWikiNames() throws WikiSecurityException {
        String filter = "(objectClass=" + this.m_cfg.userObjectClass + ")";
        HashSet<WikiPrincipal> principals = new HashSet<WikiPrincipal>();
        try {
            Hashtable<String, String> env = this.m_cfg.newJndiEnvironment();
            InitialLdapContext ctx = new InitialLdapContext(env, null);
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(new String[]{"cn", "givenName", "sn"});
            NamingEnumeration<SearchResult> results = ctx.search(this.m_cfg.userBase, filter, searchControls);
            while (results.hasMore()) {
                SearchResult user = results.next();
                String fullName = LdapConfig.getFullName(user.getAttributes());
                String wikiName = fullName.indexOf(32) == -1 ? fullName : fullName.replace(" ", "");
                principals.add(new WikiPrincipal(wikiName, "wikiName"));
            }
        }
        catch (NamingException e) {
            throw new WikiSecurityException("Could not find object: " + e.getMessage(), e);
        }
        return principals.toArray(new Principal[principals.size()]);
    }

    public void initialize(WikiEngine engine, Properties props) throws NoRequiredPropertyException {
        Keychain keychain = engine.getAuthenticationManager().getKeychain();
        this.m_cfg = LdapConfig.getInstance(keychain, props, REQUIRED_PROPERTIES);
    }

    public void rename(String loginName, String newName) throws NoSuchPrincipalException, DuplicateUserException, WikiSecurityException {
        throw new WikiSecurityException("Operation not supported");
    }

    public void save(UserProfile profile) throws WikiSecurityException {
        throw new WikiSecurityException("Operation not supported");
    }

    public boolean validatePassword(String loginName, String password) {
        Hashtable<String, String> env = this.m_cfg.newJndiEnvironment(loginName, password);
        try {
            new InitialLdapContext(env, null);
            return true;
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    private UserProfile findLdapUser(String filter) throws NoSuchPrincipalException {
        try {
            Hashtable<String, String> env = this.m_cfg.newJndiEnvironment();
            InitialLdapContext ctx = new InitialLdapContext(env, null);
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(new String[]{this.m_cfg.userLoginNameAttribute, "cn", "givenName", "sn", "mail"});
            searchControls.setSearchScope(2);
            NamingEnumeration<SearchResult> results = ctx.search(this.m_cfg.userBase, filter, searchControls);
            if (results.hasMore()) {
                SearchResult user = results.next();
                Attributes attributes = user.getAttributes();
                Attribute loginName = attributes.get(this.m_cfg.userLoginNameAttribute);
                Attribute cn = attributes.get("cn");
                Attribute mail = attributes.get("mail");
                if (loginName == null || cn == null || mail == null) {
                    throw new NamingException("Malformed directory entry; missing cn, mail or uid.");
                }
                UserProfile p = this.newProfile();
                p.setUid(user.getNameInNamespace());
                p.setLoginName(loginName.get(0).toString());
                p.setFullname(LdapConfig.getFullName(user.getAttributes()));
                p.setEmail(mail.get(0).toString());
                return p;
            }
        }
        catch (NamingException e) {
            throw new NoSuchPrincipalException("Could not find object: " + e.getMessage());
        }
        throw new NoSuchPrincipalException("Could not find object.");
    }
}

