/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.user;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.wiki.NoRequiredPropertyException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.user.AbstractUserDatabase;
import org.apache.wiki.auth.user.DuplicateUserException;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.util.Serializer;

public class JDBCUserDatabase
extends AbstractUserDatabase {
    private static final String NOTHING = "";
    public static final String DEFAULT_DB_ATTRIBUTES = "attributes";
    public static final String DEFAULT_DB_CREATED = "created";
    public static final String DEFAULT_DB_EMAIL = "email";
    public static final String DEFAULT_DB_FULL_NAME = "full_name";
    public static final String DEFAULT_DB_JNDI_NAME = "jdbc/UserDatabase";
    public static final String DEFAULT_DB_LOCK_EXPIRY = "lock_expiry";
    public static final String DEFAULT_DB_MODIFIED = "modified";
    public static final String DEFAULT_DB_ROLE = "role";
    public static final String DEFAULT_DB_ROLE_TABLE = "roles";
    public static final String DEFAULT_DB_TABLE = "users";
    public static final String DEFAULT_DB_LOGIN_NAME = "login_name";
    public static final String DEFAULT_DB_PASSWORD = "password";
    public static final String DEFAULT_DB_UID = "uid";
    public static final String DEFAULT_DB_WIKI_NAME = "wiki_name";
    public static final String PROP_DB_ATTRIBUTES = "jspwiki.userdatabase.attributes";
    public static final String PROP_DB_CREATED = "jspwiki.userdatabase.created";
    public static final String PROP_DB_EMAIL = "jspwiki.userdatabase.email";
    public static final String PROP_DB_FULL_NAME = "jspwiki.userdatabase.fullName";
    public static final String PROP_DB_DATASOURCE = "jspwiki.userdatabase.datasource";
    public static final String PROP_DB_LOCK_EXPIRY = "jspwiki.userdatabase.lockExpiry";
    public static final String PROP_DB_LOGIN_NAME = "jspwiki.userdatabase.loginName";
    public static final String PROP_DB_MODIFIED = "jspwiki.userdatabase.modified";
    public static final String PROP_DB_PASSWORD = "jspwiki.userdatabase.password";
    public static final String PROP_DB_UID = "jspwiki.userdatabase.uid";
    public static final String PROP_DB_ROLE = "jspwiki.userdatabase.role";
    public static final String PROP_DB_ROLE_TABLE = "jspwiki.userdatabase.roleTable";
    public static final String PROP_DB_TABLE = "jspwiki.userdatabase.table";
    public static final String PROP_DB_WIKI_NAME = "jspwiki.userdatabase.wikiName";
    private DataSource m_ds = null;
    private String m_deleteUserByLoginName = null;
    private String m_deleteRoleByLoginName = null;
    private String m_findByEmail = null;
    private String m_findByFullName = null;
    private String m_findByLoginName = null;
    private String m_findByUid = null;
    private String m_findByWikiName = null;
    private String m_renameProfile = null;
    private String m_renameRoles = null;
    private String m_updateProfile = null;
    private String m_findAll = null;
    private String m_findRoles = null;
    private String m_initialRole = "Authenticated";
    private String m_insertProfile = null;
    private String m_insertRole = null;
    private String m_userTable = null;
    private String m_attributes = null;
    private String m_email = null;
    private String m_fullName = null;
    private String m_lockExpiry = null;
    private String m_loginName = null;
    private String m_password = null;
    private String m_role = null;
    private String m_roleTable = null;
    private String m_uid = null;
    private String m_wikiName = null;
    private String m_created = null;
    private String m_modified = null;
    private boolean m_supportsCommits = false;

    public void deleteByLoginName(String loginName) throws NoSuchPrincipalException, WikiSecurityException {
        this.findByLoginName(loginName);
        Connection conn = null;
        try {
            try {
                conn = this.m_ds.getConnection();
                if (this.m_supportsCommits) {
                    conn.setAutoCommit(false);
                }
                PreparedStatement ps = conn.prepareStatement(this.m_deleteUserByLoginName);
                ps.setString(1, loginName);
                ps.execute();
                ps.close();
                ps = conn.prepareStatement(this.m_deleteRoleByLoginName);
                ps.setString(1, loginName);
                ps.execute();
                ps.close();
                if (this.m_supportsCommits) {
                    conn.commit();
                }
            }
            catch (SQLException e) {
                throw new WikiSecurityException(e.getMessage(), e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public UserProfile findByEmail(String index) throws NoSuchPrincipalException {
        return this.findByPreparedStatement(this.m_findByEmail, index);
    }

    public UserProfile findByFullName(String index) throws NoSuchPrincipalException {
        return this.findByPreparedStatement(this.m_findByFullName, index);
    }

    public UserProfile findByLoginName(String index) throws NoSuchPrincipalException {
        return this.findByPreparedStatement(this.m_findByLoginName, index);
    }

    public UserProfile findByUid(String uid) throws NoSuchPrincipalException {
        return this.findByPreparedStatement(this.m_findByUid, uid);
    }

    public UserProfile findByWikiName(String index) throws NoSuchPrincipalException {
        return this.findByPreparedStatement(this.m_findByWikiName, index);
    }

    public Principal[] getWikiNames() throws WikiSecurityException {
        HashSet<WikiPrincipal> principals = new HashSet<WikiPrincipal>();
        Connection conn = null;
        try {
            try {
                conn = this.m_ds.getConnection();
                PreparedStatement ps = conn.prepareStatement(this.m_findAll);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    String wikiName = rs.getString(this.m_wikiName);
                    if (wikiName == null) {
                        log.warn("Detected null wiki name in XMLUserDataBase. Check your user database.", new Object[0]);
                        continue;
                    }
                    WikiPrincipal principal = new WikiPrincipal(wikiName, "wikiName");
                    principals.add(principal);
                }
                ps.close();
            }
            catch (SQLException e) {
                throw new WikiSecurityException(e.getMessage(), e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
        return principals.toArray(new Principal[principals.size()]);
    }

    public void initialize(WikiEngine engine, Properties props) throws NoRequiredPropertyException {
        String jndiName = props.getProperty(PROP_DB_DATASOURCE, DEFAULT_DB_JNDI_NAME);
        try {
            InitialContext initCtx = new InitialContext();
            Context ctx = (Context)initCtx.lookup("java:comp/env");
            this.m_ds = (DataSource)ctx.lookup(jndiName);
            this.m_userTable = props.getProperty(PROP_DB_TABLE, DEFAULT_DB_TABLE);
            this.m_email = props.getProperty(PROP_DB_EMAIL, DEFAULT_DB_EMAIL);
            this.m_fullName = props.getProperty(PROP_DB_FULL_NAME, DEFAULT_DB_FULL_NAME);
            this.m_lockExpiry = props.getProperty(PROP_DB_LOCK_EXPIRY, DEFAULT_DB_LOCK_EXPIRY);
            this.m_loginName = props.getProperty(PROP_DB_LOGIN_NAME, DEFAULT_DB_LOGIN_NAME);
            this.m_password = props.getProperty(PROP_DB_PASSWORD, DEFAULT_DB_PASSWORD);
            this.m_uid = props.getProperty(PROP_DB_UID, DEFAULT_DB_UID);
            this.m_wikiName = props.getProperty(PROP_DB_WIKI_NAME, DEFAULT_DB_WIKI_NAME);
            this.m_created = props.getProperty(PROP_DB_CREATED, DEFAULT_DB_CREATED);
            this.m_modified = props.getProperty(PROP_DB_MODIFIED, DEFAULT_DB_MODIFIED);
            this.m_attributes = props.getProperty(PROP_DB_ATTRIBUTES, DEFAULT_DB_ATTRIBUTES);
            this.m_findAll = "SELECT * FROM " + this.m_userTable;
            this.m_findByEmail = "SELECT * FROM " + this.m_userTable + " WHERE " + this.m_email + "=?";
            this.m_findByFullName = "SELECT * FROM " + this.m_userTable + " WHERE " + this.m_fullName + "=?";
            this.m_findByLoginName = "SELECT * FROM " + this.m_userTable + " WHERE " + this.m_loginName + "=?";
            this.m_findByUid = "SELECT * FROM " + this.m_userTable + " WHERE " + this.m_uid + "=?";
            this.m_findByWikiName = "SELECT * FROM " + this.m_userTable + " WHERE " + this.m_wikiName + "=?";
            this.m_insertProfile = "INSERT INTO " + this.m_userTable + " (" + this.m_uid + "," + this.m_email + "," + this.m_fullName + "," + this.m_password + "," + this.m_wikiName + "," + this.m_modified + "," + this.m_loginName + "," + this.m_attributes + "," + this.m_created + ") VALUES (?,?,?,?,?,?,?,?,?)";
            this.m_updateProfile = "UPDATE " + this.m_userTable + " SET " + this.m_uid + "=?," + this.m_email + "=?," + this.m_fullName + "=?," + this.m_password + "=?," + this.m_wikiName + "=?," + this.m_modified + "=?," + this.m_loginName + "=?," + this.m_attributes + "=?," + this.m_lockExpiry + "=? " + "WHERE " + this.m_loginName + "=?";
            this.m_roleTable = props.getProperty(PROP_DB_ROLE_TABLE, DEFAULT_DB_ROLE_TABLE);
            this.m_role = props.getProperty(PROP_DB_ROLE, DEFAULT_DB_ROLE);
            this.m_insertRole = "INSERT INTO " + this.m_roleTable + " (" + this.m_loginName + "," + this.m_role + ") VALUES (?,?)";
            this.m_findRoles = "SELECT * FROM " + this.m_roleTable + " WHERE " + this.m_loginName + "=?";
            this.m_deleteUserByLoginName = "DELETE FROM " + this.m_userTable + " WHERE " + this.m_loginName + "=?";
            this.m_deleteRoleByLoginName = "DELETE FROM " + this.m_roleTable + " WHERE " + this.m_loginName + "=?";
            this.m_renameProfile = "UPDATE " + this.m_userTable + " SET " + this.m_loginName + "=?," + this.m_modified + "=? WHERE " + this.m_loginName + "=?";
            this.m_renameRoles = "UPDATE " + this.m_roleTable + " SET " + this.m_loginName + "=? WHERE " + this.m_loginName + "=?";
        }
        catch (NamingException e) {
            log.error("JDBCUserDatabase initialization error: " + e.getMessage(), new Object[0]);
            throw new NoRequiredPropertyException(PROP_DB_DATASOURCE, "JDBCUserDatabase initialization error: " + e.getMessage());
        }
        Connection conn = null;
        try {
            try {
                conn = this.m_ds.getConnection();
                PreparedStatement ps = conn.prepareStatement(this.m_findAll);
                ps.executeQuery();
                ps.close();
            }
            catch (SQLException e) {
                log.error("JDBCUserDatabase initialization error: " + e.getMessage(), new Object[0]);
                throw new NoRequiredPropertyException(PROP_DB_DATASOURCE, "JDBCUserDatabase initialization error: " + e.getMessage());
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
        log.info("JDBCUserDatabase initialized from JNDI DataSource: " + jndiName, new Object[0]);
        try {
            try {
                conn = this.m_ds.getConnection();
                DatabaseMetaData dmd = conn.getMetaData();
                if (dmd.supportsTransactions()) {
                    this.m_supportsCommits = true;
                    conn.setAutoCommit(false);
                    log.info("JDBCUserDatabase supports transactions. Good; we will use them.", new Object[0]);
                }
            }
            catch (SQLException e) {
                log.warn("JDBCUserDatabase warning: user database doesn't seem to support transactions. Reason: " + e.getMessage(), new Object[0]);
                throw new NoRequiredPropertyException(PROP_DB_DATASOURCE, "JDBCUserDatabase initialization error: " + e.getMessage());
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void rename(String loginName, String newName) throws NoSuchPrincipalException, DuplicateUserException, WikiSecurityException {
        UserProfile profile = this.findByLoginName(loginName);
        try {
            UserProfile otherProfile = this.findByLoginName(newName);
            if (otherProfile != null) {
                throw new DuplicateUserException("Cannot rename: the login name '" + newName + "' is already taken.");
            }
        }
        catch (NoSuchPrincipalException otherProfile) {
            // empty catch block
        }
        Connection conn = null;
        try {
            try {
                conn = this.m_ds.getConnection();
                if (this.m_supportsCommits) {
                    conn.setAutoCommit(false);
                }
                Timestamp ts = new Timestamp(System.currentTimeMillis());
                java.util.Date modDate = new java.util.Date(ts.getTime());
                PreparedStatement ps = conn.prepareStatement(this.m_renameProfile);
                ps.setString(1, newName);
                ps.setTimestamp(2, ts);
                ps.setString(3, loginName);
                ps.execute();
                ps.close();
                ps = conn.prepareStatement(this.m_renameRoles);
                ps.setString(1, newName);
                ps.setString(2, loginName);
                ps.execute();
                ps.close();
                profile.setLoginName(newName);
                profile.setLastModified(modDate);
                if (this.m_supportsCommits) {
                    conn.commit();
                }
            }
            catch (SQLException e) {
                throw new WikiSecurityException(e.getMessage(), e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void save(UserProfile profile) throws WikiSecurityException {
        String existingPassword;
        String loginName = profile.getLoginName();
        PreparedStatement ps = null;
        UserProfile existingProfile = null;
        try {
            existingProfile = this.findByLoginName(loginName);
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
        String password = profile.getPassword();
        String string = existingPassword = existingProfile == null ? null : existingProfile.getPassword();
        if (NOTHING.equals(password)) {
            password = null;
        }
        if (password == null) {
            password = existingPassword;
        }
        if (!password.equals(existingPassword)) {
            password = this.getHash(password);
        }
        Connection conn = null;
        try {
            try {
                Date lockExpiry;
                conn = this.m_ds.getConnection();
                if (this.m_supportsCommits) {
                    conn.setAutoCommit(false);
                }
                Timestamp ts = new Timestamp(System.currentTimeMillis());
                java.util.Date modDate = new java.util.Date(ts.getTime());
                Date date = lockExpiry = profile.getLockExpiry() == null ? null : new Date(profile.getLockExpiry().getTime());
                if (existingProfile == null) {
                    ps = conn.prepareStatement(this.m_insertProfile);
                    ps.setString(1, profile.getUid());
                    ps.setString(2, profile.getEmail());
                    ps.setString(3, profile.getFullname());
                    ps.setString(4, password);
                    ps.setString(5, profile.getWikiName());
                    ps.setTimestamp(6, ts);
                    ps.setString(7, profile.getLoginName());
                    try {
                        ps.setString(8, Serializer.serializeToBase64(profile.getAttributes()));
                    }
                    catch (IOException e) {
                        throw new WikiSecurityException("Could not save user profile attribute. Reason: " + e.getMessage(), e);
                    }
                    ps.setTimestamp(9, ts);
                    ps.execute();
                    ps.close();
                    ps = conn.prepareStatement(this.m_findRoles);
                    ps.setString(1, profile.getLoginName());
                    ResultSet rs = ps.executeQuery();
                    int roles = 0;
                    while (rs.next()) {
                        ++roles;
                    }
                    ps.close();
                    if (roles == 0) {
                        ps = conn.prepareStatement(this.m_insertRole);
                        ps.setString(1, profile.getLoginName());
                        ps.setString(2, this.m_initialRole);
                        ps.execute();
                        ps.close();
                    }
                    profile.setCreated(modDate);
                } else {
                    ps = conn.prepareStatement(this.m_updateProfile);
                    ps.setString(1, profile.getUid());
                    ps.setString(2, profile.getEmail());
                    ps.setString(3, profile.getFullname());
                    ps.setString(4, password);
                    ps.setString(5, profile.getWikiName());
                    ps.setTimestamp(6, ts);
                    ps.setString(7, profile.getLoginName());
                    try {
                        ps.setString(8, Serializer.serializeToBase64(profile.getAttributes()));
                    }
                    catch (IOException e) {
                        throw new WikiSecurityException("Could not save user profile attribute. Reason: " + e.getMessage(), e);
                    }
                    ps.setDate(9, lockExpiry);
                    ps.setString(10, profile.getLoginName());
                    ps.execute();
                    ps.close();
                }
                profile.setLastModified(modDate);
                if (this.m_supportsCommits) {
                    conn.commit();
                }
            }
            catch (SQLException e) {
                throw new WikiSecurityException(e.getMessage(), e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private UserProfile findByPreparedStatement(String sql, Object index) throws NoSuchPrincipalException {
        UserProfile profile = null;
        boolean found = false;
        boolean unique = true;
        Connection conn = null;
        try {
            try {
                conn = this.m_ds.getConnection();
                if (this.m_supportsCommits) {
                    conn.setAutoCommit(false);
                }
                PreparedStatement ps = conn.prepareStatement(sql);
                if (index instanceof String) {
                    ps.setString(1, (String)index);
                } else if (index instanceof Long) {
                    ps.setLong(1, (Long)index);
                } else {
                    throw new IllegalArgumentException("Index type not recognized!");
                }
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    if (profile != null) {
                        unique = false;
                        break;
                    }
                    profile = this.newProfile();
                    profile.setUid(rs.getString(this.m_uid));
                    if (profile.getUid() == null) {
                        profile.setUid(JDBCUserDatabase.generateUid(this));
                    }
                    profile.setCreated(rs.getTimestamp(this.m_created));
                    profile.setEmail(rs.getString(this.m_email));
                    profile.setFullname(rs.getString(this.m_fullName));
                    profile.setLastModified(rs.getTimestamp(this.m_modified));
                    Date lockExpiry = rs.getDate(this.m_lockExpiry);
                    profile.setLockExpiry(rs.wasNull() ? null : lockExpiry);
                    profile.setLoginName(rs.getString(this.m_loginName));
                    profile.setPassword(rs.getString(this.m_password));
                    String rawAttributes = rs.getString(this.m_attributes);
                    if (rawAttributes != null) {
                        try {
                            Map<String, ? extends Serializable> attributes = Serializer.deserializeFromBase64(rawAttributes);
                            profile.getAttributes().putAll(attributes);
                        }
                        catch (IOException e) {
                            log.error("Could not parse user profile attributes!", e);
                        }
                    }
                    found = true;
                }
                ps.close();
            }
            catch (SQLException e) {
                throw new NoSuchPrincipalException(e.getMessage());
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!found) {
            throw new NoSuchPrincipalException("Could not find profile in database!");
        }
        if (!unique) {
            throw new NoSuchPrincipalException("More than one profile in database!");
        }
        return profile;
    }
}

