/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.user;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.wiki.auth.user.AbstractUserDatabase;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.auth.user.UserProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultUserProfile
implements UserProfile {
    private static final long serialVersionUID = -5600466893735300647L;
    private static final String EMPTY_STRING = "";
    private static final String WHITESPACE = "\\s";
    private Map<String, Serializable> m_attributes = new HashMap<String, Serializable>();
    private Date m_created = null;
    private String m_email = null;
    private String m_fullname = null;
    private Date m_lockExpiry = null;
    private String m_loginName = null;
    private Date m_modified = null;
    private String m_password = null;
    private String m_uid = null;
    private String m_wikiname = null;

    private DefaultUserProfile() {
    }

    protected static UserProfile newProfile(UserDatabase db) {
        DefaultUserProfile profile = new DefaultUserProfile();
        profile.setUid(AbstractUserDatabase.generateUid(db));
        return profile;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof UserProfile) {
            DefaultUserProfile u = (DefaultUserProfile)o;
            return this.same(this.m_fullname, u.m_fullname) && this.same(this.m_password, u.m_password) && this.same(this.m_loginName, u.m_loginName) && this.same(this.m_email, u.m_email) && this.same(this.m_wikiname, u.m_wikiname);
        }
        return false;
    }

    public int hashCode() {
        return (this.m_fullname != null ? this.m_fullname.hashCode() : 0) ^ (this.m_password != null ? this.m_password.hashCode() : 0) ^ (this.m_loginName != null ? this.m_loginName.hashCode() : 0) ^ (this.m_wikiname != null ? this.m_wikiname.hashCode() : 0) ^ (this.m_email != null ? this.m_email.hashCode() : 0);
    }

    @Override
    public Date getCreated() {
        return this.m_created;
    }

    @Override
    public String getEmail() {
        return this.m_email;
    }

    @Override
    public String getFullname() {
        return this.m_fullname;
    }

    @Override
    public Date getLastModified() {
        return this.m_modified;
    }

    @Override
    public String getLoginName() {
        return this.m_loginName;
    }

    @Override
    public String getPassword() {
        return this.m_password;
    }

    @Override
    public String getWikiName() {
        return this.m_wikiname;
    }

    @Override
    public boolean isNew() {
        return this.m_modified == null;
    }

    @Override
    public void setCreated(Date date) {
        this.m_created = date;
    }

    @Override
    public void setEmail(String email) {
        this.m_email = email;
    }

    @Override
    public void setFullname(String arg) {
        this.m_fullname = arg;
        if (this.m_fullname != null) {
            this.m_wikiname = this.m_fullname.replaceAll(WHITESPACE, EMPTY_STRING);
        }
    }

    @Override
    public void setLastModified(Date date) {
        this.m_modified = date;
    }

    @Override
    public void setLoginName(String name) {
        this.m_loginName = name;
    }

    @Override
    public void setPassword(String arg) {
        this.m_password = arg;
    }

    @Override
    public void setWikiName(String name) {
    }

    @Override
    public String toString() {
        return "[DefaultUserProfile: '" + this.getFullname() + "']";
    }

    private boolean same(Object arg1, Object arg2) {
        if (arg1 == null && arg2 == null) {
            return true;
        }
        if (arg1 == null || arg2 == null) {
            return false;
        }
        return arg1.equals(arg2);
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        return this.m_attributes;
    }

    @Override
    public Date getLockExpiry() {
        return this.isLocked() ? this.m_lockExpiry : null;
    }

    @Override
    public String getUid() {
        return this.m_uid;
    }

    @Override
    public boolean isLocked() {
        boolean locked;
        boolean bl = locked = this.m_lockExpiry != null && System.currentTimeMillis() < this.m_lockExpiry.getTime();
        if (!locked && this.m_lockExpiry != null) {
            this.m_lockExpiry = null;
        }
        return locked;
    }

    @Override
    public void setLockExpiry(Date expiry) {
        this.m_lockExpiry = expiry;
    }

    @Override
    public void setUid(String uid) {
        this.m_uid = uid;
    }
}

