/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.permissions;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.auth.permissions.AllPermissionCollection;

public final class PagePermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final String COMMENT_ACTION = "comment";
    public static final String DELETE_ACTION = "delete";
    public static final String EDIT_ACTION = "edit";
    public static final String MODIFY_ACTION = "modify";
    public static final String RENAME_ACTION = "rename";
    public static final String UPLOAD_ACTION = "upload";
    public static final String VIEW_ACTION = "view";
    protected static final int COMMENT_MASK = 4;
    protected static final int DELETE_MASK = 16;
    protected static final int EDIT_MASK = 2;
    protected static final int MODIFY_MASK = 64;
    protected static final int RENAME_MASK = 32;
    protected static final int UPLOAD_MASK = 8;
    protected static final int VIEW_MASK = 1;
    public static final PagePermission COMMENT = new PagePermission("comment");
    public static final PagePermission DELETE = new PagePermission("delete");
    public static final PagePermission EDIT = new PagePermission("edit");
    public static final PagePermission RENAME = new PagePermission("rename");
    public static final PagePermission MODIFY = new PagePermission("modify");
    public static final PagePermission UPLOAD = new PagePermission("upload");
    public static final PagePermission VIEW = new PagePermission("view");
    private static final String ACTION_SEPARATOR = ",";
    private static final String WILDCARD = "*";
    private static final String WIKI_SEPARATOR = ":";
    private static final String ATTACHMENT_SEPARATOR = "/";
    private final String m_actionString;
    private final int m_mask;
    private final String m_page;
    private final String m_wiki;

    protected PagePermission() {
        this("");
    }

    private PagePermission(String actions) {
        this("*:*", actions);
    }

    public PagePermission(String page, String actions) {
        super(page);
        String pageName;
        String[] pathParams = StringUtils.split((String)page, (String)WIKI_SEPARATOR);
        if (pathParams.length >= 2) {
            this.m_wiki = pathParams[0].length() > 0 ? pathParams[0] : null;
            pageName = pathParams[1];
        } else {
            this.m_wiki = null;
            pageName = pathParams[0];
        }
        int pos = pageName.indexOf(ATTACHMENT_SEPARATOR);
        this.m_page = pos == -1 ? pageName : pageName.substring(0, pos);
        String[] pageActions = StringUtils.split((String)actions.toLowerCase(), (String)ACTION_SEPARATOR);
        Arrays.sort(pageActions, String.CASE_INSENSITIVE_ORDER);
        this.m_mask = PagePermission.createMask(actions);
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < pageActions.length) {
            buffer.append(pageActions[i]);
            if (i < pageActions.length - 1) {
                buffer.append(ACTION_SEPARATOR);
            }
            ++i;
        }
        this.m_actionString = buffer.toString();
    }

    public PagePermission(WikiPage page, String actions) {
        this(String.valueOf(page.getWiki()) + WIKI_SEPARATOR + page.getName(), actions);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof PagePermission)) {
            return false;
        }
        PagePermission p = (PagePermission)obj;
        return p.m_mask == this.m_mask && p.m_page.equals(this.m_page) && p.m_wiki != null && p.m_wiki.equals(this.m_wiki);
    }

    public final String getActions() {
        return this.m_actionString;
    }

    public final String getPage() {
        return this.m_page;
    }

    public final String getWiki() {
        return this.m_wiki;
    }

    public final int hashCode() {
        String wiki = this.m_wiki != null ? this.m_wiki : "dummy_value";
        return this.m_mask + 13 * this.m_actionString.hashCode() * 23 * wiki.hashCode();
    }

    public final boolean implies(Permission permission) {
        if (!(permission instanceof PagePermission)) {
            return false;
        }
        PagePermission p = (PagePermission)permission;
        int impliedMask = PagePermission.impliedMask(this.m_mask);
        if ((impliedMask & p.m_mask) != p.m_mask) {
            return false;
        }
        boolean impliedWiki = PagePermission.isSubset(this.m_wiki, p.m_wiki);
        boolean impliedPage = PagePermission.isSubset(this.m_page, p.m_page);
        return impliedWiki && impliedPage;
    }

    public PermissionCollection newPermissionCollection() {
        return new AllPermissionCollection();
    }

    public final String toString() {
        String wiki = this.m_wiki == null ? "" : this.m_wiki;
        return "(\"" + this.getClass().getName() + "\",\"" + wiki + WIKI_SEPARATOR + this.m_page + "\",\"" + this.getActions() + "\")";
    }

    protected static final int impliedMask(int mask) {
        if ((mask & 0x10) > 0) {
            mask |= 0x40;
        }
        if ((mask & 0x20) > 0) {
            mask |= 2;
        }
        if ((mask & 0x40) > 0) {
            mask |= 0xA;
        }
        if ((mask & 2) > 0) {
            mask |= 4;
        }
        if ((mask & 4) > 0) {
            mask |= 1;
        }
        if ((mask & 8) > 0) {
            mask |= 1;
        }
        return mask;
    }

    protected static final boolean isSubset(String superSet, String subSet) {
        if (superSet == null || subSet == null) {
            return false;
        }
        if (superSet.equals(subSet)) {
            return true;
        }
        if (superSet.equals(WILDCARD)) {
            return true;
        }
        if (superSet.startsWith(WILDCARD)) {
            String suffix = superSet.substring(1);
            return subSet.endsWith(suffix);
        }
        if (superSet.endsWith(WILDCARD)) {
            String prefix = superSet.substring(0, superSet.length() - 1);
            return subSet.startsWith(prefix);
        }
        return false;
    }

    protected static final int createMask(String actions) {
        String[] actionList;
        if (actions == null || actions.length() == 0) {
            throw new IllegalArgumentException("Actions cannot be blank or null");
        }
        int mask = 0;
        String[] stringArray = actionList = StringUtils.split((String)actions, (String)ACTION_SEPARATOR);
        int n = actionList.length;
        int n2 = 0;
        while (n2 < n) {
            String action = stringArray[n2];
            if (action.equalsIgnoreCase(VIEW_ACTION)) {
                mask |= 1;
            } else if (action.equalsIgnoreCase(EDIT_ACTION)) {
                mask |= 2;
            } else if (action.equalsIgnoreCase(COMMENT_ACTION)) {
                mask |= 4;
            } else if (action.equalsIgnoreCase(MODIFY_ACTION)) {
                mask |= 0x40;
            } else if (action.equalsIgnoreCase(UPLOAD_ACTION)) {
                mask |= 8;
            } else if (action.equalsIgnoreCase(DELETE_ACTION)) {
                mask |= 0x10;
            } else if (action.equalsIgnoreCase(RENAME_ACTION)) {
                mask |= 0x20;
            } else {
                throw new IllegalArgumentException("Unrecognized action: " + action);
            }
            ++n2;
        }
        return mask;
    }
}

