/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.login;

import java.io.IOException;
import java.util.Locale;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.auth.login.HttpRequestCallback;
import org.apache.wiki.auth.login.UserDatabaseCallback;
import org.apache.wiki.auth.login.WikiEngineCallback;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;

public class WikiCallbackHandler
implements CallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(WikiCallbackHandler.class);
    private final HttpServletRequest m_request;
    private final WikiEngine m_engine;
    private final String m_password;
    private final String m_username;

    public WikiCallbackHandler(WikiEngine engine, HttpServletRequest request, String username, String password) {
        this.m_engine = engine;
        this.m_request = request;
        this.m_username = username;
        this.m_password = password;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        int i = 0;
        while (i < callbacks.length) {
            Callback callback = callbacks[i];
            if (callback instanceof HttpRequestCallback) {
                ((HttpRequestCallback)callback).setRequest(this.m_request);
            } else if (callback instanceof WikiEngineCallback && this.m_engine != null) {
                ((WikiEngineCallback)callback).setEngine(this.m_engine);
            } else if (callback instanceof UserDatabaseCallback && this.m_engine != null) {
                ((UserDatabaseCallback)callback).setUserDatabase(this.m_engine.getUserManager().getUserDatabase());
            } else if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.m_username);
            } else if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.m_password.toCharArray());
            } else if (callback instanceof LanguageCallback) {
                ((LanguageCallback)callback).setLocale(this.m_request != null ? this.m_request.getLocale() : Locale.getDefault());
            } else if (callbacks[i] instanceof TextOutputCallback) {
                TextOutputCallback textOutputCb = (TextOutputCallback)callbacks[i];
                String loginResult = textOutputCb.getMessage();
                if (textOutputCb.getMessageType() == 2) {
                    log.error(loginResult, new Object[0]);
                    throw new IOException(loginResult);
                }
                log.info(loginResult, new Object[0]);
            } else {
                throw new UnsupportedCallbackException(callback);
            }
            ++i;
        }
    }
}

