/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.login;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.login.AbstractLoginModule;
import org.apache.wiki.auth.login.HttpRequestCallback;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;

public class WebContainerLoginModule
extends AbstractLoginModule {
    protected static final Logger log = LoggerFactory.getLogger(WebContainerLoginModule.class);

    public boolean login() throws LoginException {
        HttpRequestCallback rcb = new HttpRequestCallback();
        Callback[] callbacks = new Callback[]{rcb};
        String userId = null;
        try {
            this.m_handler.handle(callbacks);
            HttpServletRequest request = rcb.getRequest();
            if (request == null) {
                throw new LoginException("No Http request supplied.");
            }
            HttpSession session = request.getSession(false);
            String sid = session == null ? "(null)" : session.getId();
            Principal principal = request.getUserPrincipal();
            if (principal == null) {
                if (log.isDebugEnabled()) {
                    log.debug("No userPrincipal found for session ID=" + sid, new Object[0]);
                }
                if ((userId = request.getRemoteUser()) == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("No remoteUser found for session ID=" + sid, new Object[0]);
                    }
                    throw new FailedLoginException("No remote user found");
                }
                principal = new WikiPrincipal(userId, "loginName");
            }
            if (log.isDebugEnabled()) {
                log.debug("Logged in container principal " + principal.getName() + ".", new Object[0]);
            }
            this.m_principals.add(principal);
            return true;
        }
        catch (IOException e) {
            log.error("IOException: " + e.getMessage(), new Object[0]);
            return false;
        }
        catch (UnsupportedCallbackException e) {
            log.error("UnsupportedCallbackException: " + e.getMessage(), new Object[0]);
            return false;
        }
    }
}

