/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.login;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.auth.Authorizer;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.login.AuthorizerCallback;
import org.apache.wiki.auth.login.HttpRequestCallback;
import org.apache.wiki.auth.login.WikiEngineCallback;

public final class WebContainerCallbackHandler
implements CallbackHandler {
    private final HttpServletRequest m_request;
    private final WikiEngine m_engine;
    private final Authorizer m_authorizer;

    public WebContainerCallbackHandler(WikiEngine engine, HttpServletRequest request) throws WikiSecurityException {
        this.m_engine = engine;
        this.m_request = request;
        this.m_authorizer = this.m_engine.getAuthorizationManager().getAuthorizer();
    }

    public final void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        int i = 0;
        while (i < callbacks.length) {
            Callback callback = callbacks[i];
            if (callback instanceof HttpRequestCallback) {
                ((HttpRequestCallback)callback).setRequest(this.m_request);
            } else if (callback instanceof AuthorizerCallback) {
                ((AuthorizerCallback)callback).setAuthorizer(this.m_authorizer);
            } else if (callback instanceof WikiEngineCallback) {
                ((WikiEngineCallback)callback).setEngine(this.m_engine);
            } else {
                throw new UnsupportedCallbackException(callback);
            }
            ++i;
        }
    }
}

