/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.login;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.login.AbstractLoginModule;
import org.apache.wiki.auth.login.UserDatabaseCallback;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.i18n.InternationalizationManager;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;

public class UserDatabaseLoginModule
extends AbstractLoginModule {
    private static final InternationalizationManager I18N = new InternationalizationManager(null);
    private static final Logger log = LoggerFactory.getLogger(UserDatabaseLoginModule.class);

    public boolean login() throws LoginException {
        String message;
        block6: {
            NameCallback ncb = new NameCallback("User name");
            PasswordCallback pcb = new PasswordCallback("Password", false);
            UserDatabaseCallback ucb = new UserDatabaseCallback();
            Callback[] callbacks = new Callback[]{ncb, pcb, ucb};
            this.m_handler.handle(callbacks);
            String username = ncb.getName();
            String password = new String(pcb.getPassword());
            UserDatabase db = ucb.getUserDatabase();
            if (db == null) {
                throw new LoginException("No user database: check the callback handler code!");
            }
            if (!db.validatePassword(username, password)) break block6;
            if (log.isDebugEnabled()) {
                log.debug("Logged in user database user " + username, new Object[0]);
            }
            this.m_principals.add(new WikiPrincipal(username, "loginName"));
            return true;
        }
        try {
            throw new FailedLoginException(I18N.get("CoreResources", this.m_locale, "login.error.password"));
        }
        catch (IOException e) {
            message = "IO exception; disallowing login.";
            log.error(message, e);
            throw new LoginException(message);
        }
        catch (UnsupportedCallbackException e) {
            message = "Unable to handle callback; disallowing login.";
            log.error(message, e);
            throw new LoginException(message);
        }
    }
}

